/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vjson.CharStream;
import vjson.JSON;
import vjson.cs.IncludeCharStream;
import vjson.cs.LineColCharStream;
import vjson.parser.ObjectParser;
import vjson.parser.ParserOptions;
import vjson.pl.ASTGen;
import vjson.pl.Interpreter;
import vjson.pl.ast.Statement;
import vjson.pl.type.lang.Types;
import vjson.util.Manager;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0005J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0014\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lvjson/pl/InterpreterBuilder;", "", "()V", "types", "", "Lvjson/pl/type/lang/Types;", "addTypes", "compile", "Lvjson/pl/Interpreter;", "prog", "", "filename", "json", "Lvjson/JSON$Object;", "Lvjson/util/Manager;", "mainName", "interpreter", "ast", "", "Lvjson/pl/ast/Statement;", "Companion", "vjson"})
public final class InterpreterBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Types> types = new ArrayList();

    @NotNull
    public final InterpreterBuilder addTypes(@NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        this.types.add(types);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Interpreter compile(@NotNull String prog, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)prog, (String)"prog");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        ObjectParser jsonParser = new ObjectParser(Companion.interpreterOptions());
        Object t = jsonParser.last(new LineColCharStream(CharStream.Companion.from(prog), filename, null, 4, null));
        Intrinsics.checkNotNull(t);
        JSON.Object json = (JSON.Object)t;
        return this.compile(json);
    }

    public static /* synthetic */ Interpreter compile$default(InterpreterBuilder interpreterBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return interpreterBuilder.compile(string, string2);
    }

    @NotNull
    public final Interpreter compile(@NotNull JSON.Object json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        ASTGen astGen = new ASTGen(json);
        return this.interpreter(astGen.parse());
    }

    @NotNull
    public final Interpreter compile(@NotNull Manager<String> prog, @NotNull String mainName) {
        Intrinsics.checkNotNullParameter(prog, (String)"prog");
        Intrinsics.checkNotNullParameter((Object)mainName, (String)"mainName");
        ObjectParser jsonParser = new ObjectParser(Companion.interpreterOptions());
        Object t = jsonParser.last(new IncludeCharStream(prog, mainName));
        Intrinsics.checkNotNull(t);
        JSON.Object json = (JSON.Object)t;
        return this.compile(json);
    }

    @NotNull
    public final Interpreter interpreter(@NotNull List<? extends Statement> ast) {
        Intrinsics.checkNotNullParameter(ast, (String)"ast");
        return new Interpreter(this.types, ast);
    }

    @JvmOverloads
    @NotNull
    public final Interpreter compile(@NotNull String prog) {
        Intrinsics.checkNotNullParameter((Object)prog, (String)"prog");
        return InterpreterBuilder.compile$default(this, prog, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lvjson/pl/InterpreterBuilder$Companion;", "", "()V", "interpreterOptions", "Lvjson/parser/ParserOptions;", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParserOptions interpreterOptions() {
            return new ParserOptions().setStringSingleQuotes(true).setKeyNoQuotes(true).setKeyNoQuotesAnyChar(true).setAllowSkippingCommas(true).setAllowObjectEntryWithoutValue(true).setAllowOmittingColonBeforeBraces(true).setEqualAsColon(true).setSemicolonAsComma(true).setStringValueNoQuotes(true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

