/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.cs.LineCol;
import vjson.pl.ast.BinOp;
import vjson.pl.ast.BinOpType;
import vjson.pl.ast.Expr;
import vjson.pl.token.TokenType;
import vjson.util.collection.Stack;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lvjson/pl/ParserContext;", "", "parent", "beginToken", "Lvjson/pl/token/TokenType;", "(Lvjson/pl/ParserContext;Lvjson/pl/token/TokenType;)V", "getBeginToken", "()Lvjson/pl/token/TokenType;", "ends", "", "getEnds", "()Z", "setEnds", "(Z)V", "exprStack", "Lvjson/util/collection/Stack;", "Lvjson/pl/ast/Expr;", "getExprStack", "()Lvjson/util/collection/Stack;", "opStack", "Lvjson/pl/ParserContext$OpInfo;", "getOpStack", "getParent", "()Lvjson/pl/ParserContext;", "unaryOpStack", "getUnaryOpStack", "foldBinOp", "", "precedence", "", "OpInfo", "vjson"})
public final class ParserContext {
    @Nullable
    private final ParserContext parent;
    @Nullable
    private final TokenType beginToken;
    @NotNull
    private final Stack<Expr> exprStack;
    @NotNull
    private final Stack<OpInfo> opStack;
    @NotNull
    private final Stack<Object> unaryOpStack;
    private boolean ends;

    public ParserContext(@Nullable ParserContext parent, @Nullable TokenType beginToken) {
        this.parent = parent;
        this.beginToken = beginToken;
        this.exprStack = new Stack();
        this.opStack = new Stack();
        this.unaryOpStack = new Stack();
    }

    @Nullable
    public final ParserContext getParent() {
        return this.parent;
    }

    @Nullable
    public final TokenType getBeginToken() {
        return this.beginToken;
    }

    @NotNull
    public final Stack<Expr> getExprStack() {
        return this.exprStack;
    }

    @NotNull
    public final Stack<OpInfo> getOpStack() {
        return this.opStack;
    }

    @NotNull
    public final Stack<Object> getUnaryOpStack() {
        return this.unaryOpStack;
    }

    public final boolean getEnds() {
        return this.ends;
    }

    public final void setEnds(boolean bl) {
        this.ends = bl;
    }

    public final void foldBinOp(int precedence) {
        OpInfo op;
        if (!this.unaryOpStack.isEmpty()) {
            return;
        }
        while (!this.opStack.isEmpty() && (op = this.opStack.peek()).getType().getPrecedence() >= precedence) {
            this.opStack.pop();
            Expr right = this.exprStack.pop();
            Expr left = this.exprStack.pop();
            BinOp binOp = new BinOp(op.getType(), left, right);
            binOp.setLineCol(op.getLineCol());
            this.exprStack.push(binOp);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lvjson/pl/ParserContext$OpInfo;", "", "type", "Lvjson/pl/ast/BinOpType;", "lineCol", "Lvjson/cs/LineCol;", "(Lvjson/pl/ast/BinOpType;Lvjson/cs/LineCol;)V", "getLineCol", "()Lvjson/cs/LineCol;", "getType", "()Lvjson/pl/ast/BinOpType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vjson"})
    public static final class OpInfo {
        @NotNull
        private final BinOpType type;
        @NotNull
        private final LineCol lineCol;

        public OpInfo(@NotNull BinOpType type, @NotNull LineCol lineCol) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
            this.type = type;
            this.lineCol = lineCol;
        }

        @NotNull
        public final BinOpType getType() {
            return this.type;
        }

        @NotNull
        public final LineCol getLineCol() {
            return this.lineCol;
        }

        @NotNull
        public final BinOpType component1() {
            return this.type;
        }

        @NotNull
        public final LineCol component2() {
            return this.lineCol;
        }

        @NotNull
        public final OpInfo copy(@NotNull BinOpType type, @NotNull LineCol lineCol) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
            return new OpInfo(type, lineCol);
        }

        public static /* synthetic */ OpInfo copy$default(OpInfo opInfo, BinOpType binOpType, LineCol lineCol, int n, Object object) {
            if ((n & 1) != 0) {
                binOpType = opInfo.type;
            }
            if ((n & 2) != 0) {
                lineCol = opInfo.lineCol;
            }
            return opInfo.copy(binOpType, lineCol);
        }

        @NotNull
        public String toString() {
            return "OpInfo(type=" + (Object)((Object)this.type) + ", lineCol=" + this.lineCol + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.lineCol.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpInfo)) {
                return false;
            }
            OpInfo opInfo = (OpInfo)other;
            if (this.type != opInfo.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lineCol, (Object)opInfo.lineCol);
        }
    }
}

