/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.ex.ParserException;
import vjson.pl.ast.ClassDefinition;
import vjson.pl.ast.ErrorHandlingStatement;
import vjson.pl.ast.Modifiers;
import vjson.pl.ast.Statement;
import vjson.pl.ast.TemplateTypeInstantiation;
import vjson.pl.ast.VariableDefinition;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.RuntimeMemory;
import vjson.pl.type.ArrayTypeInstance;
import vjson.pl.type.BoolType;
import vjson.pl.type.ClassTypeInstance;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.MemoryAllocator;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.lang.CollectionType;
import vjson.pl.type.lang.MapType;
import vjson.simple.SimpleBool;
import vjson.simple.SimpleDouble;
import vjson.simple.SimpleInteger;
import vjson.simple.SimpleLong;
import vjson.simple.SimpleNull;
import vjson.simple.SimpleString;
import vjson.util.ArrayBuilder;
import vjson.util.ObjectBuilder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\f\b\u0002\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012H\u0007J$\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\f2\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J8\u0010\u001a\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\f2\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\b\u0002\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012H\u0007J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fJ\u001c\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0001H\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010$\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lvjson/pl/RuntimeMemoryExplorer;", "", "builder", "Lvjson/pl/RuntimeMemoryExplorer$Builder;", "(Lvjson/pl/RuntimeMemoryExplorer$Builder;)V", "getExplorerByType", "name", "", "getExplorerByVariable", "getModifiersOfVariable", "Lvjson/pl/ast/Modifiers;", "getTypeByVariable", "Lvjson/pl/type/TypeInstance;", "getVariable", "mem", "Lvjson/pl/inst/RuntimeMemory;", "inspect", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "", "indent", "", "inspectComplexValue", "v", "type", "inspectValue", "addPreIndent", "", "inspectVariable", "listVariables", "", "refToJsonInstance", "Lvjson/JSON$Instance;", "toJson", "Lvjson/JSON$Object;", "toJsonInstance", "Builder", "vjson"})
public final class RuntimeMemoryExplorer {
    @NotNull
    private final Builder builder;

    public RuntimeMemoryExplorer(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
    }

    @NotNull
    public final RuntimeMemoryExplorer getExplorerByType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RuntimeMemoryExplorer runtimeMemoryExplorer = this.builder.getExplorerByType$vjson(name);
        if (runtimeMemoryExplorer == null) {
            throw new NoSuchElementException();
        }
        return runtimeMemoryExplorer;
    }

    @Nullable
    public final RuntimeMemoryExplorer getExplorerByVariable(@NotNull String name) {
        RuntimeMemoryExplorer runtimeMemoryExplorer;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.builder.getVariableTypes().get(name);
        if (object == null) {
            throw new NoSuchElementException(name);
        }
        Object object2 = object;
        TypeInstance type = object2;
        if (type instanceof ClassTypeInstance) {
            object = ((ClassTypeInstance)type).get_concreteTypeName();
            Object clsName = object == null ? ((ClassTypeInstance)type).getCls().getName() : object;
            runtimeMemoryExplorer = this.builder.getExplorerByType$vjson((String)clsName);
        } else {
            runtimeMemoryExplorer = null;
        }
        return runtimeMemoryExplorer;
    }

    @NotNull
    public final List<String> listVariables() {
        return new ArrayList(this.builder.getVariableOrder());
    }

    @NotNull
    public final Modifiers getModifiersOfVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Modifiers modifiers = this.builder.getVariableModifiers().get(name);
        if (modifiers == null) {
            throw new NoSuchElementException(name);
        }
        return modifiers;
    }

    @Nullable
    public final Object getVariable(@NotNull String name, @NotNull RuntimeMemory mem) {
        Object ret2;
        TypeInstance typeInstance;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        Object object = this.builder.getVariableTypes().get(name);
        if (object == null) {
            throw new NoSuchElementException(name);
        }
        TypeInstance type = typeInstance = object;
        Integer n = this.builder.getVariableIndexes().get(name);
        Intrinsics.checkNotNull((Object)n);
        object = n;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.variableIndexes[name]!!");
        int index = ((Number)object).intValue();
        object = type;
        return object instanceof IntType ? Integer.valueOf(mem.getInt(index)) : (object instanceof LongType ? Long.valueOf(mem.getLong(index)) : (object instanceof FloatType ? Float.valueOf(mem.getFloat(index)) : (object instanceof DoubleType ? Double.valueOf(mem.getDouble(index)) : (object instanceof BoolType ? Boolean.valueOf(mem.getBool(index)) : ((ret2 = mem.getRef(index)) instanceof ActionContext ? ((ActionContext)ret2).getCurrentMem() : ret2)))));
    }

    @NotNull
    public final TypeInstance getTypeByVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TypeInstance typeInstance = this.builder.getVariableTypes().get(name);
        if (typeInstance == null) {
            throw new NoSuchElementException(name);
        }
        return typeInstance;
    }

    @NotNull
    public final JSON.Object toJson(@NotNull RuntimeMemory mem) {
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        ObjectBuilder o = new ObjectBuilder();
        for (String f : this.builder.getVariableOrder()) {
            TypeInstance typeInstance;
            Modifiers modifiers = this.builder.getVariableModifiers().get(f);
            Intrinsics.checkNotNull((Object)modifiers);
            if (!modifiers.isPublic()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
            Object v = this.getVariable(f, mem);
            Intrinsics.checkNotNull((Object)this.builder.getVariableTypes().get(f));
            Intrinsics.checkNotNullExpressionValue((Object)typeInstance, (String)"builder.variableTypes[f]!!");
            TypeInstance type = typeInstance;
            o.putInst(f, this.toJsonInstance(type, v));
        }
        return o.build();
    }

    private final JSON.Instance<?> toJsonInstance(TypeInstance type, Object v) {
        Object object = v;
        return object == null ? (JSON.Instance)SimpleNull.Null : (object instanceof Integer ? (JSON.Instance)new SimpleInteger(((Number)v).intValue(), null, 2, null) : (object instanceof Long ? (JSON.Instance)new SimpleLong(((Number)v).longValue(), null, 2, null) : (object instanceof Float ? (JSON.Instance)new SimpleDouble(((Number)v).floatValue(), null, 2, null) : (object instanceof Double ? (JSON.Instance)new SimpleDouble(((Number)v).doubleValue(), null, 2, null) : (object instanceof Boolean ? (JSON.Instance)new SimpleBool((Boolean)v, null, 2, null) : (object instanceof String ? (JSON.Instance)new SimpleString((String)v, null, 2, null) : this.refToJsonInstance(type, v)))))));
    }

    private final JSON.Instance<?> refToJsonInstance(TypeInstance type, Object v) {
        JSON.Instance instance;
        TypeInstance typeInstance = type;
        if (typeInstance instanceof ClassTypeInstance) {
            String string = ((ClassTypeInstance)type).get_concreteTypeName();
            RuntimeMemoryExplorer runtimeMemoryExplorer = this.builder.getExplorerByType$vjson(string == null ? ((ClassTypeInstance)type).getCls().getName() : string);
            if (runtimeMemoryExplorer == null) {
                throw new ParserException("unable to convert the instance to json, class definition " + ((ClassTypeInstance)type).getCls().getName() + " is not found");
            }
            RuntimeMemoryExplorer explorer = runtimeMemoryExplorer;
            instance = explorer.toJson((RuntimeMemory)v);
        } else if (typeInstance instanceof ArrayTypeInstance) {
            ArrayBuilder array = new ArrayBuilder();
            TypeInstance elementType = ((ArrayTypeInstance)type).elementType(new TypeContext(new MemoryAllocator()));
            if (elementType instanceof IntType) {
                int[] cfr_ignored_0 = (int[])v;
                for (int n : (int[])v) {
                    array.add(n);
                }
            } else if (elementType instanceof LongType) {
                long[] cfr_ignored_1 = (long[])v;
                for (long n : (long[])v) {
                    array.add(n);
                }
            } else if (elementType instanceof FloatType) {
                int[] cfr_ignored_2 = (int[])v;
                for (int n : (int[])v) {
                    array.add(n);
                }
            } else if (elementType instanceof DoubleType) {
                int[] cfr_ignored_3 = (int[])v;
                for (int n : (int[])v) {
                    array.add(n);
                }
            } else if (elementType instanceof BoolType) {
                int[] cfr_ignored_4 = (int[])v;
                for (int n : (int[])v) {
                    array.add(n);
                }
            } else {
                Object[] cfr_ignored_5 = (Object[])v;
                for (Object n : (Object[])v) {
                    Object e = n instanceof ActionContext ? ((ActionContext)n).getCurrentMem() : n;
                    array.addInst(this.toJsonInstance(elementType, e));
                }
            }
            instance = array.build();
        } else {
            throw new ParserException("unable to convert the instance to json, " + type + " does not support conversion");
        }
        return instance;
    }

    @JvmOverloads
    @NotNull
    public final StringBuilder inspect(@NotNull RuntimeMemory mem, @NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        this.inspect(mem, sb, 0);
        StringBuilder stringBuilder = sb;
        int n = sb.length() - 1;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.deleteCharAt(n), (String)"this.deleteCharAt(index)");
        return sb;
    }

    public static /* synthetic */ StringBuilder inspect$default(RuntimeMemoryExplorer runtimeMemoryExplorer, RuntimeMemory runtimeMemory, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return runtimeMemoryExplorer.inspect(runtimeMemory, stringBuilder);
    }

    @JvmOverloads
    @NotNull
    public final StringBuilder inspectVariable(@NotNull String name, @NotNull RuntimeMemory mem, @NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Object v = this.getVariable(name, mem);
        TypeInstance typeInstance = this.builder.getVariableTypes().get(name);
        Intrinsics.checkNotNull((Object)typeInstance);
        Object object = typeInstance;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.variableTypes[name]!!");
        TypeInstance type = object;
        RuntimeMemoryExplorer.inspectValue$default(this, v, type, sb, 0, false, 16, null);
        object = sb;
        int n = sb.length() - 1;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).deleteCharAt(n), (String)"this.deleteCharAt(index)");
        return sb;
    }

    public static /* synthetic */ StringBuilder inspectVariable$default(RuntimeMemoryExplorer runtimeMemoryExplorer, String string, RuntimeMemory runtimeMemory, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 4) != 0) {
            stringBuilder = new StringBuilder();
        }
        return runtimeMemoryExplorer.inspectVariable(string, runtimeMemory, stringBuilder);
    }

    private final void inspect(RuntimeMemory mem, StringBuilder sb, int indent) {
        for (String name : this.builder.getVariableOrder()) {
            TypeInstance typeInstance;
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent));
            Modifiers modifiers = this.builder.getVariableModifiers().get(name);
            Intrinsics.checkNotNull((Object)modifiers);
            String modifiers2 = modifiers.toStringWithSpace();
            sb.append(modifiers2).append(name).append(" = ");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            Object v = this.getVariable(name, mem);
            Intrinsics.checkNotNull((Object)this.builder.getVariableTypes().get(name));
            Intrinsics.checkNotNullExpressionValue((Object)typeInstance, (String)"builder.variableTypes[name]!!");
            TypeInstance type = typeInstance;
            RuntimeMemoryExplorer.inspectValue$default(this, v, type, sb, indent, false, 16, null);
        }
    }

    private final void inspectValue(Object v, TypeInstance type, StringBuilder sb, int indent, boolean addPreIndent) {
        Object object;
        if (addPreIndent) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent));
        }
        if (((((((object = v) == null ? true : object instanceof Integer) ? true : Intrinsics.areEqual((Object)object, (Object)LongCompanionObject.INSTANCE)) ? true : object instanceof Long) ? true : object instanceof Float) ? true : object instanceof Double) ? true : object instanceof Boolean) {
            sb.append(v).append("\n");
        } else if (object instanceof String) {
            sb.append(new SimpleString((String)v, null, 2, null).stringify()).append("\n");
        } else {
            this.inspectComplexValue(v, type, sb, indent);
        }
    }

    static /* synthetic */ void inspectValue$default(RuntimeMemoryExplorer runtimeMemoryExplorer, Object object, TypeInstance typeInstance, StringBuilder stringBuilder, int n, boolean bl, int n2, Object object2) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        runtimeMemoryExplorer.inspectValue(object, typeInstance, stringBuilder, n, bl);
    }

    private final void inspectComplexValue(Object v, TypeInstance type, StringBuilder sb, int indent) {
        TypeInstance typeInstance = type;
        if (typeInstance instanceof ClassTypeInstance) {
            String string = ((ClassTypeInstance)type).get_concreteTypeName();
            String tName = string == null ? ((ClassTypeInstance)type).getCls().getName() : string;
            RuntimeMemoryExplorer explorer = this.builder.getExplorerByType$vjson(tName);
            if (explorer == null) {
                sb.append("<no info: " + tName + ' ' + v + ">\n");
            } else {
                sb.append("{\n");
                explorer.inspect((RuntimeMemory)v, sb, indent + 2);
                sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}\n");
            }
        } else if (typeInstance instanceof ArrayTypeInstance) {
            sb.append("[\n");
            TypeInstance elementType = ((ArrayTypeInstance)type).elementType(new TypeContext(new MemoryAllocator()));
            if (v instanceof int[]) {
                for (int e : (int[])v) {
                    this.inspectValue(e, elementType, sb, indent + 2, true);
                }
            } else if (v instanceof long[]) {
                for (long e : (long[])v) {
                    this.inspectValue(e, elementType, sb, indent + 2, true);
                }
            } else if (v instanceof float[]) {
                for (float e : (float[])v) {
                    this.inspectValue(Float.valueOf(e), elementType, sb, indent + 2, true);
                }
            } else if (v instanceof double[]) {
                for (double e : (double[])v) {
                    this.inspectValue(e, elementType, sb, indent + 2, true);
                }
            } else if (v instanceof boolean[]) {
                for (boolean e : (boolean[])v) {
                    this.inspectValue(e, elementType, sb, indent + 2, true);
                }
            } else {
                Object[] cfr_ignored_0 = (Object[])v;
                for (Object n : (Object[])v) {
                    Object e = n instanceof ActionContext ? ((ActionContext)n).getCurrentMem() : n;
                    this.inspectValue(e, elementType, sb, indent + 2, true);
                }
            }
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("]\n");
        } else if (typeInstance instanceof CollectionType) {
            Object explorer = ((RuntimeMemory)v).getRef(0);
            if (explorer == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<*>");
            }
            Collection coll = (Collection)explorer;
            List<TypeInstance> list = type.templateTypeParams();
            Intrinsics.checkNotNull(list);
            TypeInstance elementType = list.get(0);
            sb.append("[\n");
            for (Object n : coll) {
                Object e = n instanceof ActionContext ? ((ActionContext)n).getCurrentMem() : n;
                this.inspectValue(e, elementType, sb, indent + 2, true);
            }
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("]\n");
        } else if (typeInstance instanceof MapType) {
            Object elementType = ((RuntimeMemory)v).getRef(0);
            if (elementType == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            }
            Map map = (Map)elementType;
            List<TypeInstance> list = type.templateTypeParams();
            Intrinsics.checkNotNull(list);
            TypeInstance keyType = list.get(0);
            List<TypeInstance> list2 = type.templateTypeParams();
            Intrinsics.checkNotNull(list2);
            TypeInstance valueType = list2.get(1);
            sb.append("{\n");
            Object object = map;
            boolean e = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl = false;
                Object key = object2.getKey();
                Object object3 = object;
                boolean bl2 = false;
                Object value = object3.getValue();
                sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2)));
                Object k = key instanceof ActionContext ? ((ActionContext)key).getCurrentMem() : key;
                RuntimeMemoryExplorer.inspectValue$default(this, k, keyType, sb, indent + 2, false, 16, null);
                StringBuilder stringBuilder = sb;
                int n = sb.length() - 1;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.deleteCharAt(n), (String)"this.deleteCharAt(index)");
                sb.append(" = ");
                Object vv = value instanceof ActionContext ? ((ActionContext)value).getCurrentMem() : value;
                RuntimeMemoryExplorer.inspectValue$default(this, vv, valueType, sb, indent + 2, false, 16, null);
            }
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}\n");
        } else {
            sb.append("<no info: " + type + ' ' + v + '>');
        }
    }

    @JvmOverloads
    @NotNull
    public final StringBuilder inspect(@NotNull RuntimeMemory mem) {
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        return RuntimeMemoryExplorer.inspect$default(this, mem, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final StringBuilder inspectVariable(@NotNull String name, @NotNull RuntimeMemory mem) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        return RuntimeMemoryExplorer.inspectVariable$default(this, name, mem, null, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u001b\u001a\u00020\u0007J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0002J\u0017\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b,R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR-\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR!\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0014j\b\u0012\u0004\u0012\u00020\u0006`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R-\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0019`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\n\u00a8\u0006-"}, d2={"Lvjson/pl/RuntimeMemoryExplorer$Builder;", "", "parent", "(Lvjson/pl/RuntimeMemoryExplorer$Builder;)V", "classes", "Ljava/util/HashMap;", "", "Lvjson/pl/RuntimeMemoryExplorer;", "Lkotlin/collections/HashMap;", "getClasses", "()Ljava/util/HashMap;", "getParent", "()Lvjson/pl/RuntimeMemoryExplorer$Builder;", "variableIndexes", "", "getVariableIndexes", "variableModifiers", "Lvjson/pl/ast/Modifiers;", "getVariableModifiers", "variableOrder", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getVariableOrder", "()Ljava/util/ArrayList;", "variableTypes", "Lvjson/pl/type/TypeInstance;", "getVariableTypes", "build", "feed", "", "ast", "", "Lvjson/pl/ast/Statement;", "feedClassDef", "clsDef", "Lvjson/pl/ast/ClassDefinition;", "feedTemplateTypeInstantiation", "let", "Lvjson/pl/ast/TemplateTypeInstantiation;", "feedVariableDef", "varDef", "Lvjson/pl/ast/VariableDefinition;", "getExplorerByType", "name", "getExplorerByType$vjson", "vjson"})
    public static final class Builder {
        @Nullable
        private final Builder parent;
        @NotNull
        private final HashMap<String, RuntimeMemoryExplorer> classes;
        @NotNull
        private final HashMap<String, TypeInstance> variableTypes;
        @NotNull
        private final HashMap<String, Integer> variableIndexes;
        @NotNull
        private final HashMap<String, Modifiers> variableModifiers;
        @NotNull
        private final ArrayList<String> variableOrder;

        public Builder(@Nullable Builder parent) {
            this.parent = parent;
            this.classes = new HashMap();
            this.variableTypes = new HashMap();
            this.variableIndexes = new HashMap();
            this.variableModifiers = new HashMap();
            this.variableOrder = new ArrayList();
        }

        public /* synthetic */ Builder(Builder builder, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                builder = null;
            }
            this(builder);
        }

        @Nullable
        public final Builder getParent() {
            return this.parent;
        }

        @NotNull
        public final HashMap<String, RuntimeMemoryExplorer> getClasses() {
            return this.classes;
        }

        @NotNull
        public final HashMap<String, TypeInstance> getVariableTypes() {
            return this.variableTypes;
        }

        @NotNull
        public final HashMap<String, Integer> getVariableIndexes() {
            return this.variableIndexes;
        }

        @NotNull
        public final HashMap<String, Modifiers> getVariableModifiers() {
            return this.variableModifiers;
        }

        @NotNull
        public final ArrayList<String> getVariableOrder() {
            return this.variableOrder;
        }

        @NotNull
        public final RuntimeMemoryExplorer build() {
            return new RuntimeMemoryExplorer(this);
        }

        public final void feed(@NotNull List<? extends Statement> ast) {
            Intrinsics.checkNotNullParameter(ast, (String)"ast");
            for (Statement statement : ast) {
                Statement statement2 = statement;
                if (statement2 instanceof ClassDefinition) {
                    this.feedClassDef((ClassDefinition)statement);
                    continue;
                }
                if (statement2 instanceof TemplateTypeInstantiation) {
                    this.feedTemplateTypeInstantiation((TemplateTypeInstantiation)statement);
                    continue;
                }
                if (statement2 instanceof VariableDefinition) {
                    this.feedVariableDef((VariableDefinition)statement);
                    continue;
                }
                if (!(statement2 instanceof ErrorHandlingStatement)) continue;
                this.feed(((ErrorHandlingStatement)statement).getTryCode());
            }
        }

        private final void feedTemplateTypeInstantiation(TemplateTypeInstantiation let) {
            Builder builder = new Builder(this);
            TypeInstance typeInstance = let.getInstantiatedTypeInstance();
            Intrinsics.checkNotNull((Object)typeInstance);
            TypeInstance instantiated = typeInstance;
            if (!(instantiated instanceof ClassTypeInstance)) {
                return;
            }
            builder.feed(((ClassTypeInstance)instantiated).getCls().getCode());
            Map map = this.classes;
            String string = let.getTypeName();
            RuntimeMemoryExplorer runtimeMemoryExplorer = builder.build();
            boolean bl = false;
            map.put(string, runtimeMemoryExplorer);
        }

        private final void feedClassDef(ClassDefinition clsDef) {
            Builder builder = new Builder(this);
            builder.feed(clsDef.getCode());
            RuntimeMemoryExplorer explorer = builder.build();
            Map map = this.classes;
            String string = clsDef.getName();
            boolean bl = false;
            map.put(string, explorer);
        }

        private final void feedVariableDef(VariableDefinition varDef) {
            Map map = this.variableTypes;
            String string = varDef.getName();
            Object object = varDef.typeInstance();
            boolean bl = false;
            map.put(string, object);
            map = this.variableIndexes;
            string = varDef.getName();
            object = varDef.getVariableIndex();
            bl = false;
            map.put(string, object);
            map = this.variableModifiers;
            string = varDef.getName();
            object = varDef.getModifiers();
            bl = false;
            map.put(string, object);
            this.variableOrder.add(varDef.getName());
        }

        @Nullable
        public final RuntimeMemoryExplorer getExplorerByType$vjson(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RuntimeMemoryExplorer ret2 = this.classes.get(name);
            if (ret2 != null) {
                return ret2;
            }
            if (this.parent != null) {
                return this.parent.getExplorerByType$vjson(name);
            }
            return null;
        }

        public Builder() {
            this(null, 1, null);
        }
    }
}

