/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vjson.CharStream;
import vjson.JSON;
import vjson.Stringifier;
import vjson.parser.ParserOptions;
import vjson.parser.ParserUtils;
import vjson.util.PrintableChars;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lvjson/pl/ScriptifyContext;", "", "indent", "", "(I)V", "currentIndent", "<set-?>", "", "isTopLevel", "()Z", "appendIndent", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "decreaseIndent", "increaseIndent", "unsetTopLevel", "Companion", "vjson"})
public final class ScriptifyContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int indent;
    private int currentIndent;
    private boolean isTopLevel;
    @NotNull
    private static final Stringifier.StringOptions stringifyStringOptions;

    public ScriptifyContext(int indent) {
        this.indent = indent;
        this.isTopLevel = true;
    }

    public final boolean isTopLevel() {
        return this.isTopLevel;
    }

    public final void unsetTopLevel() {
        this.isTopLevel = false;
    }

    public final void increaseIndent() {
        ScriptifyContext scriptifyContext = this;
        scriptifyContext.currentIndent += this.indent;
    }

    public final void decreaseIndent() {
        if (this.currentIndent - this.indent < 0) {
            throw new IllegalStateException();
        }
        ScriptifyContext scriptifyContext = this;
        scriptifyContext.currentIndent -= this.indent;
    }

    public final void appendIndent(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        int n = 0;
        int n2 = this.currentIndent;
        if (n < n2) {
            do {
                int i = n++;
                builder.append(" ");
            } while (n < n2);
        }
    }

    static {
        Stringifier.StringOptions.Builder builder = new Stringifier.StringOptions.Builder();
        boolean bl = false;
        boolean bl2 = false;
        Stringifier.StringOptions.Builder $this$stringifyStringOptions_u24lambda_u2d0 = builder;
        boolean bl3 = false;
        $this$stringifyStringOptions_u24lambda_u2d0.setPrintableChar(PrintableChars.EveryCharExceptKnownUnprintable);
        stringifyStringOptions = builder.build();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lvjson/pl/ScriptifyContext$Companion;", "", "()V", "stringifyStringOptions", "Lvjson/Stringifier$StringOptions;", "checkStringNoQuotesWithParser", "", "s", "", "scriptifyString", "stringNoQuotes", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String scriptifyString(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (this.stringNoQuotes(s)) {
                return s;
            }
            return JSON.String.Companion.stringify(s, stringifyStringOptions);
        }

        private final boolean stringNoQuotes(String s) {
            if (StringsKt.isBlank((CharSequence)s)) {
                return false;
            }
            String string = s;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)s)) {
                return false;
            }
            return this.checkStringNoQuotesWithParser(s);
        }

        private final boolean checkStringNoQuotesWithParser(String s) {
            JSON.Instance<?> instance;
            try {
                instance = ParserUtils.buildFrom(CharStream.Companion.from(s), ParserOptions.Companion.allFeatures());
            }
            catch (Throwable ignore) {
                return false;
            }
            JSON.Instance<?> json = instance;
            if (!(json instanceof JSON.String)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((JSON.String)json).toJavaObject(), (Object)s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

