/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ast.AssignableExpr;
import vjson.pl.ast.Expr;
import vjson.pl.ast.FunctionInvocation;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.CompositeInstruction;
import vjson.pl.inst.ExecutableFieldInstruction;
import vjson.pl.inst.Execution;
import vjson.pl.inst.FunctionInstance;
import vjson.pl.inst.GetBool;
import vjson.pl.inst.GetDouble;
import vjson.pl.inst.GetFieldBool;
import vjson.pl.inst.GetFieldDouble;
import vjson.pl.inst.GetFieldFloat;
import vjson.pl.inst.GetFieldInt;
import vjson.pl.inst.GetFieldLong;
import vjson.pl.inst.GetFieldRef;
import vjson.pl.inst.GetFloat;
import vjson.pl.inst.GetInt;
import vjson.pl.inst.GetLastError;
import vjson.pl.inst.GetLong;
import vjson.pl.inst.GetRef;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.InstructionWithStackInfo;
import vjson.pl.inst.SetBool;
import vjson.pl.inst.SetDouble;
import vjson.pl.inst.SetFieldBool;
import vjson.pl.inst.SetFieldDouble;
import vjson.pl.inst.SetFieldFloat;
import vjson.pl.inst.SetFieldInt;
import vjson.pl.inst.SetFieldLong;
import vjson.pl.inst.SetFieldRef;
import vjson.pl.inst.SetFloat;
import vjson.pl.inst.SetInt;
import vjson.pl.inst.SetLong;
import vjson.pl.inst.SetRef;
import vjson.pl.inst.StackInfo;
import vjson.pl.type.BoolType;
import vjson.pl.type.DoubleType;
import vjson.pl.type.ErrorType;
import vjson.pl.type.ExecutableField;
import vjson.pl.type.Field;
import vjson.pl.type.FloatType;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.Variable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u001f\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\fH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lvjson/pl/ast/Access;", "Lvjson/pl/ast/AssignableExpr;", "name", "", "from", "Lvjson/pl/ast/Expr;", "(Ljava/lang/String;Lvjson/pl/ast/Expr;)V", "getFrom", "()Lvjson/pl/ast/Expr;", "getName", "()Ljava/lang/String;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "generateSetInstruction", "valueInst", "hashCode", "", "isModifiable", "toString", "indent", "typeInstance", "Companion", "vjson"})
public final class Access
extends AssignableExpr {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private final Expr from;

    @JvmOverloads
    public Access(@NotNull String name, @Nullable Expr from) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.from = from;
    }

    public /* synthetic */ Access(String string, Expr expr, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            expr = null;
        }
        this(string, expr);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Expr getFrom() {
        return this.from;
    }

    @Override
    @NotNull
    public Access copy() {
        Expr expr = this.from;
        Access ret2 = new Access(this.name, expr == null ? null : expr.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        if (this.from == null) {
            if (!ctx.hasVariable(this.name)) {
                throw new ParserException(this + ": variable " + this.name + " is not defined", this.getLineCol());
            }
            return ctx.getVariable(this.name).getType();
        }
        TypeInstance fromType = this.from.check(ctx, null);
        Field fieldType = fromType.field(ctx, this.name, ctx.getContextType());
        if (fieldType != null) {
            return fieldType.getType();
        }
        throw new ParserException(this + ": " + fromType + " doesn't have field `" + this.name + '`', this.getLineCol());
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        TypeInstance typeInstance;
        if (this.from == null) {
            typeInstance = this.getCtx().getVariable(this.name).getType();
        } else {
            Field field2 = this.from.typeInstance().field(this.getCtx(), this.name, this.getCtx().getContextType());
            Intrinsics.checkNotNull((Object)field2);
            typeInstance = field2.getType();
        }
        return typeInstance;
    }

    @Override
    public boolean isModifiable() {
        boolean bl;
        if (this.from == null) {
            bl = this.getCtx().getVariable(this.name).getModifiable();
        } else {
            TypeInstance fromType = this.from.typeInstance();
            Field field2 = fromType.field(this.getCtx(), this.name, this.getCtx().getContextType());
            Intrinsics.checkNotNull((Object)field2);
            Field fieldType = field2;
            bl = fieldType.getModifiable();
        }
        return bl;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Instruction instruction;
        if (this.from == null) {
            Variable variable = this.getCtx().getVariable(this.name);
            if (variable.getExecutor() != null) {
                Pair<FunctionDescriptor, Instruction> func = variable.getExecutor();
                boolean bl = false;
                instruction = FunctionInvocation.Companion.invokeFunction(this.getCtx(), (FunctionDescriptor)func.getFirst(), (Instruction)func.getSecond(), CollectionsKt.emptyList(), this.getLineCol());
            } else {
                TypeInstance func = this.typeInstance();
                if (func instanceof IntType) {
                    instruction = new GetInt(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), this.getCtx().stackInfo(this.getLineCol()));
                } else if (func instanceof LongType) {
                    instruction = new GetLong(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), this.getCtx().stackInfo(this.getLineCol()));
                } else if (func instanceof FloatType) {
                    instruction = new GetFloat(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), this.getCtx().stackInfo(this.getLineCol()));
                } else if (func instanceof DoubleType) {
                    instruction = new GetDouble(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), this.getCtx().stackInfo(this.getLineCol()));
                } else if (func instanceof BoolType) {
                    instruction = new GetBool(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), this.getCtx().stackInfo(this.getLineCol()));
                } else if (this.typeInstance() instanceof ErrorType && Intrinsics.areEqual((Object)this.name, (Object)"err")) {
                    instruction = new GetLastError();
                } else {
                    GetRef inst = new GetRef(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), this.getCtx().stackInfo(this.getLineCol()));
                    if (variable.getType().functionDescriptor(this.getCtx()) != null) {
                        return new FunctionInstance(null, variable.getMemPos().getDepth(), inst, this.getCtx().stackInfo(this.getLineCol()));
                    }
                    instruction = inst;
                }
            }
        } else {
            TypeInstance fromType = this.from.typeInstance();
            Field field2 = fromType.field(this.getCtx(), this.name, this.getCtx().getContextType());
            Intrinsics.checkNotNull((Object)field2);
            Field fieldType = field2;
            if (fieldType.getExecutor() != null) {
                Instruction fromInst = this.from.generateInstruction();
                Pair<FunctionDescriptor, Instruction> func = fieldType.getExecutor();
                FunctionDescriptor funcDesc = (FunctionDescriptor)func.getFirst();
                Instruction funcInst = (Instruction)func.getSecond();
                StackInfo stackInfo2 = this.getCtx().stackInfo(this.getLineCol());
                instruction = new InstructionWithStackInfo(fromInst, funcInst, funcDesc, stackInfo2){
                    final /* synthetic */ Instruction $fromInst;
                    final /* synthetic */ Instruction $funcInst;
                    final /* synthetic */ FunctionDescriptor $funcDesc;
                    {
                        this.$fromInst = $fromInst;
                        this.$funcInst = $funcInst;
                        this.$funcDesc = $funcDesc;
                        super($super_call_param$1);
                    }

                    protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
                        this.$fromInst.execute(ctx, exec);
                        Object object = exec.getValues().getRefValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type vjson.pl.inst.ActionContext");
                        }
                        ActionContext objectCtx = (ActionContext)object;
                        if (this.$funcInst instanceof FunctionInstance) {
                            ((FunctionInstance)this.$funcInst).setCtxBuilder((Function1<? super ActionContext, ActionContext>)((Function1)new Function1<ActionContext, ActionContext>(objectCtx, exec, this.$funcDesc){
                                final /* synthetic */ ActionContext $objectCtx;
                                final /* synthetic */ Execution $exec;
                                final /* synthetic */ FunctionDescriptor $funcDesc;
                                {
                                    this.$objectCtx = $objectCtx;
                                    this.$exec = $exec;
                                    this.$funcDesc = $funcDesc;
                                    super(1);
                                }

                                @NotNull
                                public final ActionContext invoke(@NotNull ActionContext it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    boolean bl = false;
                                    return FunctionInvocation.Companion.buildContext(this.$objectCtx, it, this.$exec, this.$funcDesc, CollectionsKt.emptyList());
                                }
                            }));
                            this.$funcInst.execute(objectCtx, exec);
                        } else {
                            this.$funcInst.execute(objectCtx, exec);
                            Object object2 = exec.getValues().getRefValue();
                            if (object2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type vjson.pl.inst.Instruction");
                            }
                            Instruction funcValue = (Instruction)object2;
                            boolean bl = false;
                            ActionContext newCtx = FunctionInvocation.Companion.buildContext(objectCtx, objectCtx, exec, this.$funcDesc, CollectionsKt.emptyList());
                            funcValue.execute(newCtx, exec);
                        }
                    }
                };
            } else {
                instruction = Companion.buildGetFieldInstruction(this.getCtx(), this.from.generateInstruction(), this.from.typeInstance(), this.name, this.getLineCol());
            }
        }
        return instruction;
    }

    @Override
    @NotNull
    public Instruction generateSetInstruction(@NotNull Instruction valueInst) {
        Instruction instruction;
        Intrinsics.checkNotNullParameter((Object)valueInst, (String)"valueInst");
        if (this.from == null) {
            Variable variable = this.getCtx().getVariable(this.name);
            TypeInstance typeInstance = this.typeInstance();
            instruction = typeInstance instanceof IntType ? (Instruction)new SetInt(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof LongType ? (Instruction)new SetLong(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof FloatType ? (Instruction)new SetFloat(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof DoubleType ? (Instruction)new SetDouble(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof BoolType ? (Instruction)new SetBool(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (Instruction)new SetRef(variable.getMemPos().getDepth(), variable.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol()))))));
        } else {
            Field field2;
            Instruction fromInst = this.from.generateInstruction();
            Field field3 = field2 = this.from.typeInstance().field(this.getCtx(), this.name, this.getCtx().getContextType());
            Intrinsics.checkNotNull((Object)field3);
            TypeInstance typeInstance = field3.getType();
            Instruction setField = typeInstance instanceof IntType ? (Instruction)new SetFieldInt(field2.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof LongType ? (Instruction)new SetFieldLong(field2.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof FloatType ? (Instruction)new SetFieldFloat(field2.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof DoubleType ? (Instruction)new SetFieldDouble(field2.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof BoolType ? (Instruction)new SetFieldBool(field2.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (Instruction)new SetFieldRef(field2.getMemPos().getIndex(), valueInst, this.getCtx().stackInfo(this.getLineCol()))))));
            instruction = new Instruction(this, fromInst, setField){
                @NotNull
                private final StackInfo stackInfo;
                final /* synthetic */ Access this$0;
                final /* synthetic */ Instruction $fromInst;
                final /* synthetic */ Instruction $setField;
                {
                    this.this$0 = $receiver;
                    this.$fromInst = $fromInst;
                    this.$setField = $setField;
                    this.stackInfo = this.this$0.getCtx().stackInfo(this.this$0.getLineCol());
                }

                @NotNull
                public StackInfo getStackInfo() {
                    return this.stackInfo;
                }

                protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
                    this.$fromInst.execute(ctx, exec);
                    Object object = exec.getValues().getRefValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type vjson.pl.inst.ActionContext");
                    }
                    ActionContext objCtx = (ActionContext)object;
                    this.$setField.execute(objCtx, exec);
                }
            };
        }
        return instruction;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.from == null ? this.name : this.from + '.' + this.name;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final Expr component2() {
        return this.from;
    }

    @NotNull
    public final Access copy(@NotNull String name, @Nullable Expr from) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Access(name, from);
    }

    public static /* synthetic */ Access copy$default(Access access, String string, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            string = access.name;
        }
        if ((n & 2) != 0) {
            expr = access.from;
        }
        return access.copy(string, expr);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + (this.from == null ? 0 : this.from.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Access)) {
            return false;
        }
        Access access = (Access)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)access.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.from, (Object)access.from);
    }

    @JvmOverloads
    public Access(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lvjson/pl/ast/Access$Companion;", "", "()V", "buildGetFieldInstruction", "Lvjson/pl/inst/Instruction;", "ctx", "Lvjson/pl/type/TypeContext;", "from", "fromType", "Lvjson/pl/type/TypeInstance;", "name", "", "lineCol", "Lvjson/cs/LineCol;", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Instruction buildGetFieldInstruction(@NotNull TypeContext ctx, @NotNull Instruction from, @NotNull TypeInstance fromType, @NotNull String name, @NotNull LineCol lineCol) {
            Instruction[] instructionArray;
            Instruction instruction;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
            Field field2 = fromType.field(ctx, name, ctx.getContextType());
            if (field2 instanceof ExecutableField) {
                instruction = new ExecutableFieldInstruction((ExecutableField)field2, ctx.stackInfo(lineCol));
            } else {
                Field field3 = field2;
                Intrinsics.checkNotNull((Object)field3);
                instructionArray = field3.getType();
                if (instructionArray instanceof IntType) {
                    instruction = new GetFieldInt(field2.getMemPos().getIndex(), ctx.stackInfo(lineCol));
                } else if (instructionArray instanceof LongType) {
                    instruction = new GetFieldLong(field2.getMemPos().getIndex(), ctx.stackInfo(lineCol));
                } else if (instructionArray instanceof FloatType) {
                    instruction = new GetFieldFloat(field2.getMemPos().getIndex(), ctx.stackInfo(lineCol));
                } else if (instructionArray instanceof DoubleType) {
                    instruction = new GetFieldDouble(field2.getMemPos().getIndex(), ctx.stackInfo(lineCol));
                } else if (instructionArray instanceof BoolType) {
                    instruction = new GetFieldBool(field2.getMemPos().getIndex(), ctx.stackInfo(lineCol));
                } else {
                    GetFieldRef inst = new GetFieldRef(field2.getMemPos().getIndex(), ctx.stackInfo(lineCol));
                    if (field2.getType().functionDescriptor(ctx) != null) {
                        return new FunctionInstance(from, field2.getMemPos().getDepth(), inst, ctx.stackInfo(lineCol));
                    }
                    instruction = inst;
                }
            }
            Instruction getFieldInst = instruction;
            instructionArray = new Instruction[]{from, getFieldInst};
            return new CompositeInstruction(instructionArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

