/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.AssignableExpr;
import vjson.pl.ast.Expr;
import vjson.pl.inst.GetIndexBool;
import vjson.pl.inst.GetIndexDouble;
import vjson.pl.inst.GetIndexFloat;
import vjson.pl.inst.GetIndexInt;
import vjson.pl.inst.GetIndexLong;
import vjson.pl.inst.GetIndexRef;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.SetIndexBool;
import vjson.pl.inst.SetIndexDouble;
import vjson.pl.inst.SetIndexFloat;
import vjson.pl.inst.SetIndexInt;
import vjson.pl.inst.SetIndexLong;
import vjson.pl.inst.SetIndexRef;
import vjson.pl.type.BoolType;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006 "}, d2={"Lvjson/pl/ast/AccessIndex;", "Lvjson/pl/ast/AssignableExpr;", "from", "Lvjson/pl/ast/Expr;", "index", "(Lvjson/pl/ast/Expr;Lvjson/pl/ast/Expr;)V", "getFrom", "()Lvjson/pl/ast/Expr;", "getIndex", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "generateSetInstruction", "valueInst", "hashCode", "", "isModifiable", "toString", "", "indent", "typeInstance", "vjson"})
public final class AccessIndex
extends AssignableExpr {
    @NotNull
    private final Expr from;
    @NotNull
    private final Expr index;

    public AccessIndex(@NotNull Expr from, @NotNull Expr index) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.from = from;
        this.index = index;
    }

    @NotNull
    public final Expr getFrom() {
        return this.from;
    }

    @NotNull
    public final Expr getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public AccessIndex copy() {
        AccessIndex ret2 = new AccessIndex(this.from.copy(), this.index.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        TypeInstance type = this.from.check(ctx, null);
        TypeInstance elementType = type.elementType(ctx);
        if (elementType == null) {
            throw new ParserException(this + ": " + elementType + " doesn't have elements", this.getLineCol());
        }
        TypeInstance indexType = this.index.check(ctx, IntType.INSTANCE);
        if (!(indexType instanceof IntType)) {
            throw new ParserException(this + ": typeof " + this.index + " (" + indexType + ") is not `int`", this.getLineCol());
        }
        return elementType;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        TypeInstance typeInstance = this.from.typeInstance().elementType(this.getCtx());
        Intrinsics.checkNotNull((Object)typeInstance);
        return typeInstance;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        TypeInstance typeInstance = this.typeInstance();
        return typeInstance instanceof IntType ? (Instruction)new GetIndexInt(this.from.generateInstruction(), this.index.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof LongType ? (Instruction)new GetIndexLong(this.from.generateInstruction(), this.index.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof FloatType ? (Instruction)new GetIndexFloat(this.from.generateInstruction(), this.index.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof DoubleType ? (Instruction)new GetIndexDouble(this.from.generateInstruction(), this.index.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof BoolType ? (Instruction)new GetIndexBool(this.from.generateInstruction(), this.index.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (Instruction)new GetIndexRef(this.from.generateInstruction(), this.index.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()))))));
    }

    @Override
    @NotNull
    public Instruction generateSetInstruction(@NotNull Instruction valueInst) {
        Intrinsics.checkNotNullParameter((Object)valueInst, (String)"valueInst");
        TypeInstance typeInstance = this.typeInstance();
        return typeInstance instanceof IntType ? (Instruction)new SetIndexInt(this.from.generateInstruction(), this.index.generateInstruction(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof LongType ? (Instruction)new SetIndexLong(this.from.generateInstruction(), this.index.generateInstruction(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof FloatType ? (Instruction)new SetIndexFloat(this.from.generateInstruction(), this.index.generateInstruction(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof DoubleType ? (Instruction)new SetIndexDouble(this.from.generateInstruction(), this.index.generateInstruction(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof BoolType ? (Instruction)new SetIndexBool(this.from.generateInstruction(), this.index.generateInstruction(), valueInst, this.getCtx().stackInfo(this.getLineCol())) : (Instruction)new SetIndexRef(this.from.generateInstruction(), this.index.generateInstruction(), valueInst, this.getCtx().stackInfo(this.getLineCol()))))));
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "" + this.from + '[' + this.index + ']';
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final Expr component1() {
        return this.from;
    }

    @NotNull
    public final Expr component2() {
        return this.index;
    }

    @NotNull
    public final AccessIndex copy(@NotNull Expr from, @NotNull Expr index) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        return new AccessIndex(from, index);
    }

    public static /* synthetic */ AccessIndex copy$default(AccessIndex accessIndex, Expr expr, Expr expr2, int n, Object object) {
        if ((n & 1) != 0) {
            expr = accessIndex.from;
        }
        if ((n & 2) != 0) {
            expr2 = accessIndex.index;
        }
        return accessIndex.copy(expr, expr2);
    }

    public int hashCode() {
        int result = this.from.hashCode();
        result = result * 31 + this.index.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessIndex)) {
            return false;
        }
        AccessIndex accessIndex = (AccessIndex)other;
        if (!Intrinsics.areEqual((Object)this.from, (Object)accessIndex.from)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.index, (Object)accessIndex.index);
    }
}

