/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.AssignableExpr;
import vjson.pl.ast.Expr;
import vjson.pl.inst.Instruction;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0001H\u00c6\u0003J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lvjson/pl/ast/Assignment;", "Lvjson/pl/ast/Expr;", "variable", "Lvjson/pl/ast/AssignableExpr;", "value", "(Lvjson/pl/ast/AssignableExpr;Lvjson/pl/ast/Expr;)V", "getValue", "()Lvjson/pl/ast/Expr;", "getVariable", "()Lvjson/pl/ast/AssignableExpr;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "typeInstance", "vjson"})
public final class Assignment
extends Expr {
    @NotNull
    private final AssignableExpr variable;
    @NotNull
    private final Expr value;

    public Assignment(@NotNull AssignableExpr variable, @NotNull Expr value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.variable = variable;
        this.value = value;
    }

    @NotNull
    public final AssignableExpr getVariable() {
        return this.variable;
    }

    @NotNull
    public final Expr getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public Assignment copy() {
        Assignment ret2 = new Assignment(this.variable.copy(), this.value.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        TypeInstance variableType = this.variable.check(ctx, null);
        TypeInstance valueType = this.value.check(ctx, variableType);
        if (!TypeUtils.INSTANCE.assignableFrom(variableType, valueType)) {
            throw new ParserException(this + ": cannot assign " + valueType + " to " + variableType + ", type mismatch", this.getLineCol());
        }
        if (!this.variable.isModifiable()) {
            throw new ParserException(this + ": cannot assign value to " + this.variable + ", the variable/field is unmodifiable", this.getLineCol());
        }
        return valueType;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        return this.value.typeInstance();
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Instruction valueInst = this.value.generateInstruction();
        return this.variable.generateSetInstruction(valueInst);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "" + '(' + this.variable + " = " + this.value + ')';
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final AssignableExpr component1() {
        return this.variable;
    }

    @NotNull
    public final Expr component2() {
        return this.value;
    }

    @NotNull
    public final Assignment copy(@NotNull AssignableExpr variable, @NotNull Expr value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Assignment(variable, value);
    }

    public static /* synthetic */ Assignment copy$default(Assignment assignment, AssignableExpr assignableExpr, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            assignableExpr = assignment.variable;
        }
        if ((n & 2) != 0) {
            expr = assignment.value;
        }
        return assignment.copy(assignableExpr, expr);
    }

    public int hashCode() {
        int result = this.variable.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Assignment)) {
            return false;
        }
        Assignment assignment = (Assignment)other;
        if (!Intrinsics.areEqual((Object)this.variable, (Object)assignment.variable)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)assignment.value);
    }
}

