/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Access;
import vjson.pl.ast.BinOpType;
import vjson.pl.ast.Expr;
import vjson.pl.inst.CmpEQBool;
import vjson.pl.inst.CmpEQDouble;
import vjson.pl.inst.CmpEQFloat;
import vjson.pl.inst.CmpEQInt;
import vjson.pl.inst.CmpEQLong;
import vjson.pl.inst.CmpEQRef;
import vjson.pl.inst.CmpGEDouble;
import vjson.pl.inst.CmpGEFloat;
import vjson.pl.inst.CmpGEInt;
import vjson.pl.inst.CmpGELong;
import vjson.pl.inst.CmpGTDouble;
import vjson.pl.inst.CmpGTFloat;
import vjson.pl.inst.CmpGTInt;
import vjson.pl.inst.CmpGTLong;
import vjson.pl.inst.CmpLEDouble;
import vjson.pl.inst.CmpLEFloat;
import vjson.pl.inst.CmpLEInt;
import vjson.pl.inst.CmpLELong;
import vjson.pl.inst.CmpLTDouble;
import vjson.pl.inst.CmpLTFloat;
import vjson.pl.inst.CmpLTInt;
import vjson.pl.inst.CmpLTLong;
import vjson.pl.inst.CmpNEBool;
import vjson.pl.inst.CmpNEDouble;
import vjson.pl.inst.CmpNEFloat;
import vjson.pl.inst.CmpNEInt;
import vjson.pl.inst.CmpNELong;
import vjson.pl.inst.CmpNERef;
import vjson.pl.inst.DivideDouble;
import vjson.pl.inst.DivideFloat;
import vjson.pl.inst.DivideInt;
import vjson.pl.inst.DivideLong;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.LogicAndBool;
import vjson.pl.inst.LogicOrBool;
import vjson.pl.inst.MinusDouble;
import vjson.pl.inst.MinusFloat;
import vjson.pl.inst.MinusInt;
import vjson.pl.inst.MinusLong;
import vjson.pl.inst.ModInt;
import vjson.pl.inst.ModLong;
import vjson.pl.inst.MultiplyDouble;
import vjson.pl.inst.MultiplyFloat;
import vjson.pl.inst.MultiplyInt;
import vjson.pl.inst.MultiplyLong;
import vjson.pl.inst.PlusDouble;
import vjson.pl.inst.PlusFloat;
import vjson.pl.inst.PlusInt;
import vjson.pl.inst.PlusLong;
import vjson.pl.inst.StringConcat;
import vjson.pl.type.BoolType;
import vjson.pl.type.BuiltInTypeInstance;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.NullType;
import vjson.pl.type.NumericTypeInstance;
import vjson.pl.type.PrimitiveTypeInstance;
import vjson.pl.type.StringType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0001H\u00c6\u0003J\b\u0010\u0014\u001a\u00020\u0000H\u0016J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006!"}, d2={"Lvjson/pl/ast/BinOp;", "Lvjson/pl/ast/Expr;", "op", "Lvjson/pl/ast/BinOpType;", "left", "right", "(Lvjson/pl/ast/BinOpType;Lvjson/pl/ast/Expr;Lvjson/pl/ast/Expr;)V", "getLeft", "()Lvjson/pl/ast/Expr;", "getOp", "()Lvjson/pl/ast/BinOpType;", "getRight", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "component3", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "typeInstance", "vjson"})
public final class BinOp
extends Expr {
    @NotNull
    private final BinOpType op;
    @NotNull
    private final Expr left;
    @NotNull
    private final Expr right;

    public BinOp(@NotNull BinOpType op, @NotNull Expr left, @NotNull Expr right) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @NotNull
    public final BinOpType getOp() {
        return this.op;
    }

    @NotNull
    public final Expr getLeft() {
        return this.left;
    }

    @NotNull
    public final Expr getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public BinOp copy() {
        BinOp ret2 = new BinOp(this.op, this.left.copy(), this.right.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        TypeInstance typeInstance;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        TypeInstance leftType = this.left.check(ctx, null);
        TypeInstance rightType = this.right.check(ctx, null);
        BinOpType binOpType = this.op;
        int n = WhenMappings.$EnumSwitchMapping$0[binOpType.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                BuiltInTypeInstance builtInTypeInstance;
                if (this.op == BinOpType.PLUS && (leftType instanceof StringType || rightType instanceof StringType)) {
                    if (!(leftType instanceof StringType) || !(rightType instanceof StringType)) {
                        TypeInstance typeToStringCheck = null;
                        Expr variableToStringCheck = null;
                        if (!(leftType instanceof StringType)) {
                            typeToStringCheck = leftType;
                            variableToStringCheck = this.left;
                        } else {
                            typeToStringCheck = rightType;
                            variableToStringCheck = this.right;
                        }
                        TypeUtils.INSTANCE.checkImplicitStringCast(ctx, typeToStringCheck, variableToStringCheck, this.getLineCol());
                    }
                    builtInTypeInstance = StringType.INSTANCE;
                } else {
                    PrimitiveTypeInstance primitiveTypeInstance;
                    if (!Intrinsics.areEqual((Object)leftType, (Object)rightType)) {
                        throw new ParserException(this + ": cannot calculate " + leftType + ' ' + (Object)((Object)this.op) + ' ' + rightType + ", type mismatch", this.getLineCol());
                    }
                    if (!(leftType instanceof NumericTypeInstance)) {
                        throw new ParserException(this + ": cannot calculate " + leftType + ' ' + (Object)((Object)this.op) + ' ' + rightType + ", not numeric values", this.getLineCol());
                    }
                    if (this.op == BinOpType.MOD && !(leftType instanceof IntType) && !(leftType instanceof LongType)) {
                        throw new ParserException(this + ": cannot calculate " + leftType + ' ' + (Object)((Object)this.op) + ' ' + rightType + ", must be int or long", this.getLineCol());
                    }
                    BinOpType binOpType2 = this.op;
                    int n2 = WhenMappings.$EnumSwitchMapping$0[binOpType2.ordinal()];
                    switch (n2) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            primitiveTypeInstance = (PrimitiveTypeInstance)leftType;
                            break;
                        }
                        default: {
                            primitiveTypeInstance = BoolType.INSTANCE;
                        }
                    }
                    builtInTypeInstance = primitiveTypeInstance;
                }
                typeInstance = builtInTypeInstance;
                break;
            }
            case 10: 
            case 11: {
                if (!Intrinsics.areEqual((Object)leftType, (Object)BoolType.INSTANCE)) {
                    throw new ParserException(this + ": cannot calculate " + leftType + ' ' + (Object)((Object)this.op) + ' ' + rightType + ", not boolean values", this.getLineCol());
                }
                if (!Intrinsics.areEqual((Object)rightType, (Object)BoolType.INSTANCE)) {
                    throw new ParserException(this + ": cannot calculate " + leftType + ' ' + (Object)((Object)this.op) + ' ' + rightType + ", not boolean values", this.getLineCol());
                }
                typeInstance = BoolType.INSTANCE;
                break;
            }
            case 12: 
            case 13: {
                if (!Intrinsics.areEqual((Object)leftType, (Object)rightType)) {
                    if ((leftType instanceof NullType || rightType instanceof NullType) && !(leftType instanceof PrimitiveTypeInstance) && !(rightType instanceof PrimitiveTypeInstance)) {
                        return BoolType.INSTANCE;
                    }
                    throw new ParserException(this + ": cannot calculate " + leftType + ' ' + (Object)((Object)this.op) + ' ' + rightType + ", type mismatch", this.getLineCol());
                }
                typeInstance = BoolType.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeInstance;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        TypeInstance typeInstance;
        BinOpType binOpType = this.op;
        int n = WhenMappings.$EnumSwitchMapping$0[binOpType.ordinal()];
        switch (n) {
            case 1: {
                if (this.left.typeInstance() instanceof StringType || this.right.typeInstance() instanceof StringType) {
                    typeInstance = StringType.INSTANCE;
                    break;
                }
                typeInstance = this.left.typeInstance();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                typeInstance = this.left.typeInstance();
                break;
            }
            default: {
                typeInstance = BoolType.INSTANCE;
            }
        }
        return typeInstance;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Instruction instruction;
        TypeInstance lType = this.left.typeInstance();
        TypeInstance rType = this.right.typeInstance();
        Instruction leftInst = this.left.generateInstruction();
        Instruction rightInst = this.right.generateInstruction();
        BinOpType binOpType = this.op;
        int n = WhenMappings.$EnumSwitchMapping$0[binOpType.ordinal()];
        switch (n) {
            case 3: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new MultiplyInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new MultiplyLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new MultiplyFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new MultiplyDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 4: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new DivideInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new DivideLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new DivideFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new DivideDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 5: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new ModInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new ModLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 1: {
                if (lType instanceof StringType || rType instanceof StringType) {
                    StringConcat stringConcat;
                    if (lType instanceof StringType && rType instanceof StringType) {
                        stringConcat = new StringConcat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    } else {
                        Instruction toStringFuncInst = Access.Companion.buildGetFieldInstruction(this.getCtx(), lType instanceof StringType ? rightInst : leftInst, lType instanceof StringType ? rType : lType, "toString", this.getLineCol());
                        Instruction callToStringFuncInst = TypeUtils.INSTANCE.buildToStringInstruction(this.getCtx(), lType instanceof StringType ? rType : lType, toStringFuncInst, this.getLineCol());
                        stringConcat = lType instanceof StringType ? new StringConcat(leftInst, callToStringFuncInst, this.getCtx().stackInfo(this.getLineCol())) : new StringConcat(callToStringFuncInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    }
                    instruction = stringConcat;
                    break;
                }
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new PlusInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new PlusLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new PlusFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new PlusDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 2: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new MinusInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new MinusLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new MinusFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new MinusDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 6: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new CmpGTInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new CmpGTLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new CmpGTFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new CmpGTDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 7: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new CmpGEInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new CmpGELong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new CmpGEFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new CmpGEDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 8: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new CmpLTInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new CmpLTLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new CmpLTFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new CmpLTDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 9: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new CmpLEInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new CmpLELong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new CmpLEFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new CmpLEDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException("" + lType + ' ' + (Object)((Object)this.op) + ' ' + rType);
            }
            case 12: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new CmpNEInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new CmpNELong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new CmpNEFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new CmpNEDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof BoolType) {
                    instruction = new CmpNEBool(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                instruction = new CmpNERef(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                break;
            }
            case 13: {
                TypeInstance typeInstance = lType;
                if (typeInstance instanceof IntType) {
                    instruction = new CmpEQInt(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new CmpEQLong(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new CmpEQFloat(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new CmpEQDouble(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof BoolType) {
                    instruction = new CmpEQBool(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                instruction = new CmpEQRef(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                break;
            }
            case 10: {
                instruction = new LogicAndBool(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                break;
            }
            case 11: {
                instruction = new LogicOrBool(leftInst, rightInst, this.getCtx().stackInfo(this.getLineCol()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return instruction;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "" + '(' + this.left + ' ' + (Object)((Object)this.op) + ' ' + this.right + ')';
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final BinOpType component1() {
        return this.op;
    }

    @NotNull
    public final Expr component2() {
        return this.left;
    }

    @NotNull
    public final Expr component3() {
        return this.right;
    }

    @NotNull
    public final BinOp copy(@NotNull BinOpType op, @NotNull Expr left, @NotNull Expr right) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new BinOp(op, left, right);
    }

    public static /* synthetic */ BinOp copy$default(BinOp binOp, BinOpType binOpType, Expr expr, Expr expr2, int n, Object object) {
        if ((n & 1) != 0) {
            binOpType = binOp.op;
        }
        if ((n & 2) != 0) {
            expr = binOp.left;
        }
        if ((n & 4) != 0) {
            expr2 = binOp.right;
        }
        return binOp.copy(binOpType, expr, expr2);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = result * 31 + this.left.hashCode();
        result = result * 31 + this.right.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinOp)) {
            return false;
        }
        BinOp binOp = (BinOp)other;
        if (this.op != binOp.op) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.left, (Object)binOp.left)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.right, (Object)binOp.right);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinOpType.values().length];
            nArray[BinOpType.PLUS.ordinal()] = 1;
            nArray[BinOpType.MINUS.ordinal()] = 2;
            nArray[BinOpType.MULTIPLY.ordinal()] = 3;
            nArray[BinOpType.DIVIDE.ordinal()] = 4;
            nArray[BinOpType.MOD.ordinal()] = 5;
            nArray[BinOpType.CMP_GT.ordinal()] = 6;
            nArray[BinOpType.CMP_GE.ordinal()] = 7;
            nArray[BinOpType.CMP_LT.ordinal()] = 8;
            nArray[BinOpType.CMP_LE.ordinal()] = 9;
            nArray[BinOpType.LOGIC_AND.ordinal()] = 10;
            nArray[BinOpType.LOGIC_OR.ordinal()] = 11;
            nArray[BinOpType.CMP_NE.ordinal()] = 12;
            nArray[BinOpType.CMP_EQ.ordinal()] = 13;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

