/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.AST;
import vjson.pl.ast.ClassDefinition;
import vjson.pl.ast.FunctionDefinition;
import vjson.pl.ast.LoopStatement;
import vjson.pl.ast.Statement;
import vjson.pl.inst.BreakInstruction;
import vjson.pl.inst.Instruction;
import vjson.pl.type.TypeContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0015\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lvjson/pl/ast/BreakStatement;", "Lvjson/pl/ast/Statement;", "flag", "", "(Ljava/lang/String;)V", "getFlag", "()Ljava/lang/String;", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "indent", "vjson"})
public final class BreakStatement
extends Statement {
    @Nullable
    private final String flag;

    public BreakStatement(@Nullable String flag) {
        this.flag = flag;
    }

    public /* synthetic */ BreakStatement(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Nullable
    public final String getFlag() {
        return this.flag;
    }

    @Override
    @NotNull
    public BreakStatement copy() {
        BreakStatement ret2 = new BreakStatement(this.flag);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        AST ctxAST2 = ctx.getContextAST((Function1<? super AST, Boolean>)((Function1)new Function1<AST, Boolean>(this){
            final /* synthetic */ BreakStatement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AST it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof ClassDefinition || it instanceof FunctionDefinition || it instanceof LoopStatement && (this.this$0.getFlag() == null || Intrinsics.areEqual((Object)((LoopStatement)it).getFlag(), (Object)this.this$0.getFlag()));
            }
        }));
        if (ctxAST2 == null || !(ctxAST2 instanceof LoopStatement)) {
            if (this.flag == null) {
                throw new ParserException(Intrinsics.stringPlus((String)"`break` is not in a loop, current context is ", (Object)ctxAST2), this.getLineCol());
            }
            throw new ParserException("unable to find loop " + this.flag + " for `break`", this.getLineCol());
        }
        ((LoopStatement)ctxAST2).setInfiniteLoop(false);
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        if (this.flag != null) {
            throw new UnsupportedOperationException("break with flag is not supported yet");
        }
        return new BreakInstruction(1);
    }

    @Override
    public boolean functionTerminationCheck() {
        return false;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.flag == null ? "break" : Intrinsics.stringPlus((String)"break: ", (Object)this.flag);
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @Nullable
    public final String component1() {
        return this.flag;
    }

    @NotNull
    public final BreakStatement copy(@Nullable String flag) {
        return new BreakStatement(flag);
    }

    public static /* synthetic */ BreakStatement copy$default(BreakStatement breakStatement, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = breakStatement.flag;
        }
        return breakStatement.copy(string);
    }

    public int hashCode() {
        return this.flag == null ? 0 : this.flag.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BreakStatement)) {
            return false;
        }
        BreakStatement breakStatement = (BreakStatement)other;
        return Intrinsics.areEqual((Object)this.flag, (Object)breakStatement.flag);
    }

    public BreakStatement() {
        this(null, 1, null);
    }
}

