/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Param;
import vjson.pl.ast.Statement;
import vjson.pl.ast.Type;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.NoOp;
import vjson.pl.type.ClassTypeInstance;
import vjson.pl.type.MemPos;
import vjson.pl.type.MemoryAllocator;
import vjson.pl.type.MemoryAllocatorProvider;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.Variable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0003J\b\u0010\u001a\u001a\u00020\u0000H\u0016J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\rJ\t\u0010#\u001a\u00020\rH\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\rH\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006&"}, d2={"Lvjson/pl/ast/ClassDefinition;", "Lvjson/pl/ast/Statement;", "Lvjson/pl/type/MemoryAllocatorProvider;", "name", "", "params", "", "Lvjson/pl/ast/Param;", "code", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getCode", "()Ljava/util/List;", "memDepth", "", "memoryAllocator", "Lvjson/pl/type/MemoryAllocator;", "getName", "()Ljava/lang/String;", "getParams", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "getMemDepth", "hashCode", "toString", "indent", "vjson"})
public final class ClassDefinition
extends Statement
implements MemoryAllocatorProvider {
    @NotNull
    private final String name;
    @NotNull
    private final List<Param> params;
    @NotNull
    private final List<Statement> code;
    private int memDepth;
    @NotNull
    private final MemoryAllocator memoryAllocator;

    public ClassDefinition(@NotNull String name, @NotNull List<Param> params, @NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        this.name = name;
        this.params = params;
        this.code = code;
        this.memDepth = -1;
        this.memoryAllocator = new MemoryAllocator();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Param> getParams() {
        return this.params;
    }

    @NotNull
    public final List<Statement> getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public ClassDefinition copy() {
        Object object;
        Statement it;
        Collection<Param> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.params;
        String string = this.name;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Param param = (Param)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((Param)((Object)it)).copy();
            collection.add((Param)object);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.code;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Statement statement = it.copy();
            object.add(statement);
        }
        Object object2 = object = (List)destination$iv$iv;
        Collection<Param> collection2 = collection;
        String string2 = string;
        ClassDefinition ret2 = new ClassDefinition(string2, (List<Param>)collection2, (List<? extends Statement>)object2);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.memDepth = ctx.getMemoryDepth();
        if (ctx.hasTypeInThisContext(new Type(this.name))) {
            throw new ParserException("type `" + this.name + "` is already defined", this.getLineCol());
        }
        ClassTypeInstance thisType = new ClassTypeInstance(this);
        ctx.addType(new Type(this.name), thisType);
        TypeContext codeCtx = new TypeContext(ctx, thisType, this);
        for (Param param : this.params) {
            TypeInstance paramType = param.check(ctx, null);
            param.setMemIndex$vjson(this.memoryAllocator.nextIndexFor(paramType));
            codeCtx.addVariable(new Variable(param.getName(), paramType, true, null, new MemPos(codeCtx.getMemoryDepth(), param.getMemIndex$vjson())));
        }
        codeCtx.checkStatements(this.code);
    }

    @Override
    public boolean functionTerminationCheck() {
        return false;
    }

    @Override
    @NotNull
    public MemoryAllocator memoryAllocator() {
        return this.memoryAllocator;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        return new NoOp();
    }

    public final int getMemDepth() {
        return this.memDepth;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("class ").append(this.name).append(":");
        sb.append(CollectionsKt.joinToString$default((Iterable)this.params, (CharSequence)", ", (CharSequence)" { ", (CharSequence)" } ", (int)0, null, null, (int)56, null));
        sb.append("do: {\n");
        for (Statement stmt : this.code) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<Param> component2() {
        return this.params;
    }

    @NotNull
    public final List<Statement> component3() {
        return this.code;
    }

    @NotNull
    public final ClassDefinition copy(@NotNull String name, @NotNull List<Param> params, @NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return new ClassDefinition(name, params, code);
    }

    public static /* synthetic */ ClassDefinition copy$default(ClassDefinition classDefinition, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = classDefinition.name;
        }
        if ((n & 2) != 0) {
            list = classDefinition.params;
        }
        if ((n & 4) != 0) {
            list2 = classDefinition.code;
        }
        return classDefinition.copy(string, list, list2);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.params).hashCode();
        result = result * 31 + ((Object)this.code).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassDefinition)) {
            return false;
        }
        ClassDefinition classDefinition = (ClassDefinition)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)classDefinition.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.params, classDefinition.params)) {
            return false;
        }
        return Intrinsics.areEqual(this.code, classDefinition.code);
    }
}

