/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Statement;
import vjson.pl.inst.ErrorHandlingInstruction;
import vjson.pl.inst.Instruction;
import vjson.pl.type.ErrorType;
import vjson.pl.type.MemPos;
import vjson.pl.type.TypeContext;
import vjson.pl.type.Variable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J9\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001f"}, d2={"Lvjson/pl/ast/ErrorHandlingStatement;", "Lvjson/pl/ast/Statement;", "tryCode", "", "errorCode", "elseCode", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getElseCode", "()Ljava/util/List;", "getErrorCode", "getTryCode", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "vjson"})
public final class ErrorHandlingStatement
extends Statement {
    @NotNull
    private final List<Statement> tryCode;
    @NotNull
    private final List<Statement> errorCode;
    @NotNull
    private final List<Statement> elseCode;

    public ErrorHandlingStatement(@NotNull List<? extends Statement> tryCode, @NotNull List<? extends Statement> errorCode, @NotNull List<? extends Statement> elseCode) {
        Intrinsics.checkNotNullParameter(tryCode, (String)"tryCode");
        Intrinsics.checkNotNullParameter(errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter(elseCode, (String)"elseCode");
        this.tryCode = tryCode;
        this.errorCode = errorCode;
        this.elseCode = elseCode;
    }

    @NotNull
    public final List<Statement> getTryCode() {
        return this.tryCode;
    }

    @NotNull
    public final List<Statement> getErrorCode() {
        return this.errorCode;
    }

    @NotNull
    public final List<Statement> getElseCode() {
        return this.elseCode;
    }

    @Override
    @NotNull
    public ErrorHandlingStatement copy() {
        Object object;
        Object object2;
        Statement it;
        Collection<Statement> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tryCode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object2 = it.copy();
            collection.add((Statement)object2);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.errorCode;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.copy();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        $this$map$iv = this.elseCode;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Statement statement = it.copy();
            object.add(statement);
        }
        Object object3 = object = (List)destination$iv$iv;
        Object object4 = object2;
        Collection<Statement> collection2 = collection;
        ErrorHandlingStatement ret2 = new ErrorHandlingStatement((List<? extends Statement>)collection2, (List<? extends Statement>)object4, (List<? extends Statement>)object3);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.checkStatements(this.tryCode);
        TypeContext errorCtx = new TypeContext(ctx, null, null, 6, null);
        errorCtx.addVariable(new Variable("err", ErrorType.INSTANCE, false, null, new MemPos(0, 0)));
        errorCtx.checkStatements(this.errorCode);
        TypeContext elseCtx = new TypeContext(ctx, null, null, 6, null);
        elseCtx.checkStatements(this.elseCode);
        boolean tryCodeTerminate = false;
        for (Statement stmt : this.tryCode) {
            if (!stmt.functionTerminationCheck()) continue;
            tryCodeTerminate = true;
        }
        if (tryCodeTerminate) {
            Collection collection = this.elseCode;
            boolean bl = false;
            if (!collection.isEmpty()) {
                throw new ParserException(this + ": the code to be handled already terminates the function, no `else` should appear");
            }
        }
    }

    @Override
    public boolean functionTerminationCheck() {
        boolean errorCodeTerminate = false;
        for (Statement stmt : this.errorCode) {
            if (!stmt.functionTerminationCheck()) continue;
            errorCodeTerminate = true;
            break;
        }
        if (!errorCodeTerminate) {
            return false;
        }
        boolean elseCodeTerminate = false;
        for (Statement stmt : this.elseCode) {
            if (!stmt.functionTerminationCheck()) continue;
            elseCodeTerminate = true;
            break;
        }
        return elseCodeTerminate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Instruction generateInstruction() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Instruction instruction;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv = this.tryCode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List tryInst = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.errorCode;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Statement bl = (Statement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List errorCodeInst = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = this.elseCode;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Statement bl2 = (Statement)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List elseCodeInst = (List)destination$iv$iv3;
        return new ErrorHandlingInstruction(tryInst, errorCodeInst, elseCodeInst);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* Error Handling Begin */\n");
        for (Statement stmt : this.tryCode) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append(stmt.toString(indent)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("/* Error Handling End */\n");
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("if: err != nil; then: {\n");
        for (Statement stmt : this.errorCode) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("} else: {\n");
        for (Statement stmt : this.elseCode) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final List<Statement> component1() {
        return this.tryCode;
    }

    @NotNull
    public final List<Statement> component2() {
        return this.errorCode;
    }

    @NotNull
    public final List<Statement> component3() {
        return this.elseCode;
    }

    @NotNull
    public final ErrorHandlingStatement copy(@NotNull List<? extends Statement> tryCode, @NotNull List<? extends Statement> errorCode, @NotNull List<? extends Statement> elseCode) {
        Intrinsics.checkNotNullParameter(tryCode, (String)"tryCode");
        Intrinsics.checkNotNullParameter(errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter(elseCode, (String)"elseCode");
        return new ErrorHandlingStatement(tryCode, errorCode, elseCode);
    }

    public static /* synthetic */ ErrorHandlingStatement copy$default(ErrorHandlingStatement errorHandlingStatement, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = errorHandlingStatement.tryCode;
        }
        if ((n & 2) != 0) {
            list2 = errorHandlingStatement.errorCode;
        }
        if ((n & 4) != 0) {
            list3 = errorHandlingStatement.elseCode;
        }
        return errorHandlingStatement.copy(list, list2, list3);
    }

    public int hashCode() {
        int result = ((Object)this.tryCode).hashCode();
        result = result * 31 + ((Object)this.errorCode).hashCode();
        result = result * 31 + ((Object)this.elseCode).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ErrorHandlingStatement)) {
            return false;
        }
        ErrorHandlingStatement errorHandlingStatement = (ErrorHandlingStatement)other;
        if (!Intrinsics.areEqual(this.tryCode, errorHandlingStatement.tryCode)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorCode, errorHandlingStatement.errorCode)) {
            return false;
        }
        return Intrinsics.areEqual(this.elseCode, errorHandlingStatement.elseCode);
    }
}

