/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.BoolLiteral;
import vjson.pl.ast.Expr;
import vjson.pl.ast.LoopStatement;
import vjson.pl.ast.Statement;
import vjson.pl.inst.ForLoopInstruction;
import vjson.pl.inst.Instruction;
import vjson.pl.type.BoolType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\b\u0010\u0018\u001a\u00020\u0000H\u0016JC\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006%"}, d2={"Lvjson/pl/ast/ForLoop;", "Lvjson/pl/ast/LoopStatement;", "init", "", "Lvjson/pl/ast/Statement;", "condition", "Lvjson/pl/ast/Expr;", "incr", "code", "(Ljava/util/List;Lvjson/pl/ast/Expr;Ljava/util/List;Ljava/util/List;)V", "getCode", "()Ljava/util/List;", "getCondition", "()Lvjson/pl/ast/Expr;", "getIncr", "getInit", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "vjson"})
public final class ForLoop
extends LoopStatement {
    @NotNull
    private final List<Statement> init;
    @NotNull
    private final Expr condition;
    @NotNull
    private final List<Statement> incr;
    @NotNull
    private final List<Statement> code;

    public ForLoop(@NotNull List<? extends Statement> init, @NotNull Expr condition, @NotNull List<? extends Statement> incr, @NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(incr, (String)"incr");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        super(null, 1, null);
        this.init = init;
        this.condition = condition;
        this.incr = incr;
        this.code = code;
    }

    @NotNull
    public final List<Statement> getInit() {
        return this.init;
    }

    @NotNull
    public final Expr getCondition() {
        return this.condition;
    }

    @NotNull
    public final List<Statement> getIncr() {
        return this.incr;
    }

    @NotNull
    public final List<Statement> getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public ForLoop copy() {
        Object object;
        Collection<Statement> collection;
        Statement statement;
        Statement it;
        Collection<Statement> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.init;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Statement statement2 = (Statement)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            statement = it.copy();
            collection2.add(statement);
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = this.incr;
        statement = this.condition.copy();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.copy();
            collection.add((Statement)object);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.code;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Statement statement3 = it.copy();
            object.add(statement3);
        }
        Object object2 = object = (List)destination$iv$iv;
        Collection<Statement> collection3 = collection;
        Statement statement4 = statement;
        Collection<Statement> collection4 = collection2;
        ForLoop ret2 = new ForLoop((List<? extends Statement>)collection4, (Expr)statement4, (List<? extends Statement>)collection3, (List<? extends Statement>)object2);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TypeContext forInitCtx = new TypeContext(ctx, null, null, 6, null);
        forInitCtx.checkStatements(this.init);
        TypeContext forConditionCtx = new TypeContext(forInitCtx, null, null, 6, null);
        TypeInstance conditionType = this.condition.check(forConditionCtx, BoolType.INSTANCE);
        if (!(conditionType instanceof BoolType)) {
            throw new ParserException(this.condition + " (" + conditionType + ") is not a boolean value, cannot be used as `for` loop condition", this.getLineCol());
        }
        TypeContext forIncrCtx = new TypeContext(forInitCtx, null, null, 6, null);
        forIncrCtx.checkStatements(this.incr);
        TypeContext forCodeCtx = new TypeContext(forInitCtx, null, this, 2, null);
        forCodeCtx.checkStatements(this.code);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Instruction generateInstruction() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Instruction instruction;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv = this.init;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator it;
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List initInst = (List)destination$iv$iv;
        Instruction conditionInst = this.condition.generateInstruction();
        Iterable $this$map$iv2 = this.incr;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List incrInst = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = this.code;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Statement bl = (Statement)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List codeInst = (List)destination$iv$iv3;
        return new ForLoopInstruction(initInst, conditionInst, incrInst, codeInst);
    }

    @Override
    public boolean functionTerminationCheck() {
        if (!(this.condition instanceof BoolLiteral) || !((BoolLiteral)this.condition).getB()) {
            return false;
        }
        Boolean bl = this.isInfiniteLoop();
        if (bl == null) {
            return true;
        }
        return bl;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        Statement stmt;
        int idx;
        StringBuilder sb = new StringBuilder();
        boolean newLinePrinted = false;
        sb.append("for: [ ");
        Object object = this.init.iterator();
        int n = 0;
        while (object.hasNext()) {
            idx = n++;
            stmt = object.next();
            if (idx != 0) {
                sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2)));
            }
            sb.append(stmt.toString(indent + 2));
            if (idx == this.init.size() - 1) continue;
            newLinePrinted = true;
            sb.append("\n");
        }
        sb.append(" ; ").append(this.condition.toString(indent + 2)).append(" ; ");
        object = this.incr.iterator();
        n = 0;
        while (object.hasNext()) {
            idx = n++;
            stmt = object.next();
            if (idx != 0) {
                sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2)));
            }
            sb.append(stmt.toString(indent + 2));
            if (idx == this.incr.size() - 1) continue;
            newLinePrinted = true;
            sb.append("\n");
        }
        if (newLinePrinted) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)indent));
        }
        sb.append(" ] do: {\n");
        for (Statement stmt2 : this.code) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt2.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}");
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final List<Statement> component1() {
        return this.init;
    }

    @NotNull
    public final Expr component2() {
        return this.condition;
    }

    @NotNull
    public final List<Statement> component3() {
        return this.incr;
    }

    @NotNull
    public final List<Statement> component4() {
        return this.code;
    }

    @NotNull
    public final ForLoop copy(@NotNull List<? extends Statement> init, @NotNull Expr condition, @NotNull List<? extends Statement> incr, @NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(incr, (String)"incr");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return new ForLoop(init, condition, incr, code);
    }

    public static /* synthetic */ ForLoop copy$default(ForLoop forLoop, List list, Expr expr, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = forLoop.init;
        }
        if ((n & 2) != 0) {
            expr = forLoop.condition;
        }
        if ((n & 4) != 0) {
            list2 = forLoop.incr;
        }
        if ((n & 8) != 0) {
            list3 = forLoop.code;
        }
        return forLoop.copy(list, expr, list2, list3);
    }

    public int hashCode() {
        int result = ((Object)this.init).hashCode();
        result = result * 31 + this.condition.hashCode();
        result = result * 31 + ((Object)this.incr).hashCode();
        result = result * 31 + ((Object)this.code).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForLoop)) {
            return false;
        }
        ForLoop forLoop = (ForLoop)other;
        if (!Intrinsics.areEqual(this.init, forLoop.init)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.condition, (Object)forLoop.condition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.incr, forLoop.incr)) {
            return false;
        }
        return Intrinsics.areEqual(this.code, forLoop.code);
    }
}

