/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Modifiers;
import vjson.pl.ast.Param;
import vjson.pl.ast.Statement;
import vjson.pl.ast.Type;
import vjson.pl.ast.TypedAST;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.CompositeInstruction;
import vjson.pl.inst.Execution;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.StackInfo;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.FunctionDescriptorTypeInstance;
import vjson.pl.type.MemPos;
import vjson.pl.type.MemoryAllocator;
import vjson.pl.type.MemoryAllocatorProvider;
import vjson.pl.type.ParamInstance;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.Variable;
import vjson.pl.type.VoidType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\b\u0010$\u001a\u00020\u0000H\u0016JG\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020/J\t\u00100\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020\u0004H\u0016J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u001cH\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lvjson/pl/ast/FunctionDefinition;", "Lvjson/pl/ast/Statement;", "Lvjson/pl/type/MemoryAllocatorProvider;", "name", "", "params", "", "Lvjson/pl/ast/Param;", "returnType", "Lvjson/pl/ast/Type;", "code", "modifiers", "Lvjson/pl/ast/Modifiers;", "(Ljava/lang/String;Ljava/util/List;Lvjson/pl/ast/Type;Ljava/util/List;Lvjson/pl/ast/Modifiers;)V", "getCode", "()Ljava/util/List;", "ctx", "Lvjson/pl/type/TypeContext;", "memoryAllocator", "Lvjson/pl/type/MemoryAllocator;", "getModifiers", "()Lvjson/pl/ast/Modifiers;", "getName", "()Ljava/lang/String;", "getParams", "getReturnType", "()Lvjson/pl/ast/Type;", "variableIndex", "", "checkAST", "", "component1", "component2", "component3", "component4", "component5", "copy", "descriptor", "Lvjson/pl/type/FunctionDescriptor;", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "getMemPos", "Lvjson/pl/type/MemPos;", "hashCode", "toString", "indent", "vjson"})
public final class FunctionDefinition
extends Statement
implements MemoryAllocatorProvider {
    @NotNull
    private final String name;
    @NotNull
    private final List<Param> params;
    @NotNull
    private final Type returnType;
    @NotNull
    private final List<Statement> code;
    @NotNull
    private final Modifiers modifiers;
    @Nullable
    private TypeContext ctx;
    private int variableIndex;
    @NotNull
    private final MemoryAllocator memoryAllocator;

    public FunctionDefinition(@NotNull String name, @NotNull List<Param> params, @NotNull Type returnType, @NotNull List<? extends Statement> code, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        this.name = name;
        this.params = params;
        this.returnType = returnType;
        this.code = code;
        this.modifiers = modifiers;
        this.variableIndex = -1;
        this.memoryAllocator = new MemoryAllocator();
    }

    public /* synthetic */ FunctionDefinition(String string, List list, Type type, List list2, Modifiers modifiers, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            modifiers = new Modifiers(0);
        }
        this(string, list, type, list2, modifiers);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Param> getParams() {
        return this.params;
    }

    @NotNull
    public final Type getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final List<Statement> getCode() {
        return this.code;
    }

    @NotNull
    public final Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    @NotNull
    public FunctionDefinition copy() {
        Collection<Statement> collection;
        TypedAST typedAST;
        Statement it;
        Collection<Param> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.params;
        String string = this.name;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Param param = (Param)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            typedAST = ((Param)((Object)it)).copy();
            collection2.add((Param)typedAST);
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = this.code;
        typedAST = this.returnType.copy();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Statement statement = it.copy();
            collection.add(statement);
        }
        collection = (List)destination$iv$iv;
        Modifiers modifiers = this.modifiers;
        Collection<Statement> collection3 = collection;
        TypedAST typedAST2 = typedAST;
        Collection<Param> collection4 = collection2;
        String string2 = string;
        FunctionDefinition ret2 = new FunctionDefinition(string2, (List<Param>)collection4, (Type)typedAST2, (List<? extends Statement>)collection3, modifiers);
        ret2.getLineCol();
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Statement lastStatement;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        if (ctx.hasVariableInThisContext(this.name)) {
            throw new ParserException("variable " + this.name + " is already defined", this.getLineCol());
        }
        TypeContext codeCtx = new TypeContext(ctx, null, this, 2, null);
        ArrayList<ParamInstance> paramTypes = new ArrayList<ParamInstance>(this.params.size());
        for (Param p : this.params) {
            TypeInstance paramType = p.check(codeCtx, null);
            p.setMemIndex$vjson(this.memoryAllocator.nextIndexFor(paramType));
            paramTypes.add(new ParamInstance(p.getName(), paramType, p.getMemIndex$vjson(), null, 8, null));
            codeCtx.addVariable(new Variable(p.getName(), paramType, true, null, new MemPos(codeCtx.getMemoryDepth(), p.getMemIndex$vjson())));
        }
        TypeInstance returnTypeInstance = this.returnType.check(codeCtx, null);
        FunctionDescriptor funcType = ctx.getFunctionDescriptor((List<ParamInstance>)paramTypes, returnTypeInstance, this);
        this.variableIndex = ctx.getMemoryAllocator().nextRefIndex();
        ctx.addVariable(new Variable(this.name, new FunctionDescriptorTypeInstance(funcType), false, null, new MemPos(ctx.getMemoryDepth(), this.variableIndex)));
        codeCtx.checkStatements(this.code);
        if (!(returnTypeInstance instanceof VoidType) && !(lastStatement = (Statement)CollectionsKt.last(this.code)).functionTerminationCheck()) {
            throw new ParserException("function " + this.name + " not ending properly: missing return statement", this.getLineCol());
        }
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        int memDepth = typeContext.getMemoryDepth();
        ArrayList<Instruction> ins = new ArrayList<Instruction>(this.code.size());
        for (Statement stmt : this.code) {
            ins.add(stmt.generateInstruction());
        }
        CompositeInstruction composite = new CompositeInstruction((List<? extends Instruction>)ins);
        return new Instruction(this, memDepth, composite){
            @NotNull
            private final StackInfo stackInfo;
            final /* synthetic */ FunctionDefinition this$0;
            final /* synthetic */ int $memDepth;
            final /* synthetic */ CompositeInstruction $composite;
            {
                this.this$0 = $receiver;
                this.$memDepth = $memDepth;
                this.$composite = $composite;
                TypeContext typeContext = FunctionDefinition.access$getCtx$p(this.this$0);
                Intrinsics.checkNotNull((Object)typeContext);
                this.stackInfo = typeContext.stackInfo(this.this$0.getLineCol());
            }

            @NotNull
            public StackInfo getStackInfo() {
                return this.stackInfo;
            }

            protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
                ctx.getMem(this.$memDepth).setRef(FunctionDefinition.access$getVariableIndex$p(this.this$0), this.$composite);
            }
        };
    }

    @Override
    public boolean functionTerminationCheck() {
        return false;
    }

    @NotNull
    public final FunctionDescriptor descriptor(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ArrayList<ParamInstance> paramTypes = new ArrayList<ParamInstance>(this.params.size());
        for (Param p : this.params) {
            paramTypes.add(new ParamInstance(p.getName(), p.typeInstance(), p.getMemIndex$vjson(), null, 8, null));
        }
        TypeInstance returnType = this.returnType.typeInstance();
        return ctx.getFunctionDescriptor((List<ParamInstance>)paramTypes, returnType, this);
    }

    @Override
    @NotNull
    public MemoryAllocator memoryAllocator() {
        return this.memoryAllocator;
    }

    @NotNull
    public final MemPos getMemPos() {
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        return new MemPos(typeContext.getMemoryDepth(), this.variableIndex);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.modifiers.toStringWithSpace());
        sb.append("function ").append(this.name).append(":");
        sb.append(CollectionsKt.joinToString$default((Iterable)this.params, (CharSequence)", ", (CharSequence)" { ", (CharSequence)" } ", (int)0, null, null, (int)56, null));
        sb.append(this.returnType);
        sb.append(": {\n");
        for (Statement stmt : this.code) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<Param> component2() {
        return this.params;
    }

    @NotNull
    public final Type component3() {
        return this.returnType;
    }

    @NotNull
    public final List<Statement> component4() {
        return this.code;
    }

    @NotNull
    public final Modifiers component5() {
        return this.modifiers;
    }

    @NotNull
    public final FunctionDefinition copy(@NotNull String name, @NotNull List<Param> params, @NotNull Type returnType, @NotNull List<? extends Statement> code, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        return new FunctionDefinition(name, params, returnType, code, modifiers);
    }

    public static /* synthetic */ FunctionDefinition copy$default(FunctionDefinition functionDefinition, String string, List list, Type type, List list2, Modifiers modifiers, int n, Object object) {
        if ((n & 1) != 0) {
            string = functionDefinition.name;
        }
        if ((n & 2) != 0) {
            list = functionDefinition.params;
        }
        if ((n & 4) != 0) {
            type = functionDefinition.returnType;
        }
        if ((n & 8) != 0) {
            list2 = functionDefinition.code;
        }
        if ((n & 0x10) != 0) {
            modifiers = functionDefinition.modifiers;
        }
        return functionDefinition.copy(string, list, type, list2, modifiers);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.params).hashCode();
        result = result * 31 + this.returnType.hashCode();
        result = result * 31 + ((Object)this.code).hashCode();
        result = result * 31 + this.modifiers.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FunctionDefinition)) {
            return false;
        }
        FunctionDefinition functionDefinition = (FunctionDefinition)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)functionDefinition.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.params, functionDefinition.params)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.returnType, (Object)functionDefinition.returnType)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.code, functionDefinition.code)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.modifiers, (Object)functionDefinition.modifiers);
    }

    public static final /* synthetic */ TypeContext access$getCtx$p(FunctionDefinition $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ int access$getVariableIndex$p(FunctionDefinition $this) {
        return $this.variableIndex;
    }
}

