/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ast.Expr;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.FunctionInstance;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.InstructionWithStackInfo;
import vjson.pl.inst.RuntimeMemory;
import vjson.pl.inst.StackInfo;
import vjson.pl.type.BoolType;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.ParamInstance;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\t\u0010\u000f\u001a\u00020\u0001H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u00c6\u0003J\b\u0010\u0011\u001a\u00020\u0000H\u0016J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lvjson/pl/ast/FunctionInvocation;", "Lvjson/pl/ast/Expr;", "target", "args", "", "(Lvjson/pl/ast/Expr;Ljava/util/List;)V", "getArgs", "()Ljava/util/List;", "getTarget", "()Lvjson/pl/ast/Expr;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "typeInstance", "Companion", "vjson"})
public final class FunctionInvocation
extends Expr {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Expr target;
    @NotNull
    private final List<Expr> args;

    public FunctionInvocation(@NotNull Expr target, @NotNull List<? extends Expr> args) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.target = target;
        this.args = args;
    }

    @NotNull
    public final Expr getTarget() {
        return this.target;
    }

    @NotNull
    public final List<Expr> getArgs() {
        return this.args;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FunctionInvocation copy() {
        Collection<Expr> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.args;
        Expr expr = this.target.copy();
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Expr expr2 = (Expr)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Expr expr3 = it.copy();
            collection.add(expr3);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Expr expr4 = expr;
        FunctionInvocation ret2 = new FunctionInvocation(expr4, list);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        TypeInstance targetType = this.target.check(ctx, null);
        FunctionDescriptor functionDescriptor = targetType.functionDescriptor(ctx);
        if (functionDescriptor == null) {
            throw new ParserException(this + ": unable to invoke " + this.target + ", which is not a functional object", this.getLineCol());
        }
        FunctionDescriptor func = functionDescriptor;
        if (func.getParams().size() != this.args.size()) {
            throw new ParserException(this + ": unable to invoke " + this.target + " with " + this.args + ", arguments count (" + this.args.size() + ") parameters count (" + func.getParams().size() + ") mismatch", this.getLineCol());
        }
        int n = 0;
        int n2 = this.args.size() + -1;
        if (n <= n2) {
            do {
                int idx = n++;
                TypeInstance argType = this.args.get(idx).check(ctx, func.getParams().get(idx).getType());
                ParamInstance paramType = func.getParams().get(idx);
                if (TypeUtils.INSTANCE.assignableFrom(paramType.getType(), argType)) continue;
                throw new ParserException(this + ": unable to invoke " + this.target + " with " + this.args + ", args[" + idx + "] " + argType + " does not match params[" + idx + "] " + paramType, this.getLineCol());
            } while (n <= n2);
        }
        return func.getReturnType();
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        FunctionDescriptor functionDescriptor = this.target.typeInstance().functionDescriptor(this.getCtx());
        Intrinsics.checkNotNull((Object)functionDescriptor);
        return functionDescriptor.getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Instruction generateInstruction() {
        Collection<Instruction> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.args;
        FunctionInvocation functionInvocation = this;
        TypeContext typeContext = this.getCtx();
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Expr expr = (Expr)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Instruction instruction = it.generateInstruction();
            collection.add(instruction);
        }
        collection = (List)destination$iv$iv;
        return companion.buildFunctionInvocationInstruction(typeContext, functionInvocation, (List<? extends Instruction>)collection);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "" + '(' + this.target + ':' + this.args + ')';
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final Expr component1() {
        return this.target;
    }

    @NotNull
    public final List<Expr> component2() {
        return this.args;
    }

    @NotNull
    public final FunctionInvocation copy(@NotNull Expr target, @NotNull List<? extends Expr> args) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new FunctionInvocation(target, args);
    }

    public static /* synthetic */ FunctionInvocation copy$default(FunctionInvocation functionInvocation, Expr expr, List list, int n, Object object) {
        if ((n & 1) != 0) {
            expr = functionInvocation.target;
        }
        if ((n & 2) != 0) {
            list = functionInvocation.args;
        }
        return functionInvocation.copy(expr, list);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = result * 31 + ((Object)this.args).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FunctionInvocation)) {
            return false;
        }
        FunctionInvocation functionInvocation = (FunctionInvocation)other;
        if (!Intrinsics.areEqual((Object)this.target, (Object)functionInvocation.target)) {
            return false;
        }
        return Intrinsics.areEqual(this.args, functionInvocation.args);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ4\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lvjson/pl/ast/FunctionInvocation$Companion;", "", "()V", "buildContext", "Lvjson/pl/inst/ActionContext;", "callerCtx", "ctx", "exec", "Lvjson/pl/inst/Execution;", "funcDesc", "Lvjson/pl/type/FunctionDescriptor;", "args", "", "Lvjson/pl/inst/Instruction;", "buildFunctionInvocationInstruction", "Lvjson/pl/type/TypeContext;", "func", "Lvjson/pl/ast/FunctionInvocation;", "invokeFunction", "funcInst", "lineCol", "Lvjson/cs/LineCol;", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Instruction buildFunctionInvocationInstruction(@NotNull TypeContext ctx, @NotNull FunctionInvocation func, @NotNull List<? extends Instruction> args) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            FunctionDescriptor functionDescriptor = func.getTarget().typeInstance().functionDescriptor(ctx);
            Intrinsics.checkNotNull((Object)functionDescriptor);
            FunctionDescriptor funcDesc = functionDescriptor;
            Instruction funcInst = func.getTarget().generateInstruction();
            return this.invokeFunction(ctx, funcDesc, funcInst, args, func.getLineCol());
        }

        @NotNull
        public final Instruction invokeFunction(@NotNull TypeContext ctx, @NotNull FunctionDescriptor funcDesc, @NotNull Instruction funcInst, @NotNull List<? extends Instruction> args, @NotNull LineCol lineCol) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)funcDesc, (String)"funcDesc");
            Intrinsics.checkNotNullParameter((Object)funcInst, (String)"funcInst");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
            StackInfo stackInfo2 = ctx.stackInfo(lineCol);
            return new InstructionWithStackInfo(funcInst, funcDesc, args, stackInfo2){
                final /* synthetic */ Instruction $funcInst;
                final /* synthetic */ FunctionDescriptor $funcDesc;
                final /* synthetic */ List<Instruction> $args;
                {
                    this.$funcInst = $funcInst;
                    this.$funcDesc = $funcDesc;
                    this.$args = $args;
                    super($super_call_param$1);
                }

                protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
                    if (this.$funcInst instanceof FunctionInstance) {
                        ((FunctionInstance)this.$funcInst).setCtxBuilder((Function1<? super ActionContext, ActionContext>)((Function1)new Function1<ActionContext, ActionContext>(ctx, exec, this.$funcDesc, this.$args){
                            final /* synthetic */ ActionContext $ctx;
                            final /* synthetic */ Execution $exec;
                            final /* synthetic */ FunctionDescriptor $funcDesc;
                            final /* synthetic */ List<Instruction> $args;
                            {
                                this.$ctx = $ctx;
                                this.$exec = $exec;
                                this.$funcDesc = $funcDesc;
                                this.$args = $args;
                                super(1);
                            }

                            @NotNull
                            public final ActionContext invoke(@NotNull ActionContext it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return FunctionInvocation.Companion.buildContext(this.$ctx, it, this.$exec, this.$funcDesc, this.$args);
                            }
                        }));
                        this.$funcInst.execute(ctx, exec);
                    } else {
                        this.$funcInst.execute(ctx, exec);
                        Object object = exec.getValues().getRefValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type vjson.pl.inst.Instruction");
                        }
                        Instruction funcValue = (Instruction)object;
                        ActionContext newCtx = FunctionInvocation.Companion.buildContext(ctx, ctx, exec, this.$funcDesc, this.$args);
                        funcValue.execute(newCtx, exec);
                    }
                }
            };
        }

        @NotNull
        public final ActionContext buildContext(@NotNull ActionContext callerCtx, @NotNull ActionContext ctx, @NotNull Execution exec, @NotNull FunctionDescriptor funcDesc, @NotNull List<? extends Instruction> args) {
            Intrinsics.checkNotNullParameter((Object)callerCtx, (String)"callerCtx");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
            Intrinsics.checkNotNullParameter((Object)funcDesc, (String)"funcDesc");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            ActionContext newCtx = new ActionContext(funcDesc.getMem().memoryAllocator().getTotal(), ctx);
            RuntimeMemory newMem = newCtx.getCurrentMem();
            int n = 0;
            int n2 = args.size() + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    args.get(i).execute(callerCtx, exec);
                    ParamInstance param = funcDesc.getParams().get(i);
                    TypeInstance typeInstance = param.getType();
                    if (typeInstance instanceof IntType) {
                        newMem.setInt(param.getMemIndex(), exec.getValues().getIntValue());
                        continue;
                    }
                    if (typeInstance instanceof LongType) {
                        newMem.setLong(param.getMemIndex(), exec.getValues().getLongValue());
                        continue;
                    }
                    if (typeInstance instanceof FloatType) {
                        newMem.setFloat(param.getMemIndex(), exec.getValues().getFloatValue());
                        continue;
                    }
                    if (typeInstance instanceof DoubleType) {
                        newMem.setDouble(param.getMemIndex(), exec.getValues().getDoubleValue());
                        continue;
                    }
                    if (typeInstance instanceof BoolType) {
                        newMem.setBool(param.getMemIndex(), exec.getValues().getBoolValue());
                        continue;
                    }
                    newMem.setRef(param.getMemIndex(), exec.getValues().getRefValue());
                } while (n <= n2);
            }
            return newCtx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

