/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Expr;
import vjson.pl.ast.Statement;
import vjson.pl.inst.IfInstruction;
import vjson.pl.inst.Instruction;
import vjson.pl.type.BoolType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\b\u0010\u0014\u001a\u00020\u0000H\u0016J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006!"}, d2={"Lvjson/pl/ast/IfStatement;", "Lvjson/pl/ast/Statement;", "condition", "Lvjson/pl/ast/Expr;", "ifCode", "", "elseCode", "(Lvjson/pl/ast/Expr;Ljava/util/List;Ljava/util/List;)V", "getCondition", "()Lvjson/pl/ast/Expr;", "getElseCode", "()Ljava/util/List;", "getIfCode", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "vjson"})
public final class IfStatement
extends Statement {
    @NotNull
    private final Expr condition;
    @NotNull
    private final List<Statement> ifCode;
    @NotNull
    private final List<Statement> elseCode;

    public IfStatement(@NotNull Expr condition, @NotNull List<? extends Statement> ifCode, @NotNull List<? extends Statement> elseCode) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(ifCode, (String)"ifCode");
        Intrinsics.checkNotNullParameter(elseCode, (String)"elseCode");
        this.condition = condition;
        this.ifCode = ifCode;
        this.elseCode = elseCode;
    }

    @NotNull
    public final Expr getCondition() {
        return this.condition;
    }

    @NotNull
    public final List<Statement> getIfCode() {
        return this.ifCode;
    }

    @NotNull
    public final List<Statement> getElseCode() {
        return this.elseCode;
    }

    @Override
    @NotNull
    public IfStatement copy() {
        Object object;
        Statement it;
        Collection<Statement> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.ifCode;
        Expr expr = this.condition.copy();
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.copy();
            collection.add((Statement)object);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.elseCode;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Statement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Statement statement = it.copy();
            object.add(statement);
        }
        Object object2 = object = (List)destination$iv$iv;
        Collection<Statement> collection2 = collection;
        Expr expr2 = expr;
        IfStatement ret2 = new IfStatement(expr2, (List<? extends Statement>)collection2, (List<? extends Statement>)object2);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TypeInstance conditionType = this.condition.check(ctx, BoolType.INSTANCE);
        if (!(conditionType instanceof BoolType)) {
            throw new ParserException(this + ": type of condition (" + conditionType + ") is not bool", this.getLineCol());
        }
        TypeContext ifCtx = new TypeContext(ctx, null, null, 6, null);
        ifCtx.checkStatements(this.ifCode);
        TypeContext elseCtx = new TypeContext(ctx, null, null, 6, null);
        elseCtx.checkStatements(this.elseCode);
    }

    @Override
    public boolean functionTerminationCheck() {
        boolean ifCodeTerminate = false;
        for (Statement stmt : this.ifCode) {
            if (!stmt.functionTerminationCheck()) continue;
            ifCodeTerminate = true;
            break;
        }
        if (!ifCodeTerminate) {
            return false;
        }
        boolean elseCodeTerminate = false;
        for (Statement stmt : this.elseCode) {
            if (!stmt.functionTerminationCheck()) continue;
            elseCodeTerminate = true;
            break;
        }
        return elseCodeTerminate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Instruction generateInstruction() {
        void $this$mapTo$iv$iv;
        Instruction instruction;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Instruction conditionInst = this.condition.generateInstruction();
        Iterable $this$map$iv = this.ifCode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List ifCodeInst = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.elseCode;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Statement bl = (Statement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List elseCodeInst = (List)destination$iv$iv2;
        return new IfInstruction(conditionInst, ifCodeInst, elseCodeInst);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("if: " + this.condition + "; then: {\n");
        for (Statement stmt : this.ifCode) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("} else: {\n");
        for (Statement stmt : this.elseCode) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final Expr component1() {
        return this.condition;
    }

    @NotNull
    public final List<Statement> component2() {
        return this.ifCode;
    }

    @NotNull
    public final List<Statement> component3() {
        return this.elseCode;
    }

    @NotNull
    public final IfStatement copy(@NotNull Expr condition, @NotNull List<? extends Statement> ifCode, @NotNull List<? extends Statement> elseCode) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(ifCode, (String)"ifCode");
        Intrinsics.checkNotNullParameter(elseCode, (String)"elseCode");
        return new IfStatement(condition, ifCode, elseCode);
    }

    public static /* synthetic */ IfStatement copy$default(IfStatement ifStatement, Expr expr, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            expr = ifStatement.condition;
        }
        if ((n & 2) != 0) {
            list = ifStatement.ifCode;
        }
        if ((n & 4) != 0) {
            list2 = ifStatement.elseCode;
        }
        return ifStatement.copy(expr, list, list2);
    }

    public int hashCode() {
        int result = this.condition.hashCode();
        result = result * 31 + ((Object)this.ifCode).hashCode();
        result = result * 31 + ((Object)this.elseCode).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)other;
        if (!Intrinsics.areEqual((Object)this.condition, (Object)ifStatement.condition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ifCode, ifStatement.ifCode)) {
            return false;
        }
        return Intrinsics.areEqual(this.elseCode, ifStatement.elseCode);
    }
}

