/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.pl.ast.Expr;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.LiteralDouble;
import vjson.pl.inst.LiteralFloat;
import vjson.pl.inst.LiteralInt;
import vjson.pl.inst.LiteralLong;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0017\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lvjson/pl/ast/IntegerLiteral;", "Lvjson/pl/ast/Expr;", "n", "Lvjson/JSON$Number;", "(Lvjson/JSON$Number;)V", "getN", "()Lvjson/JSON$Number;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "typeInstance", "vjson"})
public final class IntegerLiteral
extends Expr {
    @NotNull
    private final JSON.Number<?> n;

    public IntegerLiteral(@NotNull JSON.Number<?> n) {
        Intrinsics.checkNotNullParameter(n, (String)"n");
        this.n = n;
    }

    @NotNull
    public final JSON.Number<?> getN() {
        return this.n;
    }

    @Override
    @NotNull
    public IntegerLiteral copy() {
        IntegerLiteral ret2 = new IntegerLiteral(this.n);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        this.setTypeHint(typeHint);
        if (typeHint instanceof LongType) {
            return LongType.INSTANCE;
        }
        if (typeHint instanceof FloatType) {
            return FloatType.INSTANCE;
        }
        if (typeHint instanceof DoubleType) {
            return DoubleType.INSTANCE;
        }
        return this.n instanceof JSON.Long ? (TypeInstance)LongType.INSTANCE : (TypeInstance)IntType.INSTANCE;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        if (this.getTypeHint() instanceof LongType) {
            return LongType.INSTANCE;
        }
        if (this.getTypeHint() instanceof FloatType) {
            return FloatType.INSTANCE;
        }
        if (this.getTypeHint() instanceof DoubleType) {
            return DoubleType.INSTANCE;
        }
        return this.n instanceof JSON.Long ? (TypeInstance)LongType.INSTANCE : (TypeInstance)IntType.INSTANCE;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        TypeInstance t = this.typeInstance();
        return t instanceof LongType ? (Instruction)new LiteralLong(((Number)this.n.toJavaObject()).longValue(), this.getCtx().stackInfo(this.getLineCol())) : (t instanceof FloatType ? (Instruction)new LiteralFloat(((Number)this.n.toJavaObject()).floatValue(), this.getCtx().stackInfo(this.getLineCol())) : (t instanceof DoubleType ? (Instruction)new LiteralDouble(((Number)this.n.toJavaObject()).doubleValue(), this.getCtx().stackInfo(this.getLineCol())) : (Instruction)new LiteralInt(((Number)this.n.toJavaObject()).intValue(), this.getCtx().stackInfo(this.getLineCol()))));
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return Intrinsics.stringPlus((String)"", (Object)this.n.stringify());
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final JSON.Number<?> component1() {
        return this.n;
    }

    @NotNull
    public final IntegerLiteral copy(@NotNull JSON.Number<?> n) {
        Intrinsics.checkNotNullParameter(n, (String)"n");
        return new IntegerLiteral(n);
    }

    public static /* synthetic */ IntegerLiteral copy$default(IntegerLiteral integerLiteral, JSON.Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = integerLiteral.n;
        }
        return integerLiteral.copy(number);
    }

    public int hashCode() {
        return this.n.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntegerLiteral)) {
            return false;
        }
        IntegerLiteral integerLiteral = (IntegerLiteral)other;
        return Intrinsics.areEqual(this.n, integerLiteral.n);
    }
}

