/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Expr;
import vjson.pl.ast.Type;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.NewArrayBool;
import vjson.pl.inst.NewArrayDouble;
import vjson.pl.inst.NewArrayFloat;
import vjson.pl.inst.NewArrayInt;
import vjson.pl.inst.NewArrayLong;
import vjson.pl.inst.NewArrayRef;
import vjson.pl.type.ArrayTypeInstance;
import vjson.pl.type.BoolType;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0001H\u00c6\u0003J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u0011H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lvjson/pl/ast/NewArray;", "Lvjson/pl/ast/Expr;", "type", "Lvjson/pl/ast/Type;", "len", "(Lvjson/pl/ast/Type;Lvjson/pl/ast/Expr;)V", "arrayTypeInstance", "Lvjson/pl/type/ArrayTypeInstance;", "getArrayTypeInstance", "()Lvjson/pl/type/ArrayTypeInstance;", "setArrayTypeInstance", "(Lvjson/pl/type/ArrayTypeInstance;)V", "getLen", "()Lvjson/pl/ast/Expr;", "getType", "()Lvjson/pl/ast/Type;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "typeInstance", "vjson"})
public final class NewArray
extends Expr {
    @NotNull
    private final Type type;
    @NotNull
    private final Expr len;
    @Nullable
    private ArrayTypeInstance arrayTypeInstance;

    public NewArray(@NotNull Type type, @NotNull Expr len) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)len, (String)"len");
        this.type = type;
        this.len = len;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final Expr getLen() {
        return this.len;
    }

    @Nullable
    public final ArrayTypeInstance getArrayTypeInstance() {
        return this.arrayTypeInstance;
    }

    public final void setArrayTypeInstance(@Nullable ArrayTypeInstance arrayTypeInstance) {
        this.arrayTypeInstance = arrayTypeInstance;
    }

    @Override
    @NotNull
    public NewArray copy() {
        NewArray ret2 = new NewArray(this.type.copy(), this.len.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        TypeInstance arrayType;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        if (this.arrayTypeInstance == null) {
            arrayType = this.type.check(ctx, typeHint);
            if (!(arrayType instanceof ArrayTypeInstance)) {
                throw new ParserException(this + ": " + arrayType + " is not array type", this.getLineCol());
            }
            this.arrayTypeInstance = arrayType;
        }
        ArrayTypeInstance arrayTypeInstance = this.arrayTypeInstance;
        Intrinsics.checkNotNull((Object)arrayTypeInstance);
        arrayType = arrayTypeInstance;
        TypeInstance lenType = this.len.check(ctx, IntType.INSTANCE);
        if (!(lenType instanceof IntType)) {
            throw new ParserException(this + ": typeof " + this.len + " (" + lenType + ") is not int", this.getLineCol());
        }
        return arrayType;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        ArrayTypeInstance arrayTypeInstance = this.arrayTypeInstance;
        Intrinsics.checkNotNull((Object)arrayTypeInstance);
        return arrayTypeInstance;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        ArrayTypeInstance arrayTypeInstance = this.arrayTypeInstance;
        Intrinsics.checkNotNull((Object)arrayTypeInstance);
        TypeInstance typeInstance = arrayTypeInstance.elementType(this.getCtx());
        return typeInstance instanceof IntType ? (Instruction)new NewArrayInt(this.len.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof LongType ? (Instruction)new NewArrayLong(this.len.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof FloatType ? (Instruction)new NewArrayFloat(this.len.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof DoubleType ? (Instruction)new NewArrayDouble(this.len.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (typeInstance instanceof BoolType ? (Instruction)new NewArrayBool(this.len.generateInstruction(), this.getCtx().stackInfo(this.getLineCol())) : (Instruction)new NewArrayRef(this.len.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()))))));
    }

    @Override
    @NotNull
    public String toString(int indent) {
        String typeStr = this.type.toString();
        int bracketLeft = StringsKt.indexOf$default((CharSequence)typeStr, (String)"[", (int)0, (boolean)false, (int)6, null);
        int bracketRight = StringsKt.indexOf$default((CharSequence)typeStr, (String)"]", (int)(bracketLeft + 1), (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder().append("new ");
        String string = typeStr;
        int n = 0;
        int n2 = bracketLeft + 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(this.len);
        string = typeStr;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(bracketRight);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        return stringBuilder2.append(string5).toString();
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final Type component1() {
        return this.type;
    }

    @NotNull
    public final Expr component2() {
        return this.len;
    }

    @NotNull
    public final NewArray copy(@NotNull Type type, @NotNull Expr len) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)len, (String)"len");
        return new NewArray(type, len);
    }

    public static /* synthetic */ NewArray copy$default(NewArray newArray, Type type, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            type = newArray.type;
        }
        if ((n & 2) != 0) {
            expr = newArray.len;
        }
        return newArray.copy(type, expr);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.len.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NewArray)) {
            return false;
        }
        NewArray newArray = (NewArray)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)newArray.type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.len, (Object)newArray.len);
    }
}

