/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Access;
import vjson.pl.ast.AccessIndex;
import vjson.pl.ast.Assignment;
import vjson.pl.ast.Expr;
import vjson.pl.ast.IntegerLiteral;
import vjson.pl.ast.NewArray;
import vjson.pl.ast.NewInstance;
import vjson.pl.ast.Type;
import vjson.pl.ast.VariableDefinition;
import vjson.pl.inst.CompositeInstruction;
import vjson.pl.inst.Instruction;
import vjson.pl.type.ArrayTypeInstance;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.ParamInstance;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.simple.SimpleInteger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J,\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00112\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\b\u0010 \u001a\u00020\u0001H\u0016J)\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\b\u0010$\u001a\u00020%H\u0016JF\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00112\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020%0'j\b\u0012\u0004\u0012\u00020%`(2\u0006\u0010)\u001a\u00020\"2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J>\u0010$\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00112\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020%0'j\b\u0012\u0004\u0012\u00020%`(2\u0006\u0010+\u001a\u00020,2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002J\t\u0010-\u001a\u00020.H\u00d6\u0001J\b\u0010/\u001a\u00020\u0006H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020.H\u0016J\b\u00101\u001a\u00020\u0011H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"Lvjson/pl/ast/NewInstanceWithJson;", "Lvjson/pl/ast/Expr;", "type", "Lvjson/pl/ast/Type;", "json", "", "", "", "(Lvjson/pl/ast/Type;Ljava/util/Map;)V", "generatedInstruction", "Lvjson/pl/inst/CompositeInstruction;", "getJson", "()Ljava/util/Map;", "getType", "()Lvjson/pl/ast/Type;", "_generateInstruction", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "checkArray", "", "path", "arr", "", "checkInstance", "inst", "checkObject", "obj", "component1", "component2", "copy", "equals", "", "other", "generateInstruction", "Lvjson/pl/inst/Instruction;", "instList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "needTmpVar", "elementType", "arrType", "Lvjson/pl/type/ArrayTypeInstance;", "hashCode", "", "toString", "indent", "typeInstance", "Companion", "vjson"})
public final class NewInstanceWithJson
extends Expr {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private final Map<String, Object> json;
    private CompositeInstruction generatedInstruction;
    @NotNull
    public static final String syntheticVariablePrefix = "$$tmp$$";

    public NewInstanceWithJson(@NotNull Type type, @NotNull Map<String, ? extends Object> json) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(json, (String)"json");
        this.type = type;
        this.json = json;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final Map<String, Object> getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public Expr copy() {
        NewInstanceWithJson ret2 = new NewInstanceWithJson(this.type, this.json);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        this.setTypeHint(typeHint);
        TypeInstance type = this.type.check(ctx, typeHint);
        this.checkObject("$", type, this.json);
        this.generatedInstruction = this._generateInstruction();
        return type;
    }

    private final void checkInstance(String path, TypeInstance type, Object inst) {
        if (inst instanceof Map) {
            this.checkObject(path, type, (Map)inst);
            return;
        }
        if (inst instanceof List) {
            this.checkArray(path, type, (List)inst);
            return;
        }
        TypeInstance t = ((Expr)inst).check(this.getCtx(), type);
        if (!Intrinsics.areEqual((Object)type, (Object)t)) {
            throw new ParserException(inst + " is not " + type + " at " + path, this.getLineCol());
        }
    }

    private final void checkObject(String path, TypeInstance type, Map<String, ? extends Object> obj) {
        boolean bl;
        Object object;
        FunctionDescriptor functionDescriptor = type.constructor(this.getCtx());
        if (functionDescriptor == null) {
            throw new ParserException("no constructor found for type " + type + " at " + path, this.getLineCol());
        }
        FunctionDescriptor cons = functionDescriptor;
        HashMap paramsMap = new HashMap();
        for (ParamInstance p : cons.getParams()) {
            String string;
            int n;
            if (StringsKt.startsWith$default((String)p.getName(), (String)"_", (boolean)false, (int)2, null)) {
                object = p.getName();
                n = 1;
                bl = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object2).substring(n);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = p.getName();
            }
            String pname = string;
            object = paramsMap;
            n = 0;
            object.put(pname, p);
        }
        Object object3 = paramsMap;
        boolean pname = false;
        Iterator<Object> iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            object = object3 = (Map.Entry)iterator.next();
            boolean bl2 = false;
            String p = (String)object.getKey();
            Object object4 = object3;
            bl = false;
            ParamInstance pt = (ParamInstance)object4.getValue();
            Object inst = obj.get(p);
            if (inst == null) {
                if (pt.getDefaultValue() != null) {
                    inst = pt.getDefaultValue();
                } else {
                    throw new ParserException("missing argument for parameter " + p + " at " + path, this.getLineCol());
                }
            }
            this.checkInstance(path + '.' + p, pt.getType(), inst);
        }
    }

    private final void checkArray(String path, TypeInstance type, List<? extends Object> arr) {
        TypeInstance typeInstance = type.elementType(this.getCtx());
        if (typeInstance == null) {
            throw new ParserException("type " + type + " is not an array at " + path, this.getLineCol());
        }
        TypeInstance elemType = typeInstance;
        int n = 0;
        int n2 = arr.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                this.checkInstance(path + '[' + i + ']', elemType, arr.get(i));
            } while (n <= n2);
        }
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        return this.type.check(this.getCtx(), this.getTypeHint());
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        CompositeInstruction compositeInstruction;
        CompositeInstruction compositeInstruction2 = this.generatedInstruction;
        if (compositeInstruction2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedInstruction");
            compositeInstruction = null;
        } else {
            compositeInstruction = compositeInstruction2;
        }
        return compositeInstruction;
    }

    private final CompositeInstruction _generateInstruction() {
        ArrayList<Instruction> instList = new ArrayList<Instruction>();
        this.generateInstruction(this.type.typeInstance(), instList, false, this.json);
        return new CompositeInstruction((List<? extends Instruction>)instList);
    }

    private final String generateInstruction(TypeInstance type, ArrayList<Instruction> instList, boolean needTmpVar, Map<String, ? extends Object> json) {
        ArrayList<Object> args = new ArrayList<Object>();
        FunctionDescriptor functionDescriptor = type.constructor(this.getCtx());
        Intrinsics.checkNotNull((Object)functionDescriptor);
        for (ParamInstance p : functionDescriptor.getParams()) {
            String string;
            String string2;
            if (StringsKt.startsWith$default((String)p.getName(), (String)"_", (boolean)false, (int)2, null)) {
                String string3 = p.getName();
                int n = 1;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = p.getName();
            }
            String pname = string2;
            Object v = json.get(pname);
            if (v == null) {
                Expr expr = p.getDefaultValue();
                Intrinsics.checkNotNull((Object)expr);
                args.add(expr);
                continue;
            }
            if (v instanceof Expr) {
                args.add(v);
                continue;
            }
            if (v instanceof Map) {
                String string6 = this.generateInstruction(p.getType(), instList, true, (Map)v);
                string = string6;
                Intrinsics.checkNotNull((Object)string6);
            } else {
                TypeInstance typeInstance = p.getType().elementType(this.getCtx());
                Intrinsics.checkNotNull((Object)typeInstance);
                string = this.generateInstruction(typeInstance, instList, (ArrayTypeInstance)p.getType(), (List)v);
            }
            String varname = string;
            Access placeHolder = new Access(varname, null, 2, null);
            placeHolder.check(this.getCtx(), null);
            args.add(placeHolder);
        }
        NewInstance expr = new NewInstance(new Type(""), (List<? extends Expr>)args);
        expr.set_typeInstance(type);
        if (!needTmpVar) {
            expr.check(this.getCtx(), type);
            instList.add(expr.generateInstruction());
            return null;
        }
        String tmpvarname = this.getCtx().tmpVar(syntheticVariablePrefix);
        VariableDefinition vardef = new VariableDefinition(tmpvarname, expr, null, 4, null);
        vardef.checkAST(this.getCtx());
        instList.add(vardef.generateInstruction());
        return tmpvarname;
    }

    private final String generateInstruction(TypeInstance elementType, ArrayList<Instruction> instList, ArrayTypeInstance arrType, List<? extends Object> json) {
        NewArray newarray = new NewArray(new Type(""), new IntegerLiteral(new SimpleInteger(json.size(), null, 2, null)));
        newarray.setArrayTypeInstance(arrType);
        String tmpvarname = this.getCtx().tmpVar(syntheticVariablePrefix);
        VariableDefinition vardef = new VariableDefinition(tmpvarname, newarray, null, 4, null);
        vardef.checkAST(this.getCtx());
        instList.add(vardef.generateInstruction());
        int n = 0;
        int n2 = json.size() + -1;
        if (n <= n2) {
            do {
                Expr expr;
                int i;
                Object e;
                if ((e = json.get(i = n++)) instanceof Expr) {
                    expr = (Expr)e;
                } else {
                    String string;
                    if (e instanceof Map) {
                        String string2 = this.generateInstruction(elementType, instList, true, (Map)e);
                        string = string2;
                        Intrinsics.checkNotNull((Object)string2);
                    } else {
                        TypeInstance typeInstance = elementType.elementType(this.getCtx());
                        Intrinsics.checkNotNull((Object)typeInstance);
                        string = this.generateInstruction(typeInstance, instList, (ArrayTypeInstance)arrType.elementType(this.getCtx()), (List)e);
                    }
                    String varname = string;
                    Access placeHolder = new Access(varname, null, 2, null);
                    expr = placeHolder;
                }
                Expr expr2 = expr;
                Assignment assignment = new Assignment(new AccessIndex(new Access(tmpvarname, null, 2, null), new IntegerLiteral(new SimpleInteger(i, null, 2, null))), expr2);
                assignment.check(this.getCtx(), elementType);
                instList.add(assignment.generateInstruction());
            } while (n <= n2);
        }
        return tmpvarname;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "new " + this.type + ' ' + this.json;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final Type component1() {
        return this.type;
    }

    @NotNull
    public final Map<String, Object> component2() {
        return this.json;
    }

    @NotNull
    public final NewInstanceWithJson copy(@NotNull Type type, @NotNull Map<String, ? extends Object> json) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(json, (String)"json");
        return new NewInstanceWithJson(type, json);
    }

    public static /* synthetic */ NewInstanceWithJson copy$default(NewInstanceWithJson newInstanceWithJson, Type type, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            type = newInstanceWithJson.type;
        }
        if ((n & 2) != 0) {
            map = newInstanceWithJson.json;
        }
        return newInstanceWithJson.copy(type, map);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + ((Object)this.json).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NewInstanceWithJson)) {
            return false;
        }
        NewInstanceWithJson newInstanceWithJson = (NewInstanceWithJson)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)newInstanceWithJson.type)) {
            return false;
        }
        return Intrinsics.areEqual(this.json, newInstanceWithJson.json);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvjson/pl/ast/NewInstanceWithJson$Companion;", "", "()V", "syntheticVariablePrefix", "", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

