/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Access;
import vjson.pl.ast.AssignableExpr;
import vjson.pl.ast.BinOpType;
import vjson.pl.ast.Expr;
import vjson.pl.inst.DivideDouble;
import vjson.pl.inst.DivideFloat;
import vjson.pl.inst.DivideInt;
import vjson.pl.inst.DivideLong;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.MinusDouble;
import vjson.pl.inst.MinusFloat;
import vjson.pl.inst.MinusInt;
import vjson.pl.inst.MinusLong;
import vjson.pl.inst.ModInt;
import vjson.pl.inst.ModLong;
import vjson.pl.inst.MultiplyDouble;
import vjson.pl.inst.MultiplyFloat;
import vjson.pl.inst.MultiplyInt;
import vjson.pl.inst.MultiplyLong;
import vjson.pl.inst.PlusDouble;
import vjson.pl.inst.PlusFloat;
import vjson.pl.inst.PlusInt;
import vjson.pl.inst.PlusLong;
import vjson.pl.inst.StringConcat;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.NumericTypeInstance;
import vjson.pl.type.StringType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0001H\u00c6\u0003J\b\u0010\u0016\u001a\u00020\u0000H\u0016J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lvjson/pl/ast/OpAssignment;", "Lvjson/pl/ast/Expr;", "op", "Lvjson/pl/ast/BinOpType;", "variable", "Lvjson/pl/ast/AssignableExpr;", "value", "(Lvjson/pl/ast/BinOpType;Lvjson/pl/ast/AssignableExpr;Lvjson/pl/ast/Expr;)V", "getOp", "()Lvjson/pl/ast/BinOpType;", "getValue", "()Lvjson/pl/ast/Expr;", "getVariable", "()Lvjson/pl/ast/AssignableExpr;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "component3", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "typeInstance", "vjson"})
public final class OpAssignment
extends Expr {
    @NotNull
    private final BinOpType op;
    @NotNull
    private final AssignableExpr variable;
    @NotNull
    private final Expr value;

    public OpAssignment(@NotNull BinOpType op, @NotNull AssignableExpr variable, @NotNull Expr value) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.op = op;
        this.variable = variable;
        this.value = value;
    }

    @NotNull
    public final BinOpType getOp() {
        return this.op;
    }

    @NotNull
    public final AssignableExpr getVariable() {
        return this.variable;
    }

    @NotNull
    public final Expr getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public OpAssignment copy() {
        OpAssignment ret2 = new OpAssignment(this.op, this.variable.copy(), this.value.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        if (this.op != BinOpType.PLUS && this.op != BinOpType.MINUS && this.op != BinOpType.MULTIPLY && this.op != BinOpType.DIVIDE && this.op != BinOpType.MOD) {
            throw new ParserException(Intrinsics.stringPlus((String)"invalid operator for assigning: ", (Object)((Object)this.op)), this.getLineCol());
        }
        TypeInstance variableType = this.variable.check(ctx, null);
        TypeInstance valueType = this.value.check(ctx, variableType);
        if (this.op == BinOpType.PLUS && variableType instanceof StringType) {
            if (!(valueType instanceof StringType)) {
                TypeUtils.INSTANCE.checkImplicitStringCast(ctx, valueType, this.value, this.getLineCol());
            }
        } else {
            if (!TypeUtils.INSTANCE.assignableFrom(variableType, valueType)) {
                throw new ParserException(this + ": cannot calculate and assign " + valueType + " to " + variableType + ", type mismatch", this.getLineCol());
            }
            if (!(valueType instanceof NumericTypeInstance)) {
                throw new ParserException(this + ": cannot execute " + (Object)((Object)this.op) + " on type " + valueType + ", not numeric", this.getLineCol());
            }
        }
        if (this.op == BinOpType.MOD && !(valueType instanceof IntType) && !(valueType instanceof LongType)) {
            throw new ParserException(this + ": cannot execute " + (Object)((Object)this.op) + " on type " + valueType + ", must be int or long", this.getLineCol());
        }
        if (!this.variable.isModifiable()) {
            throw new ParserException(this + ": cannot assign values to " + this.variable + ", the variable/field is unmodifiable", this.getLineCol());
        }
        return variableType;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        return this.value.typeInstance();
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Instruction instruction;
        BinOpType binOpType = this.op;
        int n = WhenMappings.$EnumSwitchMapping$0[binOpType.ordinal()];
        switch (n) {
            case 1: {
                TypeInstance typeInstance = this.variable.typeInstance();
                if (typeInstance instanceof IntType) {
                    instruction = new PlusInt(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new PlusLong(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new PlusFloat(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new PlusDouble(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof StringType) {
                    StringConcat stringConcat;
                    if (this.value.typeInstance() instanceof StringType) {
                        stringConcat = new StringConcat(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    } else {
                        Instruction toStringFuncInst = Access.Companion.buildGetFieldInstruction(this.getCtx(), this.value.generateInstruction(), this.value.typeInstance(), "toString", this.getLineCol());
                        Instruction callToStringFuncInst = TypeUtils.INSTANCE.buildToStringInstruction(this.getCtx(), this.value.typeInstance(), toStringFuncInst, this.getLineCol());
                        stringConcat = new StringConcat(this.variable.generateInstruction(), callToStringFuncInst, this.getCtx().stackInfo(this.getLineCol()));
                    }
                    instruction = stringConcat;
                    break;
                }
                throw new IllegalStateException();
            }
            case 2: {
                TypeInstance typeInstance = this.variable.typeInstance();
                if (typeInstance instanceof IntType) {
                    instruction = new MinusInt(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new MinusLong(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new MinusFloat(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new MinusDouble(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException();
            }
            case 3: {
                TypeInstance typeInstance = this.variable.typeInstance();
                if (typeInstance instanceof IntType) {
                    instruction = new MultiplyInt(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new MultiplyLong(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new MultiplyFloat(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new MultiplyDouble(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException();
            }
            case 4: {
                TypeInstance typeInstance = this.variable.typeInstance();
                if (typeInstance instanceof IntType) {
                    instruction = new DivideInt(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new DivideLong(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof FloatType) {
                    instruction = new DivideFloat(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof DoubleType) {
                    instruction = new DivideDouble(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException();
            }
            case 5: {
                TypeInstance typeInstance = this.variable.typeInstance();
                if (typeInstance instanceof IntType) {
                    instruction = new ModInt(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                if (typeInstance instanceof LongType) {
                    instruction = new ModLong(this.variable.generateInstruction(), this.value.generateInstruction(), this.getCtx().stackInfo(this.getLineCol()));
                    break;
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Instruction calculateInst = instruction;
        return this.variable.generateSetInstruction(calculateInst);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "" + '(' + this.variable + ' ' + (Object)((Object)this.op) + "= " + this.value + ')';
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final BinOpType component1() {
        return this.op;
    }

    @NotNull
    public final AssignableExpr component2() {
        return this.variable;
    }

    @NotNull
    public final Expr component3() {
        return this.value;
    }

    @NotNull
    public final OpAssignment copy(@NotNull BinOpType op, @NotNull AssignableExpr variable, @NotNull Expr value) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new OpAssignment(op, variable, value);
    }

    public static /* synthetic */ OpAssignment copy$default(OpAssignment opAssignment, BinOpType binOpType, AssignableExpr assignableExpr, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            binOpType = opAssignment.op;
        }
        if ((n & 2) != 0) {
            assignableExpr = opAssignment.variable;
        }
        if ((n & 4) != 0) {
            expr = opAssignment.value;
        }
        return opAssignment.copy(binOpType, assignableExpr, expr);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = result * 31 + this.variable.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OpAssignment)) {
            return false;
        }
        OpAssignment opAssignment = (OpAssignment)other;
        if (this.op != opAssignment.op) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variable, (Object)opAssignment.variable)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)opAssignment.value);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinOpType.values().length];
            nArray[BinOpType.PLUS.ordinal()] = 1;
            nArray[BinOpType.MINUS.ordinal()] = 2;
            nArray[BinOpType.MULTIPLY.ordinal()] = 3;
            nArray[BinOpType.DIVIDE.ordinal()] = 4;
            nArray[BinOpType.MOD.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

