/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ast.BoolLiteral;
import vjson.pl.ast.Expr;
import vjson.pl.ast.FloatLiteral;
import vjson.pl.ast.IntegerLiteral;
import vjson.pl.ast.NullLiteral;
import vjson.pl.ast.StringLiteral;
import vjson.pl.ast.Type;
import vjson.pl.ast.TypedAST;
import vjson.pl.inst.Instruction;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\b\u0010#\u001a\u00020\u0000H\u0016J)\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\b\u0010(\u001a\u00020)H\u0016J\t\u0010*\u001a\u00020\u0012H\u00d6\u0001J\b\u0010+\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0012H\u0016J\b\u0010-\u001a\u00020\u001cH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lvjson/pl/ast/Param;", "Lvjson/pl/ast/TypedAST;", "name", "", "type", "Lvjson/pl/ast/Type;", "defaultValue", "Lvjson/pl/ast/Expr;", "(Ljava/lang/String;Lvjson/pl/ast/Type;Lvjson/pl/ast/Expr;)V", "getDefaultValue", "()Lvjson/pl/ast/Expr;", "lineCol", "Lvjson/cs/LineCol;", "getLineCol", "()Lvjson/cs/LineCol;", "setLineCol", "(Lvjson/cs/LineCol;)V", "memIndex", "", "getMemIndex$vjson", "()I", "setMemIndex$vjson", "(I)V", "getName", "()Ljava/lang/String;", "getType", "()Lvjson/pl/ast/Type;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "component2", "component3", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "toString", "indent", "typeInstance", "vjson"})
public final class Param
implements TypedAST {
    @NotNull
    private final String name;
    @NotNull
    private final Type type;
    @Nullable
    private final Expr defaultValue;
    @NotNull
    private LineCol lineCol;
    private int memIndex;

    @JvmOverloads
    public Param(@NotNull String name, @NotNull Type type, @Nullable Expr defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.lineCol = LineCol.Companion.getEMPTY();
        this.memIndex = -1;
    }

    public /* synthetic */ Param(String string, Type type, Expr expr, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            expr = null;
        }
        this(string, type, expr);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @Nullable
    public final Expr getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public LineCol getLineCol() {
        return this.lineCol;
    }

    @Override
    public void setLineCol(@NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"<set-?>");
        this.lineCol = lineCol;
    }

    @Override
    @NotNull
    public Param copy() {
        Param ret2 = new Param(this.name, this.type, this.defaultValue);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!ctx.hasTypeConsiderArray(this.type)) {
            throw new ParserException("type of parameter " + this.name + " (" + this.type + ") is not defined", this.getLineCol());
        }
        TypeInstance typeInstance = this.type.check(ctx, typeHint);
        if (this.defaultValue != null) {
            if (!(this.defaultValue instanceof IntegerLiteral || this.defaultValue instanceof FloatLiteral || this.defaultValue instanceof BoolLiteral || this.defaultValue instanceof StringLiteral || this.defaultValue instanceof NullLiteral)) {
                throw new ParserException("default value can only be literals or null", this.defaultValue.getLineCol());
            }
            TypeInstance defaultValueType = this.defaultValue.check(ctx, typeInstance);
            if (!Intrinsics.areEqual((Object)typeInstance, (Object)defaultValueType)) {
                throw new ParserException("default value " + this.defaultValue + " (" + defaultValueType + ") cannot be assigned to " + typeInstance, this.defaultValue.getLineCol());
            }
        }
        return typeInstance;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        return this.type.typeInstance();
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        throw new UnsupportedOperationException();
    }

    public final int getMemIndex$vjson() {
        return this.memIndex;
    }

    public final void setMemIndex$vjson(int n) {
        this.memIndex = n;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.name + ": " + this.type;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        TypedAST.DefaultImpls.checkAST(this, ctx);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Type component2() {
        return this.type;
    }

    @Nullable
    public final Expr component3() {
        return this.defaultValue;
    }

    @NotNull
    public final Param copy(@NotNull String name, @NotNull Type type, @Nullable Expr defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new Param(name, type, defaultValue);
    }

    public static /* synthetic */ Param copy$default(Param param, String string, Type type, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            string = param.name;
        }
        if ((n & 2) != 0) {
            type = param.type;
        }
        if ((n & 4) != 0) {
            expr = param.defaultValue;
        }
        return param.copy(string, type, expr);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Param)) {
            return false;
        }
        Param param = (Param)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)param.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)param.type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultValue, (Object)param.defaultValue);
    }

    @JvmOverloads
    public Param(@NotNull String name, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(name, type, null, 4, null);
    }
}

