/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.AST;
import vjson.pl.ast.Expr;
import vjson.pl.ast.FunctionDefinition;
import vjson.pl.ast.ReturnStatement;
import vjson.pl.ast.Statement;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.ReturnInst;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.TypeUtils;
import vjson.pl.type.VoidType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0015\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lvjson/pl/ast/ReturnStatement;", "Lvjson/pl/ast/Statement;", "expr", "Lvjson/pl/ast/Expr;", "(Lvjson/pl/ast/Expr;)V", "getExpr", "()Lvjson/pl/ast/Expr;", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "vjson"})
public final class ReturnStatement
extends Statement {
    @Nullable
    private final Expr expr;

    public ReturnStatement(@Nullable Expr expr) {
        this.expr = expr;
    }

    public /* synthetic */ ReturnStatement(Expr expr, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            expr = null;
        }
        this(expr);
    }

    @Nullable
    public final Expr getExpr() {
        return this.expr;
    }

    @Override
    @NotNull
    public Statement copy() {
        Expr expr = this.expr;
        ReturnStatement ret2 = new ReturnStatement(expr == null ? null : expr.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        TypeInstance exprType;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        AST astCtx2 = ctx.getContextAST((Function1<? super AST, Boolean>)((Function1)checkAST.astCtx.1.INSTANCE));
        if (astCtx2 == null || !(astCtx2 instanceof FunctionDefinition)) {
            throw new ParserException(Intrinsics.stringPlus((String)"`return` is not inside a function, current context is ", (Object)astCtx2), this.getLineCol());
        }
        AST func = astCtx2;
        TypeInstance returnType = ((FunctionDefinition)func).getReturnType().typeInstance();
        Expr expr = this.expr;
        TypeInstance typeInstance = exprType = expr == null ? null : expr.check(ctx, returnType);
        if (exprType == null) {
            if (!(returnType instanceof VoidType)) {
                throw new ParserException("function " + ((FunctionDefinition)func).getName() + " returns " + returnType + ", but the `return` statement does not have a value", this.getLineCol());
            }
        } else if (!TypeUtils.INSTANCE.assignableFrom(returnType, exprType)) {
            throw new ParserException("function " + ((FunctionDefinition)func).getName() + " returns " + returnType + ", but the `return` statement returns " + exprType, this.getLineCol());
        }
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Expr expr = this.expr;
        return new ReturnInst(expr == null ? null : expr.generateInstruction());
    }

    @Override
    public boolean functionTerminationCheck() {
        return true;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.expr == null ? "return" : Intrinsics.stringPlus((String)"return: ", (Object)this.expr);
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @Nullable
    public final Expr component1() {
        return this.expr;
    }

    @NotNull
    public final ReturnStatement copy(@Nullable Expr expr) {
        return new ReturnStatement(expr);
    }

    public static /* synthetic */ ReturnStatement copy$default(ReturnStatement returnStatement, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            expr = returnStatement.expr;
        }
        return returnStatement.copy(expr);
    }

    public int hashCode() {
        return this.expr == null ? 0 : this.expr.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReturnStatement)) {
            return false;
        }
        ReturnStatement returnStatement = (ReturnStatement)other;
        return Intrinsics.areEqual((Object)this.expr, (Object)returnStatement.expr);
    }

    public ReturnStatement() {
        this(null, 1, null);
    }
}

