/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.pl.ast.Expr;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.LiteralRef;
import vjson.pl.type.StringType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.simple.SimpleString;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lvjson/pl/ast/StringLiteral;", "Lvjson/pl/ast/Expr;", "str", "", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "check", "Lvjson/pl/type/TypeInstance;", "ctx", "Lvjson/pl/type/TypeContext;", "typeHint", "component1", "copy", "equals", "", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "indent", "typeInstance", "vjson"})
public final class StringLiteral
extends Expr {
    @NotNull
    private final String str;

    public StringLiteral(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.str = str;
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    @Override
    @NotNull
    public StringLiteral copy() {
        StringLiteral ret2 = new StringLiteral(this.str);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.setCtx(ctx);
        return StringType.INSTANCE;
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        return StringType.INSTANCE;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        return new LiteralRef(this.str, this.getCtx().stackInfo(this.getLineCol()));
    }

    @Override
    @NotNull
    public String toString(int indent) {
        String s = new SimpleString(this.str, null, 2, null).stringify();
        return '(' + s + ')';
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final String component1() {
        return this.str;
    }

    @NotNull
    public final StringLiteral copy(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return new StringLiteral(str);
    }

    public static /* synthetic */ StringLiteral copy$default(StringLiteral stringLiteral, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = stringLiteral.str;
        }
        return stringLiteral.copy(string);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringLiteral)) {
            return false;
        }
        StringLiteral stringLiteral = (StringLiteral)other;
        return Intrinsics.areEqual((Object)this.str, (Object)stringLiteral.str);
    }
}

