/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.ClassDefinition;
import vjson.pl.ast.ParamType;
import vjson.pl.ast.Statement;
import vjson.pl.ast.Type;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.NoOp;
import vjson.pl.type.TemplateClassTypeInstance;
import vjson.pl.type.TypeContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J#\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u000bJ\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lvjson/pl/ast/TemplateClassDefinition;", "Lvjson/pl/ast/Statement;", "paramTypes", "", "Lvjson/pl/ast/ParamType;", "classDef", "Lvjson/pl/ast/ClassDefinition;", "(Ljava/util/List;Lvjson/pl/ast/ClassDefinition;)V", "getClassDef", "()Lvjson/pl/ast/ClassDefinition;", "ctx", "Lvjson/pl/type/TypeContext;", "getParamTypes", "()Ljava/util/List;", "checkAST", "", "component1", "component2", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "getCtx", "hashCode", "", "toString", "", "indent", "vjson"})
public final class TemplateClassDefinition
extends Statement {
    @NotNull
    private final List<ParamType> paramTypes;
    @NotNull
    private final ClassDefinition classDef;
    @Nullable
    private TypeContext ctx;

    public TemplateClassDefinition(@NotNull List<ParamType> paramTypes, @NotNull ClassDefinition classDef) {
        Intrinsics.checkNotNullParameter(paramTypes, (String)"paramTypes");
        Intrinsics.checkNotNullParameter((Object)classDef, (String)"classDef");
        this.paramTypes = paramTypes;
        this.classDef = classDef;
    }

    @NotNull
    public final List<ParamType> getParamTypes() {
        return this.paramTypes;
    }

    @NotNull
    public final ClassDefinition getClassDef() {
        return this.classDef;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TemplateClassDefinition copy() {
        Collection<ParamType> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.paramTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParamType paramType = (ParamType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ParamType paramType2 = it.copy();
            collection.add(paramType2);
        }
        collection = (List)destination$iv$iv;
        ClassDefinition classDefinition = this.classDef.copy();
        List list = collection;
        TemplateClassDefinition ret2 = new TemplateClassDefinition(list, classDefinition);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public boolean functionTerminationCheck() {
        return false;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.hasTypeInThisContext(new Type(this.classDef.getName()))) {
            throw new ParserException("type `" + this.classDef.getName() + "` is already defined", this.getLineCol());
        }
        ctx.addType(new Type(this.classDef.getName()), new TemplateClassTypeInstance(this));
        this.ctx = ctx.copy();
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        return new NoOp();
    }

    @NotNull
    public final TypeContext getCtx() {
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        return typeContext;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder("template:").append(CollectionsKt.joinToString$default((Iterable)this.paramTypes, (CharSequence)", ", (CharSequence)" { ", (CharSequence)" } ", (int)0, null, null, (int)56, null));
        sb.append(this.classDef.toString(indent));
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final List<ParamType> component1() {
        return this.paramTypes;
    }

    @NotNull
    public final ClassDefinition component2() {
        return this.classDef;
    }

    @NotNull
    public final TemplateClassDefinition copy(@NotNull List<ParamType> paramTypes, @NotNull ClassDefinition classDef) {
        Intrinsics.checkNotNullParameter(paramTypes, (String)"paramTypes");
        Intrinsics.checkNotNullParameter((Object)classDef, (String)"classDef");
        return new TemplateClassDefinition(paramTypes, classDef);
    }

    public static /* synthetic */ TemplateClassDefinition copy$default(TemplateClassDefinition templateClassDefinition, List list, ClassDefinition classDefinition, int n, Object object) {
        if ((n & 1) != 0) {
            list = templateClassDefinition.paramTypes;
        }
        if ((n & 2) != 0) {
            classDefinition = templateClassDefinition.classDef;
        }
        return templateClassDefinition.copy(list, classDefinition);
    }

    public int hashCode() {
        int result = ((Object)this.paramTypes).hashCode();
        result = result * 31 + this.classDef.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TemplateClassDefinition)) {
            return false;
        }
        TemplateClassDefinition templateClassDefinition = (TemplateClassDefinition)other;
        if (!Intrinsics.areEqual(this.paramTypes, templateClassDefinition.paramTypes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.classDef, (Object)templateClassDefinition.classDef);
    }
}

