/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.ParamType;
import vjson.pl.ast.Statement;
import vjson.pl.ast.Type;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.NoOp;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\b\u0010\u001b\u001a\u00020\u0000H\u0016J-\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\t\u0010#\u001a\u00020$H\u00d6\u0001J\b\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020$H\u0016R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lvjson/pl/ast/TemplateTypeInstantiation;", "Lvjson/pl/ast/Statement;", "typeName", "", "templateType", "Lvjson/pl/ast/Type;", "typeParams", "", "(Ljava/lang/String;Lvjson/pl/ast/Type;Ljava/util/List;)V", "<set-?>", "Lvjson/pl/type/TypeInstance;", "instantiatedTypeInstance", "getInstantiatedTypeInstance", "()Lvjson/pl/type/TypeInstance;", "getTemplateType", "()Lvjson/pl/ast/Type;", "getTypeName", "()Ljava/lang/String;", "getTypeParams", "()Ljava/util/List;", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "indent", "vjson"})
public final class TemplateTypeInstantiation
extends Statement {
    @NotNull
    private final String typeName;
    @NotNull
    private final Type templateType;
    @NotNull
    private final List<Type> typeParams;
    @Nullable
    private TypeInstance instantiatedTypeInstance;

    public TemplateTypeInstantiation(@NotNull String typeName, @NotNull Type templateType, @NotNull List<Type> typeParams) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)templateType, (String)"templateType");
        Intrinsics.checkNotNullParameter(typeParams, (String)"typeParams");
        this.typeName = typeName;
        this.templateType = templateType;
        this.typeParams = typeParams;
    }

    @NotNull
    public final String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final Type getTemplateType() {
        return this.templateType;
    }

    @NotNull
    public final List<Type> getTypeParams() {
        return this.typeParams;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TemplateTypeInstantiation copy() {
        Collection<Type> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.typeParams;
        Type type = this.templateType.copy();
        String string = this.typeName;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type2 = (Type)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Type type3 = it.copy();
            collection.add(type3);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Type type4 = type;
        String string2 = string;
        TemplateTypeInstantiation ret2 = new TemplateTypeInstantiation(string2, type4, list);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public boolean functionTerminationCheck() {
        return false;
    }

    @Nullable
    public final TypeInstance getInstantiatedTypeInstance() {
        return this.instantiatedTypeInstance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        TypeInstance typeInstance;
        TypeInstance typeInstance2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.hasTypeInThisContext(new Type(this.typeName))) {
            throw new ParserException("type `" + this.typeName + "` is already defined", this.getLineCol());
        }
        TypeInstance templateType = this.templateType.check(ctx, null);
        List<ParamType> list = templateType.typeParameters();
        if (list == null) {
            throw new ParserException("type `" + templateType + "` is not a template class", this.getLineCol());
        }
        List<ParamType> astTypeParams = list;
        Iterable $this$map$iv = this.typeParams;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeInstance typeInstance3 = it.check(ctx, null);
            collection.add(typeInstance3);
        }
        List typeParams = (List)destination$iv$iv;
        if (astTypeParams.size() != typeParams.size()) {
            throw new ParserException("template type `" + templateType + "` has " + astTypeParams.size() + " type parameters, but " + this.typeName + " provides " + typeParams.size(), this.getLineCol());
        }
        try {
            typeInstance2 = templateType.concrete(ctx, this.typeName, typeParams);
        }
        catch (ParserException e) {
            throw new ParserException("constructing concrete type " + this.typeName + " failed: " + e.getMessage(), e, this.getLineCol());
        }
        this.instantiatedTypeInstance = typeInstance = typeInstance2;
        ctx.addType(new Type(this.typeName), typeInstance);
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        return new NoOp();
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return "let " + this.typeName + " = { " + this.templateType + ':' + CollectionsKt.joinToString$default((Iterable)this.typeParams, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) + " }";
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final String component1() {
        return this.typeName;
    }

    @NotNull
    public final Type component2() {
        return this.templateType;
    }

    @NotNull
    public final List<Type> component3() {
        return this.typeParams;
    }

    @NotNull
    public final TemplateTypeInstantiation copy(@NotNull String typeName, @NotNull Type templateType, @NotNull List<Type> typeParams) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)templateType, (String)"templateType");
        Intrinsics.checkNotNullParameter(typeParams, (String)"typeParams");
        return new TemplateTypeInstantiation(typeName, templateType, typeParams);
    }

    public static /* synthetic */ TemplateTypeInstantiation copy$default(TemplateTypeInstantiation templateTypeInstantiation, String string, Type type, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = templateTypeInstantiation.typeName;
        }
        if ((n & 2) != 0) {
            type = templateTypeInstantiation.templateType;
        }
        if ((n & 4) != 0) {
            list = templateTypeInstantiation.typeParams;
        }
        return templateTypeInstantiation.copy(string, type, list);
    }

    public int hashCode() {
        int result = this.typeName.hashCode();
        result = result * 31 + this.templateType.hashCode();
        result = result * 31 + ((Object)this.typeParams).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TemplateTypeInstantiation)) {
            return false;
        }
        TemplateTypeInstantiation templateTypeInstantiation = (TemplateTypeInstantiation)other;
        if (!Intrinsics.areEqual((Object)this.typeName, (Object)templateTypeInstantiation.typeName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.templateType, (Object)templateTypeInstantiation.templateType)) {
            return false;
        }
        return Intrinsics.areEqual(this.typeParams, templateTypeInstantiation.typeParams);
    }
}

