/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Expr;
import vjson.pl.ast.Statement;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.ThrowInst;
import vjson.pl.type.ErrorType;
import vjson.pl.type.NullType;
import vjson.pl.type.StringType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0015\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lvjson/pl/ast/ThrowStatement;", "Lvjson/pl/ast/Statement;", "errMsgExpr", "Lvjson/pl/ast/Expr;", "(Lvjson/pl/ast/Expr;)V", "ctx", "Lvjson/pl/type/TypeContext;", "getErrMsgExpr", "()Lvjson/pl/ast/Expr;", "checkAST", "", "component1", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "vjson"})
public final class ThrowStatement
extends Statement {
    @Nullable
    private final Expr errMsgExpr;
    @Nullable
    private TypeContext ctx;

    public ThrowStatement(@Nullable Expr errMsgExpr) {
        this.errMsgExpr = errMsgExpr;
    }

    public /* synthetic */ ThrowStatement(Expr expr, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            expr = null;
        }
        this(expr);
    }

    @Nullable
    public final Expr getErrMsgExpr() {
        return this.errMsgExpr;
    }

    @Override
    @NotNull
    public Statement copy() {
        Expr expr = this.errMsgExpr;
        ThrowStatement ret2 = new ThrowStatement(expr == null ? null : expr.copy());
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        TypeInstance type;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        if (!(this.errMsgExpr == null || (type = this.errMsgExpr.check(ctx, null)) instanceof StringType || type instanceof NullType || type instanceof ErrorType)) {
            throw new ParserException(this + ": throw statement expects string or null or error object, but got " + this.errMsgExpr + " (" + type + ')', this.getLineCol());
        }
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Expr expr = this.errMsgExpr;
        Instruction instruction = expr == null ? null : expr.generateInstruction();
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        return new ThrowInst(instruction, typeContext.stackInfo(this.getLineCol()));
    }

    @Override
    public boolean functionTerminationCheck() {
        return true;
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.errMsgExpr == null ? "throw" : Intrinsics.stringPlus((String)"throw: ", (Object)this.errMsgExpr);
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @Nullable
    public final Expr component1() {
        return this.errMsgExpr;
    }

    @NotNull
    public final ThrowStatement copy(@Nullable Expr errMsgExpr) {
        return new ThrowStatement(errMsgExpr);
    }

    public static /* synthetic */ ThrowStatement copy$default(ThrowStatement throwStatement, Expr expr, int n, Object object) {
        if ((n & 1) != 0) {
            expr = throwStatement.errMsgExpr;
        }
        return throwStatement.copy(expr);
    }

    public int hashCode() {
        return this.errMsgExpr == null ? 0 : this.errMsgExpr.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThrowStatement)) {
            return false;
        }
        ThrowStatement throwStatement = (ThrowStatement)other;
        return Intrinsics.areEqual((Object)this.errMsgExpr, (Object)throwStatement.errMsgExpr);
    }

    public ThrowStatement() {
        this(null, 1, null);
    }
}

