/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ast.TypedAST;
import vjson.pl.inst.Instruction;
import vjson.pl.type.ArrayTypeInstance;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u0013\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u0014H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lvjson/pl/ast/Type;", "Lvjson/pl/ast/TypedAST;", "name", "", "(Ljava/lang/String;)V", "ctx", "Lvjson/pl/type/TypeContext;", "elementType", "getElementType", "()Lvjson/pl/ast/Type;", "isArray", "", "()Z", "lineCol", "Lvjson/cs/LineCol;", "getLineCol", "()Lvjson/cs/LineCol;", "setLineCol", "(Lvjson/cs/LineCol;)V", "check", "Lvjson/pl/type/TypeInstance;", "typeHint", "component1", "copy", "equals", "other", "", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "indent", "typeInstance", "vjson"})
public final class Type
implements TypedAST {
    @NotNull
    private final String name;
    @NotNull
    private LineCol lineCol;
    @Nullable
    private TypeContext ctx;
    private final boolean isArray;
    @NotNull
    private final Type elementType;

    public Type(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.lineCol = LineCol.Companion.getEMPTY();
        if (StringsKt.contains$default((CharSequence)this.name, (CharSequence)"[", (boolean)false, (int)2, null)) {
            this.isArray = true;
            int leftBracketIndex = StringsKt.lastIndexOf$default((CharSequence)this.name, (String)"[", (int)0, (boolean)false, (int)6, null);
            int rightBracketIndex = StringsKt.lastIndexOf$default((CharSequence)this.name, (String)"]", (int)0, (boolean)false, (int)6, null);
            if (leftBracketIndex != this.name.length() - 2) {
                throw new ParserException(Intrinsics.stringPlus((String)this.name, (Object)" is not a valid array type"), this.getLineCol());
            }
            if (rightBracketIndex != this.name.length() - 1) {
                throw new ParserException(Intrinsics.stringPlus((String)this.name, (Object)" is not a valid array type"), this.getLineCol());
            }
            String string = this.name;
            int n = 0;
            int n2 = this.name.length() - 2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.elementType = new Type(string3);
        } else {
            this.isArray = false;
            this.elementType = this;
        }
    }

    @Override
    @NotNull
    public LineCol getLineCol() {
        return this.lineCol;
    }

    @Override
    public void setLineCol(@NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"<set-?>");
        this.lineCol = lineCol;
    }

    public final boolean isArray() {
        return this.isArray;
    }

    @NotNull
    public final Type getElementType() {
        return this.elementType;
    }

    @Override
    @NotNull
    public Type copy() {
        Type ret2 = new Type(this.name);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    @NotNull
    public TypeInstance check(@NotNull TypeContext ctx, @Nullable TypeInstance typeHint) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        if (ctx.hasType(this)) {
            return ctx.getType(this);
        }
        if (this.isArray) {
            TypeInstance typeInstance = typeHint;
            ArrayTypeInstance arrayType = new ArrayTypeInstance(this.elementType.check(ctx, typeInstance == null ? null : typeInstance.elementType(ctx)));
            ctx.addType(this, arrayType);
            return arrayType;
        }
        throw new ParserException(this + " is not recorded in type context and is not array type", this.getLineCol());
    }

    @Override
    @NotNull
    public TypeInstance typeInstance() {
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        return typeContext.getType(this);
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.name;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        TypedAST.DefaultImpls.checkAST(this, ctx);
    }

    private final String component1() {
        return this.name;
    }

    @NotNull
    public final Type copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Type(name);
    }

    public static /* synthetic */ Type copy$default(Type type, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = type.name;
        }
        return type.copy(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Type)) {
            return false;
        }
        Type type = (Type)other;
        return Intrinsics.areEqual((Object)this.name, (Object)type.name);
    }
}

