/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.Access;
import vjson.pl.ast.Expr;
import vjson.pl.ast.Modifiers;
import vjson.pl.ast.Statement;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.NoOp;
import vjson.pl.inst.SetBool;
import vjson.pl.inst.SetDouble;
import vjson.pl.inst.SetFloat;
import vjson.pl.inst.SetInt;
import vjson.pl.inst.SetLong;
import vjson.pl.inst.SetRef;
import vjson.pl.type.BoolType;
import vjson.pl.type.DoubleType;
import vjson.pl.type.FloatType;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.MemPos;
import vjson.pl.type.NullType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.Variable;
import vjson.pl.type.VoidType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\b\u0010!\u001a\u00020\u0000H\u0016J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\b\u0010&\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020\nJ\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020\u0018H\u00d6\u0001J\b\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0018H\u0016J\u0006\u0010/\u001a\u000200R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lvjson/pl/ast/VariableDefinition;", "Lvjson/pl/ast/Statement;", "name", "", "value", "Lvjson/pl/ast/Expr;", "modifiers", "Lvjson/pl/ast/Modifiers;", "(Ljava/lang/String;Lvjson/pl/ast/Expr;Lvjson/pl/ast/Modifiers;)V", "ctx", "Lvjson/pl/type/TypeContext;", "getModifiers", "()Lvjson/pl/ast/Modifiers;", "setModifiers", "(Lvjson/pl/ast/Modifiers;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getValue", "()Lvjson/pl/ast/Expr;", "setValue", "(Lvjson/pl/ast/Expr;)V", "<set-?>", "", "variableIndex", "getVariableIndex", "()I", "checkAST", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "getCtx", "getMemPos", "Lvjson/pl/type/MemPos;", "hashCode", "toString", "indent", "typeInstance", "Lvjson/pl/type/TypeInstance;", "vjson"})
public final class VariableDefinition
extends Statement {
    @NotNull
    private String name;
    @NotNull
    private Expr value;
    @NotNull
    private Modifiers modifiers;
    @Nullable
    private TypeContext ctx;
    private int variableIndex;

    public VariableDefinition(@NotNull String name, @NotNull Expr value, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        this.name = name;
        this.value = value;
        this.modifiers = modifiers;
        this.variableIndex = -1;
    }

    public /* synthetic */ VariableDefinition(String string, Expr expr, Modifiers modifiers, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            modifiers = new Modifiers(0);
        }
        this(string, expr, modifiers);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final Expr getValue() {
        return this.value;
    }

    public final void setValue(@NotNull Expr expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"<set-?>");
        this.value = expr;
    }

    @NotNull
    public final Modifiers getModifiers() {
        return this.modifiers;
    }

    public final void setModifiers(@NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"<set-?>");
        this.modifiers = modifiers;
    }

    @Override
    @NotNull
    public VariableDefinition copy() {
        VariableDefinition ret2 = new VariableDefinition(this.name, this.value.copy(), this.modifiers);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    public final int getVariableIndex() {
        return this.variableIndex;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        if (ctx.hasVariableInThisContext(this.name)) {
            throw new ParserException("variable " + this.name + " is already defined", this.getLineCol());
        }
        if (this.modifiers.isExecutable()) {
            if (!(this.value instanceof Access)) {
                throw new ParserException("unexpected value " + this.value + " for executable variable " + this.name + ", expecting a function");
            }
            TypeInstance valueFuncType = this.value.check(ctx, null);
            Object object = valueFuncType.functionDescriptor(ctx);
            if (object == null) {
                throw new ParserException("unexpected value " + this.value + " (" + valueFuncType + ") for executable variable " + this.name + ", not a function");
            }
            FunctionDescriptor func = object;
            object = func.getParams();
            boolean bl = false;
            if (!object.isEmpty()) {
                throw new ParserException("unexpected value " + this.value + " (" + valueFuncType + ") for executable variable " + this.name + ", expecting a no-argument function");
            }
            if (func.getReturnType() instanceof VoidType) {
                throw new ParserException("unexpected value " + this.value + " (" + valueFuncType + ") for executable variable " + this.name + ", expecting a function with return value");
            }
            TypeInstance valueType = func.getReturnType();
            ctx.addVariable(new Variable(this.name, valueType, false, (Pair<? extends FunctionDescriptor, ? extends Instruction>)new Pair((Object)func, (Object)this.value.generateInstruction()), new MemPos(ctx.getMemoryDepth(), -1)));
        } else {
            TypeInstance valueType = this.value.check(ctx, null);
            if (valueType instanceof NullType) {
                throw new ParserException(this + ": cannot determine type for " + this.value, this.getLineCol());
            }
            this.variableIndex = ctx.getMemoryAllocator().nextIndexFor(valueType);
            ctx.addVariable(new Variable(this.name, valueType, !this.modifiers.isConst(), null, new MemPos(ctx.getMemoryDepth(), this.variableIndex)));
        }
    }

    @Override
    public boolean functionTerminationCheck() {
        return false;
    }

    @Override
    @NotNull
    public Instruction generateInstruction() {
        Instruction instruction;
        if (this.modifiers.isExecutable()) {
            return new NoOp();
        }
        Instruction valueInst = this.value.generateInstruction();
        TypeInstance typeInstance = this.value.typeInstance();
        if (typeInstance instanceof IntType) {
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            int n = typeContext.getMemoryDepth();
            TypeContext typeContext2 = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext2);
            instruction = new SetInt(n, this.variableIndex, valueInst, typeContext2.stackInfo(this.getLineCol()));
        } else if (typeInstance instanceof LongType) {
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            int n = typeContext.getMemoryDepth();
            TypeContext typeContext3 = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext3);
            instruction = new SetLong(n, this.variableIndex, valueInst, typeContext3.stackInfo(this.getLineCol()));
        } else if (typeInstance instanceof FloatType) {
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            int n = typeContext.getMemoryDepth();
            TypeContext typeContext4 = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext4);
            instruction = new SetFloat(n, this.variableIndex, valueInst, typeContext4.stackInfo(this.getLineCol()));
        } else if (typeInstance instanceof DoubleType) {
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            int n = typeContext.getMemoryDepth();
            TypeContext typeContext5 = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext5);
            instruction = new SetDouble(n, this.variableIndex, valueInst, typeContext5.stackInfo(this.getLineCol()));
        } else if (typeInstance instanceof BoolType) {
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            int n = typeContext.getMemoryDepth();
            TypeContext typeContext6 = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext6);
            instruction = new SetBool(n, this.variableIndex, valueInst, typeContext6.stackInfo(this.getLineCol()));
        } else {
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            int n = typeContext.getMemoryDepth();
            TypeContext typeContext7 = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext7);
            instruction = new SetRef(n, this.variableIndex, valueInst, typeContext7.stackInfo(this.getLineCol()));
        }
        return instruction;
    }

    @NotNull
    public final MemPos getMemPos() {
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        return new MemPos(typeContext.getMemoryDepth(), this.variableIndex);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        return this.modifiers.toStringWithSpace() + "var " + this.name + " = " + this.value;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final TypeInstance typeInstance() {
        if (this.modifiers.isExecutable()) {
            TypeInstance typeInstance = this.value.typeInstance();
            TypeContext typeContext = this.ctx;
            Intrinsics.checkNotNull((Object)typeContext);
            FunctionDescriptor functionDescriptor = typeInstance.functionDescriptor(typeContext);
            Intrinsics.checkNotNull((Object)functionDescriptor);
            return functionDescriptor.getReturnType();
        }
        return this.value.typeInstance();
    }

    @NotNull
    public final TypeContext getCtx() {
        TypeContext typeContext = this.ctx;
        Intrinsics.checkNotNull((Object)typeContext);
        return typeContext;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Expr component2() {
        return this.value;
    }

    @NotNull
    public final Modifiers component3() {
        return this.modifiers;
    }

    @NotNull
    public final VariableDefinition copy(@NotNull String name, @NotNull Expr value, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        return new VariableDefinition(name, value, modifiers);
    }

    public static /* synthetic */ VariableDefinition copy$default(VariableDefinition variableDefinition, String string, Expr expr, Modifiers modifiers, int n, Object object) {
        if ((n & 1) != 0) {
            string = variableDefinition.name;
        }
        if ((n & 2) != 0) {
            expr = variableDefinition.value;
        }
        if ((n & 4) != 0) {
            modifiers = variableDefinition.modifiers;
        }
        return variableDefinition.copy(string, expr, modifiers);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + this.modifiers.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableDefinition)) {
            return false;
        }
        VariableDefinition variableDefinition = (VariableDefinition)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)variableDefinition.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)variableDefinition.value)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.modifiers, (Object)variableDefinition.modifiers);
    }
}

