/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.pl.ast.BoolLiteral;
import vjson.pl.ast.Expr;
import vjson.pl.ast.LoopStatement;
import vjson.pl.ast.Statement;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.WhileLoopInstruction;
import vjson.pl.type.BoolType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J#\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lvjson/pl/ast/WhileLoop;", "Lvjson/pl/ast/LoopStatement;", "condition", "Lvjson/pl/ast/Expr;", "code", "", "Lvjson/pl/ast/Statement;", "(Lvjson/pl/ast/Expr;Ljava/util/List;)V", "getCode", "()Ljava/util/List;", "getCondition", "()Lvjson/pl/ast/Expr;", "checkAST", "", "ctx", "Lvjson/pl/type/TypeContext;", "component1", "component2", "copy", "equals", "", "other", "", "functionTerminationCheck", "generateInstruction", "Lvjson/pl/inst/Instruction;", "hashCode", "", "toString", "", "indent", "vjson"})
public final class WhileLoop
extends LoopStatement {
    @NotNull
    private final Expr condition;
    @NotNull
    private final List<Statement> code;

    public WhileLoop(@NotNull Expr condition, @NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        super(null, 1, null);
        this.condition = condition;
        this.code = code;
    }

    @NotNull
    public final Expr getCondition() {
        return this.condition;
    }

    @NotNull
    public final List<Statement> getCode() {
        return this.code;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WhileLoop copy() {
        Collection<Statement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.code;
        Expr expr = this.condition.copy();
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Statement statement = (Statement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Statement statement2 = it.copy();
            collection.add(statement2);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Expr expr2 = expr;
        WhileLoop ret2 = new WhileLoop(expr2, list);
        ret2.setLineCol(this.getLineCol());
        return ret2;
    }

    @Override
    public void checkAST(@NotNull TypeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TypeInstance conditionType = this.condition.check(ctx, BoolType.INSTANCE);
        if (!(conditionType instanceof BoolType)) {
            throw new ParserException(this.condition + " (" + conditionType + ") is not a boolean value, cannot be used as `while` loop condition", this.getLineCol());
        }
        TypeContext loopCtx = new TypeContext(ctx, null, this, 2, null);
        loopCtx.checkStatements(this.code);
    }

    @Override
    public boolean functionTerminationCheck() {
        if (!(this.condition instanceof BoolLiteral) || !((BoolLiteral)this.condition).getB()) {
            return false;
        }
        Boolean bl = this.isInfiniteLoop();
        if (bl == null) {
            return true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Instruction generateInstruction() {
        void $this$mapTo$iv$iv;
        Instruction conditionInst = this.condition.generateInstruction();
        Iterable $this$map$iv = this.code;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Statement statement = (Statement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Instruction instruction = it.generateInstruction();
            collection.add(instruction);
        }
        List codeInst = (List)destination$iv$iv;
        return new WhileLoopInstruction(conditionInst, codeInst);
    }

    @Override
    @NotNull
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("while: ").append(this.condition).append("; do: {\n");
        for (Statement stmt : this.code) {
            sb.append(StringsKt.repeat((CharSequence)" ", (int)(indent + 2))).append(stmt.toString(indent + 2)).append("\n");
        }
        sb.append(StringsKt.repeat((CharSequence)" ", (int)indent)).append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final Expr component1() {
        return this.condition;
    }

    @NotNull
    public final List<Statement> component2() {
        return this.code;
    }

    @NotNull
    public final WhileLoop copy(@NotNull Expr condition, @NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        return new WhileLoop(condition, code);
    }

    public static /* synthetic */ WhileLoop copy$default(WhileLoop whileLoop, Expr expr, List list, int n, Object object) {
        if ((n & 1) != 0) {
            expr = whileLoop.condition;
        }
        if ((n & 2) != 0) {
            list = whileLoop.code;
        }
        return whileLoop.copy(expr, list);
    }

    public int hashCode() {
        int result = this.condition.hashCode();
        result = result * 31 + ((Object)this.code).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhileLoop)) {
            return false;
        }
        WhileLoop whileLoop = (WhileLoop)other;
        if (!Intrinsics.areEqual((Object)this.condition, (Object)whileLoop.condition)) {
            return false;
        }
        return Intrinsics.areEqual(this.code, whileLoop.code);
    }
}

