/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.inst;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.FlowControlInstruction;
import vjson.pl.inst.Instruction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J9\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lvjson/pl/inst/ErrorHandlingInstruction;", "Lvjson/pl/inst/FlowControlInstruction;", "tryInst", "", "Lvjson/pl/inst/Instruction;", "errorCodeInst", "elseCodeInst", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "", "execute0", "", "ctx", "Lvjson/pl/inst/ActionContext;", "exec", "Lvjson/pl/inst/Execution;", "hashCode", "", "toString", "", "vjson"})
public final class ErrorHandlingInstruction
extends FlowControlInstruction {
    @NotNull
    private final List<Instruction> tryInst;
    @NotNull
    private final List<Instruction> errorCodeInst;
    @NotNull
    private final List<Instruction> elseCodeInst;

    public ErrorHandlingInstruction(@NotNull List<? extends Instruction> tryInst, @NotNull List<? extends Instruction> errorCodeInst, @NotNull List<? extends Instruction> elseCodeInst) {
        Intrinsics.checkNotNullParameter(tryInst, (String)"tryInst");
        Intrinsics.checkNotNullParameter(errorCodeInst, (String)"errorCodeInst");
        Intrinsics.checkNotNullParameter(elseCodeInst, (String)"elseCodeInst");
        this.tryInst = tryInst;
        this.errorCodeInst = errorCodeInst;
        this.elseCodeInst = elseCodeInst;
    }

    @Override
    protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        try {
            for (Instruction stmt : this.tryInst) {
                stmt.execute(ctx, exec);
                if (!this.needReturn(ctx)) continue;
                return;
            }
        }
        catch (Throwable e) {
            for (Instruction stmt : this.errorCodeInst) {
                exec.getValues().setErrorValue(e);
                stmt.execute(ctx, exec);
                if (!this.needReturn(ctx)) continue;
                return;
            }
            return;
        }
        for (Instruction stmt : this.elseCodeInst) {
            stmt.execute(ctx, exec);
            if (!this.needReturn(ctx)) continue;
            return;
        }
    }

    private final List<Instruction> component1() {
        return this.tryInst;
    }

    private final List<Instruction> component2() {
        return this.errorCodeInst;
    }

    private final List<Instruction> component3() {
        return this.elseCodeInst;
    }

    @NotNull
    public final ErrorHandlingInstruction copy(@NotNull List<? extends Instruction> tryInst, @NotNull List<? extends Instruction> errorCodeInst, @NotNull List<? extends Instruction> elseCodeInst) {
        Intrinsics.checkNotNullParameter(tryInst, (String)"tryInst");
        Intrinsics.checkNotNullParameter(errorCodeInst, (String)"errorCodeInst");
        Intrinsics.checkNotNullParameter(elseCodeInst, (String)"elseCodeInst");
        return new ErrorHandlingInstruction(tryInst, errorCodeInst, elseCodeInst);
    }

    public static /* synthetic */ ErrorHandlingInstruction copy$default(ErrorHandlingInstruction errorHandlingInstruction, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = errorHandlingInstruction.tryInst;
        }
        if ((n & 2) != 0) {
            list2 = errorHandlingInstruction.errorCodeInst;
        }
        if ((n & 4) != 0) {
            list3 = errorHandlingInstruction.elseCodeInst;
        }
        return errorHandlingInstruction.copy(list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "ErrorHandlingInstruction(tryInst=" + this.tryInst + ", errorCodeInst=" + this.errorCodeInst + ", elseCodeInst=" + this.elseCodeInst + ')';
    }

    public int hashCode() {
        int result = ((Object)this.tryInst).hashCode();
        result = result * 31 + ((Object)this.errorCodeInst).hashCode();
        result = result * 31 + ((Object)this.elseCodeInst).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ErrorHandlingInstruction)) {
            return false;
        }
        ErrorHandlingInstruction errorHandlingInstruction = (ErrorHandlingInstruction)other;
        if (!Intrinsics.areEqual(this.tryInst, errorHandlingInstruction.tryInst)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorCodeInst, errorHandlingInstruction.errorCodeInst)) {
            return false;
        }
        return Intrinsics.areEqual(this.elseCodeInst, errorHandlingInstruction.elseCodeInst);
    }
}

