/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.inst;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.FlowControlInstruction;
import vjson.pl.inst.Instruction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0004H\u00c2\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003JC\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lvjson/pl/inst/ForLoopInstruction;", "Lvjson/pl/inst/FlowControlInstruction;", "initInst", "", "Lvjson/pl/inst/Instruction;", "conditionInst", "incrInst", "codeInst", "(Ljava/util/List;Lvjson/pl/inst/Instruction;Ljava/util/List;Ljava/util/List;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "execute0", "", "ctx", "Lvjson/pl/inst/ActionContext;", "exec", "Lvjson/pl/inst/Execution;", "hashCode", "", "toString", "", "vjson"})
public final class ForLoopInstruction
extends FlowControlInstruction {
    @NotNull
    private final List<Instruction> initInst;
    @NotNull
    private final Instruction conditionInst;
    @NotNull
    private final List<Instruction> incrInst;
    @NotNull
    private final List<Instruction> codeInst;

    public ForLoopInstruction(@NotNull List<? extends Instruction> initInst, @NotNull Instruction conditionInst, @NotNull List<? extends Instruction> incrInst, @NotNull List<? extends Instruction> codeInst) {
        Intrinsics.checkNotNullParameter(initInst, (String)"initInst");
        Intrinsics.checkNotNullParameter((Object)conditionInst, (String)"conditionInst");
        Intrinsics.checkNotNullParameter(incrInst, (String)"incrInst");
        Intrinsics.checkNotNullParameter(codeInst, (String)"codeInst");
        this.initInst = initInst;
        this.conditionInst = conditionInst;
        this.incrInst = incrInst;
        this.codeInst = codeInst;
    }

    @Override
    protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        if (this.needReturn(ctx)) {
            return;
        }
        for (Instruction stmt : this.initInst) {
            stmt.execute(ctx, exec);
            if (!this.needReturn(ctx)) continue;
            return;
        }
        block1: while (true) {
            this.conditionInst.execute(ctx, exec);
            if (!exec.getValues().getBoolValue()) {
                return;
            }
            for (Instruction stmt : this.codeInst) {
                ActionContext actionContext;
                stmt.execute(ctx, exec);
                if (ctx.getBreakImmediately() > 0) {
                    actionContext = ctx;
                    actionContext.setBreakImmediately(actionContext.getBreakImmediately() - 1);
                    return;
                }
                if (ctx.getContinueImmediately() > 0) {
                    actionContext = ctx;
                    actionContext.setContinueImmediately(actionContext.getContinueImmediately() - 1);
                    if (ctx.getContinueImmediately() <= 1) break;
                    return;
                }
                if (!this.needReturn(ctx)) continue;
                return;
            }
            Iterator<Instruction> iterator = this.incrInst.iterator();
            do {
                Instruction stmt;
                if (!iterator.hasNext()) continue block1;
                stmt = iterator.next();
                stmt.execute(ctx, exec);
            } while (!this.needReturn(ctx));
            break;
        }
    }

    private final List<Instruction> component1() {
        return this.initInst;
    }

    private final Instruction component2() {
        return this.conditionInst;
    }

    private final List<Instruction> component3() {
        return this.incrInst;
    }

    private final List<Instruction> component4() {
        return this.codeInst;
    }

    @NotNull
    public final ForLoopInstruction copy(@NotNull List<? extends Instruction> initInst, @NotNull Instruction conditionInst, @NotNull List<? extends Instruction> incrInst, @NotNull List<? extends Instruction> codeInst) {
        Intrinsics.checkNotNullParameter(initInst, (String)"initInst");
        Intrinsics.checkNotNullParameter((Object)conditionInst, (String)"conditionInst");
        Intrinsics.checkNotNullParameter(incrInst, (String)"incrInst");
        Intrinsics.checkNotNullParameter(codeInst, (String)"codeInst");
        return new ForLoopInstruction(initInst, conditionInst, incrInst, codeInst);
    }

    public static /* synthetic */ ForLoopInstruction copy$default(ForLoopInstruction forLoopInstruction, List list, Instruction instruction, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = forLoopInstruction.initInst;
        }
        if ((n & 2) != 0) {
            instruction = forLoopInstruction.conditionInst;
        }
        if ((n & 4) != 0) {
            list2 = forLoopInstruction.incrInst;
        }
        if ((n & 8) != 0) {
            list3 = forLoopInstruction.codeInst;
        }
        return forLoopInstruction.copy(list, instruction, list2, list3);
    }

    @NotNull
    public String toString() {
        return "ForLoopInstruction(initInst=" + this.initInst + ", conditionInst=" + this.conditionInst + ", incrInst=" + this.incrInst + ", codeInst=" + this.codeInst + ')';
    }

    public int hashCode() {
        int result = ((Object)this.initInst).hashCode();
        result = result * 31 + this.conditionInst.hashCode();
        result = result * 31 + ((Object)this.incrInst).hashCode();
        result = result * 31 + ((Object)this.codeInst).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForLoopInstruction)) {
            return false;
        }
        ForLoopInstruction forLoopInstruction = (ForLoopInstruction)other;
        if (!Intrinsics.areEqual(this.initInst, forLoopInstruction.initInst)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.conditionInst, (Object)forLoopInstruction.conditionInst)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.incrInst, forLoopInstruction.incrInst)) {
            return false;
        }
        return Intrinsics.areEqual(this.codeInst, forLoopInstruction.codeInst);
    }
}

