/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.inst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.InstructionException;
import vjson.pl.inst.StackInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lvjson/pl/inst/Instruction;", "", "()V", "recordStackInfo", "", "getRecordStackInfo", "()Z", "setRecordStackInfo", "(Z)V", "stackInfo", "Lvjson/pl/inst/StackInfo;", "getStackInfo", "()Lvjson/pl/inst/StackInfo;", "execute", "", "ctx", "Lvjson/pl/inst/ActionContext;", "exec", "Lvjson/pl/inst/Execution;", "execute0", "vjson"})
public abstract class Instruction {
    private boolean recordStackInfo;

    @NotNull
    public abstract StackInfo getStackInfo();

    protected final boolean getRecordStackInfo() {
        return this.recordStackInfo;
    }

    protected final void setRecordStackInfo(boolean bl) {
        this.recordStackInfo = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull ActionContext ctx, @NotNull Execution exec) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        if (ctx.getReturnImmediately()) {
            return;
        }
        if (this.recordStackInfo) {
            exec.getStackTrace().add(this.getStackInfo());
        }
        try {
            this.execute0(ctx, exec);
        }
        catch (InstructionException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = e.getMessage();
            ArrayList<StackInfo> stackTrace = new ArrayList<StackInfo>(exec.getStackTrace().size() + 1);
            stackTrace.addAll((Collection)exec.getStackTrace());
            if (!this.recordStackInfo) {
                stackTrace.add(this.getStackInfo());
            }
            InstructionException ex = msg == null ? new InstructionException((List<StackInfo>)stackTrace, e) : new InstructionException(msg, (List<StackInfo>)stackTrace, e);
            throw ex;
        }
        finally {
            if (this.recordStackInfo) {
                CollectionsKt.removeLast(exec.getStackTrace());
            }
        }
    }

    protected abstract void execute0(@NotNull ActionContext var1, @NotNull Execution var2);
}

