/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.inst;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.FlowControlInstruction;
import vjson.pl.inst.Instruction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c2\u0003J#\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lvjson/pl/inst/WhileLoopInstruction;", "Lvjson/pl/inst/FlowControlInstruction;", "conditionInst", "Lvjson/pl/inst/Instruction;", "codeInst", "", "(Lvjson/pl/inst/Instruction;Ljava/util/List;)V", "component1", "component2", "copy", "equals", "", "other", "", "execute0", "", "ctx", "Lvjson/pl/inst/ActionContext;", "exec", "Lvjson/pl/inst/Execution;", "hashCode", "", "toString", "", "vjson"})
public final class WhileLoopInstruction
extends FlowControlInstruction {
    @NotNull
    private final Instruction conditionInst;
    @NotNull
    private final List<Instruction> codeInst;

    public WhileLoopInstruction(@NotNull Instruction conditionInst, @NotNull List<? extends Instruction> codeInst) {
        Intrinsics.checkNotNullParameter((Object)conditionInst, (String)"conditionInst");
        Intrinsics.checkNotNullParameter(codeInst, (String)"codeInst");
        this.conditionInst = conditionInst;
        this.codeInst = codeInst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        block0: while (true) {
            this.conditionInst.execute(ctx, exec);
            if (!exec.getValues().getBoolValue()) {
                return;
            }
            Iterator<Instruction> iterator = this.codeInst.iterator();
            do {
                ActionContext actionContext;
                if (!iterator.hasNext()) continue block0;
                Instruction stmt = iterator.next();
                stmt.execute(ctx, exec);
                if (ctx.getBreakImmediately() > 0) {
                    actionContext = ctx;
                    actionContext.setBreakImmediately(actionContext.getBreakImmediately() - 1);
                    return;
                }
                if (ctx.getContinueImmediately() <= 0) continue;
                actionContext = ctx;
                actionContext.setContinueImmediately(actionContext.getContinueImmediately() - 1);
                if (ctx.getContinueImmediately() > 1) return;
                continue block0;
            } while (!this.needReturn(ctx));
            break;
        }
    }

    private final Instruction component1() {
        return this.conditionInst;
    }

    private final List<Instruction> component2() {
        return this.codeInst;
    }

    @NotNull
    public final WhileLoopInstruction copy(@NotNull Instruction conditionInst, @NotNull List<? extends Instruction> codeInst) {
        Intrinsics.checkNotNullParameter((Object)conditionInst, (String)"conditionInst");
        Intrinsics.checkNotNullParameter(codeInst, (String)"codeInst");
        return new WhileLoopInstruction(conditionInst, codeInst);
    }

    public static /* synthetic */ WhileLoopInstruction copy$default(WhileLoopInstruction whileLoopInstruction, Instruction instruction, List list, int n, Object object) {
        if ((n & 1) != 0) {
            instruction = whileLoopInstruction.conditionInst;
        }
        if ((n & 2) != 0) {
            list = whileLoopInstruction.codeInst;
        }
        return whileLoopInstruction.copy(instruction, list);
    }

    @NotNull
    public String toString() {
        return "WhileLoopInstruction(conditionInst=" + this.conditionInst + ", codeInst=" + this.codeInst + ')';
    }

    public int hashCode() {
        int result = this.conditionInst.hashCode();
        result = result * 31 + ((Object)this.codeInst).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhileLoopInstruction)) {
            return false;
        }
        WhileLoopInstruction whileLoopInstruction = (WhileLoopInstruction)other;
        if (!Intrinsics.areEqual((Object)this.conditionInst, (Object)whileLoopInstruction.conditionInst)) {
            return false;
        }
        return Intrinsics.areEqual(this.codeInst, whileLoopInstruction.codeInst);
    }
}

