/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.token;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.CharStream;
import vjson.JSON;
import vjson.cs.LineCol;
import vjson.parser.NumberParser;
import vjson.pl.token.Token;
import vjson.pl.token.TokenHandler;
import vjson.pl.token.TokenType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lvjson/pl/token/FloatTokenHandler;", "Lvjson/pl/token/TokenHandler;", "()V", "endsWithDot", "", "finished", "parser", "Lvjson/parser/NumberParser;", "result", "Lvjson/JSON$Number;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "build", "", "Lvjson/pl/token/Token;", "lineCol", "Lvjson/cs/LineCol;", "check", "feed", "c", "", "finish", "", "precedence", "", "reset", "toString", "", "vjson"})
public final class FloatTokenHandler
implements TokenHandler {
    @NotNull
    private final NumberParser parser = new NumberParser(null, 1, null);
    @Nullable
    private JSON.Number<?> result;
    private boolean finished;
    @NotNull
    private final StringBuilder sb = new StringBuilder();
    private boolean endsWithDot;

    @Override
    public boolean feed(char c) {
        Object object;
        if (c == '-') {
            return false;
        }
        if (this.finished) {
            return false;
        }
        try {
            object = new char[]{c};
            object = (JSON.Number)this.parser.feed(CharStream.Companion.from((char[])object));
        }
        catch (Exception e) {
            return false;
        }
        Object res = object;
        if (res != null) {
            this.finished = true;
        }
        if (res instanceof JSON.Double) {
            this.result = res;
        }
        if (this.finished) {
            return false;
        }
        this.sb.append(c);
        return true;
    }

    private final void finish() {
        Object object;
        if (StringsKt.last((CharSequence)this.sb) == '.') {
            this.endsWithDot = true;
            StringBuilder stringBuilder = this.sb;
            int n = this.sb.length() - 1;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.deleteCharAt(n), (String)"this.deleteCharAt(index)");
        }
        try {
            NumberParser numberParser = new NumberParser(null, 1, null);
            object = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
            object = numberParser.build(CharStream.Companion.from((String)object), true);
        }
        catch (Exception e) {
            return;
        }
        Object res = object;
        if (res != null) {
            this.finished = true;
        }
        if (this.endsWithDot) {
            if (res instanceof JSON.Integer || res instanceof JSON.Long) {
                this.result = res;
            }
        } else if (res instanceof JSON.Double) {
            this.result = res;
        }
    }

    @Override
    public boolean check() {
        if (!this.finished) {
            this.finish();
        }
        return this.finished && this.result != null;
    }

    @Override
    @NotNull
    public List<Token> build(@NotNull LineCol lineCol) {
        List list;
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        Object[] objectArray = this.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sb.toString()");
        Object[] raw = objectArray;
        if (this.endsWithDot) {
            objectArray = new Token[]{new Token(TokenType.INTEGER, (String)raw, lineCol, this.result), new Token(TokenType.DOT, ".", lineCol.addCol(this.sb.length()), null, 8, null)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)new Token(TokenType.FLOAT, (String)raw, lineCol, this.result));
        }
        return list;
    }

    @Override
    public void reset() {
        this.parser.reset();
        this.result = null;
        this.finished = false;
        StringsKt.clear((StringBuilder)this.sb);
        this.endsWithDot = false;
    }

    @Override
    public int precedence() {
        return 0;
    }

    @NotNull
    public String toString() {
        return "FloatTokenHandler";
    }
}

