/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ast.AST;
import vjson.pl.ast.BreakStatement;
import vjson.pl.ast.ClassDefinition;
import vjson.pl.ast.ContinueStatement;
import vjson.pl.ast.FunctionDefinition;
import vjson.pl.ast.Statement;
import vjson.pl.ast.Type;
import vjson.pl.inst.StackInfo;
import vjson.pl.type.BoolType;
import vjson.pl.type.DoubleType;
import vjson.pl.type.ErrorType;
import vjson.pl.type.FloatType;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.FunctionDescriptorTypeInstance;
import vjson.pl.type.IntType;
import vjson.pl.type.LongType;
import vjson.pl.type.MemoryAllocator;
import vjson.pl.type.MemoryAllocatorProvider;
import vjson.pl.type.ParamInstance;
import vjson.pl.type.StringType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;
import vjson.pl.type.Variable;
import vjson.pl.type.VoidType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 E2\u00020\u0001:\u0001EB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBk\b\u0012\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u000e\u001a\u00020\t\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0010\u0012\u0006\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0017J\u0014\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u0006\u0010&\u001a\u00020\u0000J\u001c\u0010'\u001a\u0004\u0018\u00010\u00062\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020*0)J\u001c\u0010+\u001a\u0004\u0018\u00010\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020*0)J\b\u0010,\u001a\u0004\u0018\u00010\u0004J$\u0010-\u001a\u00020\u00142\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0$2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u000202J$\u00103\u001a\u0002042\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0$2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u000202J\u0006\u00105\u001a\u00020\tJ\u0006\u00106\u001a\u00020\fJ\u000e\u00107\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0011J\u000e\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u0016J\u000e\u0010:\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0011J\u000e\u0010;\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0011J\u000e\u0010<\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020*2\u0006\u00109\u001a\u00020\u0016J\u000e\u0010>\u001a\u00020*2\u0006\u00109\u001a\u00020\u0016J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lvjson/pl/type/TypeContext;", "", "parent", "contextType", "Lvjson/pl/type/TypeInstance;", "ast", "Lvjson/pl/ast/AST;", "(Lvjson/pl/type/TypeContext;Lvjson/pl/type/TypeInstance;Lvjson/pl/ast/AST;)V", "globalMemory", "Lvjson/pl/type/MemoryAllocator;", "(Lvjson/pl/type/MemoryAllocator;)V", "i", "", "(I)V", "memoryAllocator", "typeNameMap", "", "Lvjson/pl/ast/Type;", "functionDescriptorSet", "", "Lvjson/pl/type/FunctionDescriptor;", "variableMap", "", "Lvjson/pl/type/Variable;", "memoryDepth", "(Lvjson/pl/type/TypeInstance;Lvjson/pl/ast/AST;Lvjson/pl/type/TypeContext;Lvjson/pl/type/MemoryAllocator;Ljava/util/Map;Ljava/util/Set;Ljava/util/Map;I)V", "", "", "addType", "", "astType", "type", "addVariable", "variable", "checkStatements", "code", "", "Lvjson/pl/ast/Statement;", "copy", "getContextAST", "func", "Lkotlin/Function1;", "", "getContextByAST", "getContextType", "getFunctionDescriptor", "params", "Lvjson/pl/type/ParamInstance;", "returnType", "mem", "Lvjson/pl/type/MemoryAllocatorProvider;", "getFunctionDescriptorAsInstance", "Lvjson/pl/type/FunctionDescriptorTypeInstance;", "getMemoryAllocator", "getMemoryDepth", "getType", "getVariable", "name", "hasType", "hasTypeConsiderArray", "hasTypeInThisContext", "hasVariable", "hasVariableInThisContext", "stackInfo", "Lvjson/pl/inst/StackInfo;", "lineCol", "Lvjson/cs/LineCol;", "tmpVar", "prefix", "Companion", "vjson"})
public final class TypeContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TypeInstance contextType;
    @Nullable
    private final AST ast;
    @Nullable
    private final TypeContext parent;
    @NotNull
    private final MemoryAllocator memoryAllocator;
    @NotNull
    private final Map<Type, TypeInstance> typeNameMap;
    @NotNull
    private final Set<FunctionDescriptor> functionDescriptorSet;
    @NotNull
    private final Map<String, Variable> variableMap;
    private final int memoryDepth;
    @NotNull
    private static final TypeContext rootContext = new TypeContext(0);

    public TypeContext(@NotNull TypeContext parent, @Nullable TypeInstance contextType, @Nullable AST ast) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.typeNameMap = new HashMap();
        this.functionDescriptorSet = new HashSet();
        this.variableMap = new HashMap();
        TypeInstance typeInstance = contextType;
        this.contextType = typeInstance == null ? parent.contextType : typeInstance;
        this.ast = ast;
        this.parent = parent;
        this.memoryAllocator = ast instanceof MemoryAllocatorProvider ? ((MemoryAllocatorProvider)((Object)ast)).memoryAllocator() : parent.memoryAllocator;
        this.memoryDepth = parent.memoryDepth + (ast instanceof MemoryAllocatorProvider ? 1 : 0);
    }

    public /* synthetic */ TypeContext(TypeContext typeContext, TypeInstance typeInstance, AST aST, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            typeInstance = null;
        }
        if ((n & 4) != 0) {
            aST = null;
        }
        this(typeContext, typeInstance, aST);
    }

    public TypeContext(@NotNull MemoryAllocator globalMemory) {
        Intrinsics.checkNotNullParameter((Object)globalMemory, (String)"globalMemory");
        this.typeNameMap = new HashMap();
        this.functionDescriptorSet = new HashSet();
        this.variableMap = new HashMap();
        this.contextType = null;
        this.ast = null;
        this.parent = rootContext;
        this.memoryAllocator = globalMemory;
        this.memoryDepth = 0;
    }

    private TypeContext(int i) {
        this.typeNameMap = new HashMap();
        this.functionDescriptorSet = new HashSet();
        this.variableMap = new HashMap();
        this.contextType = null;
        this.ast = null;
        this.parent = null;
        this.memoryAllocator = new MemoryAllocator();
        this.memoryDepth = -1;
    }

    @Nullable
    public final TypeInstance getContextType() {
        return this.contextType;
    }

    public final boolean hasType(@NotNull Type type) {
        TypeContext typeContext;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.hasTypeInThisContext(type) ? true : ((typeContext = this.parent) == null ? false : typeContext.hasType(type));
    }

    public final boolean hasTypeConsiderArray(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.hasType(type)) {
            return true;
        }
        if (!type.isArray()) {
            return false;
        }
        return this.hasTypeConsiderArray(type.getElementType());
    }

    public final boolean hasTypeInThisContext(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.typeNameMap.containsKey(type);
    }

    @NotNull
    public final TypeInstance getType(@NotNull Type type) {
        TypeInstance typeInstance;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeInstance typeInstance2 = this.typeNameMap.get(type);
        if (typeInstance2 == null) {
            TypeContext typeContext = this.parent;
            if (typeContext == null) {
                throw new NoSuchElementException(type.toString());
            }
            typeInstance = typeContext.getType(type);
        } else {
            typeInstance = typeInstance2;
        }
        return typeInstance;
    }

    public final void addType(@NotNull Type astType, @NotNull TypeInstance type) {
        Intrinsics.checkNotNullParameter((Object)astType, (String)"astType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.typeNameMap.containsKey(astType)) {
            throw new IllegalStateException("type " + astType + " already exists");
        }
        Map<Type, TypeInstance> map = this.typeNameMap;
        boolean bl = false;
        map.put(astType, type);
    }

    @NotNull
    public final FunctionDescriptor getFunctionDescriptor(@NotNull List<ParamInstance> params, @NotNull TypeInstance returnType, @NotNull MemoryAllocatorProvider mem) {
        Object v0;
        FunctionDescriptor desc;
        block2: {
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
            Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
            desc = new FunctionDescriptor(params, returnType, mem);
            Iterable iterable = this.functionDescriptorSet;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FunctionDescriptor it = (FunctionDescriptor)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)desc)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        FunctionDescriptor res = v0;
        if (res == null) {
            this.functionDescriptorSet.add(desc);
            return desc;
        }
        return res;
    }

    @NotNull
    public final FunctionDescriptorTypeInstance getFunctionDescriptorAsInstance(@NotNull List<ParamInstance> params, @NotNull TypeInstance returnType, @NotNull MemoryAllocatorProvider mem) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)mem, (String)"mem");
        return new FunctionDescriptorTypeInstance(this.getFunctionDescriptor(params, returnType, mem));
    }

    public final boolean hasVariable(@NotNull String name) {
        TypeContext typeContext;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.hasVariableInThisContext(name) ? true : ((typeContext = this.parent) == null ? false : typeContext.hasVariable(name));
    }

    public final boolean hasVariableInThisContext(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.variableMap.containsKey(name);
    }

    @NotNull
    public final Variable getVariable(@NotNull String name) {
        Variable variable;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Variable variable2 = this.variableMap.get(name);
        if (variable2 == null) {
            TypeContext typeContext = this.parent;
            if (typeContext == null) {
                throw new NoSuchElementException(name);
            }
            variable = typeContext.getVariable(name);
        } else {
            variable = variable2;
        }
        return variable;
    }

    public final void addVariable(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (this.variableMap.containsKey(variable.getName())) {
            throw new IllegalStateException("variable " + variable.getName() + " already exists");
        }
        Map<String, Variable> map = this.variableMap;
        String string = variable.getName();
        boolean bl = false;
        map.put(string, variable);
    }

    public final void checkStatements(@NotNull List<? extends Statement> code) {
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Iterator<? extends Statement> iterator = code.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Statement stmt = iterator.next();
            stmt.checkAST(this);
            if (!stmt.functionTerminationCheck() && !(stmt instanceof BreakStatement) && !(stmt instanceof ContinueStatement) || code.size() == index + 1) continue;
            ArrayList<Statement> nextStmts = new ArrayList<Statement>(code.size() - index - 1);
            ListIterator<? extends Statement> ite = code.listIterator(index + 1);
            while (ite.hasNext()) {
                nextStmts.add(ite.next());
            }
            throw new ParserException("no statement should appear after " + stmt + ", but got: " + nextStmts);
        }
    }

    @Nullable
    public final AST getContextAST(@NotNull Function1<? super AST, Boolean> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        if (this.ast != null && ((Boolean)func.invoke((Object)this.ast)).booleanValue()) {
            return this.ast;
        }
        if (this.parent != null) {
            return this.parent.getContextAST(func);
        }
        return null;
    }

    @Nullable
    public final TypeContext getContextByAST(@NotNull Function1<? super AST, Boolean> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        if (this.ast != null && ((Boolean)func.invoke((Object)this.ast)).booleanValue()) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getContextByAST(func);
        }
        return null;
    }

    @NotNull
    public final MemoryAllocator getMemoryAllocator() {
        return this.memoryAllocator;
    }

    public final int getMemoryDepth() {
        return this.memoryDepth;
    }

    @NotNull
    public final StackInfo stackInfo(@NotNull LineCol lineCol) {
        StackInfo stackInfo2;
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        TypeContext funcCtx2 = this.getContextByAST((Function1<? super AST, Boolean>)((Function1)stackInfo.funcCtx.1.INSTANCE));
        TypeContext clsCtx2 = this.getContextByAST((Function1<? super AST, Boolean>)((Function1)stackInfo.clsCtx.1.INSTANCE));
        if (clsCtx2 != null && funcCtx2 != null) {
            if (clsCtx2.memoryDepth < funcCtx2.memoryDepth) {
                AST aST = clsCtx2.ast;
                if (aST == null) {
                    throw new NullPointerException("null cannot be cast to non-null type vjson.pl.ast.ClassDefinition");
                }
                String string = ((ClassDefinition)aST).getName();
                aST = funcCtx2.ast;
                if (aST == null) {
                    throw new NullPointerException("null cannot be cast to non-null type vjson.pl.ast.FunctionDefinition");
                }
                StackInfo stackInfo3 = new StackInfo(string, ((FunctionDefinition)aST).getName(), lineCol);
                stackInfo2 = stackInfo3;
            } else {
                AST aST = clsCtx2.ast;
                if (aST == null) {
                    throw new NullPointerException("null cannot be cast to non-null type vjson.pl.ast.ClassDefinition");
                }
                StackInfo stackInfo4 = new StackInfo(((ClassDefinition)aST).getName(), null, lineCol);
                stackInfo2 = stackInfo4;
            }
        } else if (clsCtx2 == null && funcCtx2 != null) {
            AST aST = funcCtx2.ast;
            if (aST == null) {
                throw new NullPointerException("null cannot be cast to non-null type vjson.pl.ast.FunctionDefinition");
            }
            StackInfo stackInfo5 = new StackInfo(null, ((FunctionDefinition)aST).getName(), lineCol);
            stackInfo2 = stackInfo5;
        } else if (clsCtx2 != null) {
            AST aST = clsCtx2.ast;
            if (aST == null) {
                throw new NullPointerException("null cannot be cast to non-null type vjson.pl.ast.ClassDefinition");
            }
            StackInfo stackInfo6 = new StackInfo(((ClassDefinition)aST).getName(), null, lineCol);
            stackInfo2 = stackInfo6;
        } else {
            stackInfo2 = new StackInfo(null, null, lineCol);
        }
        return stackInfo2;
    }

    @NotNull
    public final String tmpVar(@NotNull String prefix) {
        String name;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        int n = 0;
        while (this.hasVariable(name = Intrinsics.stringPlus((String)prefix, (Object)n))) {
            ++n;
        }
        return name;
    }

    private TypeContext(TypeInstance contextType, AST ast, TypeContext parent, MemoryAllocator memoryAllocator2, Map<Type, ? extends TypeInstance> typeNameMap, Set<? extends FunctionDescriptor> functionDescriptorSet, Map<String, Variable> variableMap, int memoryDepth) {
        this.typeNameMap = new HashMap();
        this.functionDescriptorSet = new HashSet();
        this.variableMap = new HashMap();
        this.contextType = contextType;
        this.ast = ast;
        this.parent = parent;
        this.memoryAllocator = memoryAllocator2;
        this.typeNameMap.putAll(typeNameMap);
        this.functionDescriptorSet.addAll((Collection<FunctionDescriptor>)functionDescriptorSet);
        this.variableMap.putAll(variableMap);
        this.memoryDepth = memoryDepth;
    }

    @NotNull
    public final TypeContext copy() {
        return new TypeContext(this.contextType, this.ast, this.parent, this.memoryAllocator, this.typeNameMap, this.functionDescriptorSet, this.variableMap, this.memoryDepth);
    }

    static {
        rootContext.addType(new Type("int"), IntType.INSTANCE);
        rootContext.addType(new Type("long"), LongType.INSTANCE);
        rootContext.addType(new Type("float"), FloatType.INSTANCE);
        rootContext.addType(new Type("double"), DoubleType.INSTANCE);
        rootContext.addType(new Type("string"), StringType.INSTANCE);
        rootContext.addType(new Type("bool"), BoolType.INSTANCE);
        rootContext.addType(new Type("void"), VoidType.INSTANCE);
        rootContext.addType(new Type("error"), ErrorType.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvjson/pl/type/TypeContext$Companion;", "", "()V", "rootContext", "Lvjson/pl/type/TypeContext;", "vjson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

