/*
 * Decompiled with CFR 0.152.
 */
package vjson.pl.type;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vjson.cs.LineCol;
import vjson.ex.ParserException;
import vjson.pl.ast.Expr;
import vjson.pl.inst.ActionContext;
import vjson.pl.inst.Execution;
import vjson.pl.inst.FunctionInstance;
import vjson.pl.inst.Instruction;
import vjson.pl.inst.InstructionWithStackInfo;
import vjson.pl.inst.RuntimeMemoryTotal;
import vjson.pl.inst.StackInfo;
import vjson.pl.type.ClassTypeInstance;
import vjson.pl.type.Field;
import vjson.pl.type.FunctionDescriptor;
import vjson.pl.type.NullType;
import vjson.pl.type.PrimitiveTypeInstance;
import vjson.pl.type.StringType;
import vjson.pl.type.TypeContext;
import vjson.pl.type.TypeInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0015"}, d2={"Lvjson/pl/type/TypeUtils;", "", "()V", "assignableFrom", "", "parent", "Lvjson/pl/type/TypeInstance;", "child", "buildToStringInstruction", "Lvjson/pl/inst/Instruction;", "ctx", "Lvjson/pl/type/TypeContext;", "variableType", "getFuncInst", "lineCol", "Lvjson/cs/LineCol;", "checkImplicitStringCast", "", "typeToStringCheck", "variableToStringCheck", "Lvjson/pl/ast/Expr;", "vjson"})
public final class TypeUtils {
    @NotNull
    public static final TypeUtils INSTANCE = new TypeUtils();

    private TypeUtils() {
    }

    public final boolean assignableFrom(@NotNull TypeInstance parent, @NotNull TypeInstance child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (Intrinsics.areEqual((Object)parent, (Object)child)) {
            return true;
        }
        if (!(parent instanceof PrimitiveTypeInstance) && child instanceof NullType) {
            return true;
        }
        if (parent.templateType() != null && child.templateType() != null) {
            if (!Intrinsics.areEqual((Object)parent.templateType(), (Object)child.templateType())) {
                return false;
            }
            List<TypeInstance> list = parent.templateTypeParams();
            Intrinsics.checkNotNull(list);
            List<TypeInstance> parentParams = list;
            List<TypeInstance> list2 = child.templateTypeParams();
            Intrinsics.checkNotNull(list2);
            List<TypeInstance> childParams = list2;
            int n = 0;
            int n2 = parentParams.size() + -1;
            if (n <= n2) {
                do {
                    int i;
                    if (this.assignableFrom(parentParams.get(i = n++), childParams.get(i))) continue;
                    return false;
                } while (n <= n2);
            }
            return true;
        }
        return false;
    }

    public final void checkImplicitStringCast(@NotNull TypeContext ctx, @NotNull TypeInstance typeToStringCheck, @NotNull Expr variableToStringCheck, @NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)typeToStringCheck, (String)"typeToStringCheck");
        Intrinsics.checkNotNullParameter((Object)variableToStringCheck, (String)"variableToStringCheck");
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        Field field2 = typeToStringCheck.field(ctx, "toString", ctx.getContextType());
        if (field2 == null) {
            throw new ParserException(this + ": cannot concat string, " + variableToStringCheck + " (" + typeToStringCheck + ") does not have `toString` field", lineCol);
        }
        Field toStringField = field2;
        Object object = toStringField.getType().functionDescriptor(ctx);
        if (object == null) {
            throw new ParserException(this + ": cannot concat string, " + variableToStringCheck + " (" + typeToStringCheck + ") `toString` field is not a function", lineCol);
        }
        FunctionDescriptor toStringFunc = object;
        object = toStringFunc.getParams();
        boolean bl = false;
        if (!object.isEmpty()) {
            throw new ParserException(this + ": cannot concat string, " + variableToStringCheck + " (" + typeToStringCheck + ") `toString` function parameters list is not empty", lineCol);
        }
        if (!(toStringFunc.getReturnType() instanceof StringType)) {
            throw new ParserException(this + ": cannot concat string, " + variableToStringCheck + " (" + typeToStringCheck + ") `toString` function return type (" + toStringField.getType() + ") is not " + StringType.INSTANCE, lineCol);
        }
    }

    @NotNull
    public final Instruction buildToStringInstruction(@NotNull TypeContext ctx, @NotNull TypeInstance variableType, @NotNull Instruction getFuncInst, @NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)variableType, (String)"variableType");
        Intrinsics.checkNotNullParameter((Object)getFuncInst, (String)"getFuncInst");
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        Field field2 = variableType.field(ctx, "toString", ctx.getContextType());
        Intrinsics.checkNotNull((Object)field2);
        Field toStringField = field2;
        FunctionDescriptor functionDescriptor = toStringField.getType().functionDescriptor(ctx);
        Intrinsics.checkNotNull((Object)functionDescriptor);
        FunctionDescriptor toStringFunc = functionDescriptor;
        RuntimeMemoryTotal total = toStringFunc.getMem().memoryAllocator().getTotal();
        int depth = variableType instanceof ClassTypeInstance ? ((ClassTypeInstance)variableType).getCls().getMemDepth() : 0;
        StackInfo stackInfo2 = ctx.stackInfo(lineCol);
        return new InstructionWithStackInfo(getFuncInst, total, depth, stackInfo2){
            final /* synthetic */ Instruction $getFuncInst;
            final /* synthetic */ RuntimeMemoryTotal $total;
            final /* synthetic */ int $depth;
            {
                this.$getFuncInst = $getFuncInst;
                this.$total = $total;
                this.$depth = $depth;
                super($super_call_param$1);
            }

            protected void execute0(@NotNull ActionContext ctx, @NotNull Execution exec) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
                if (this.$getFuncInst instanceof FunctionInstance) {
                    ((FunctionInstance)this.$getFuncInst).setCtxBuilder((Function1<? super ActionContext, ActionContext>)((Function1)new Function1<ActionContext, ActionContext>(this.$total){
                        final /* synthetic */ RuntimeMemoryTotal $total;
                        {
                            this.$total = $total;
                            super(1);
                        }

                        @NotNull
                        public final ActionContext invoke(@NotNull ActionContext it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return new ActionContext(this.$total, it);
                        }
                    }));
                    this.$getFuncInst.execute(ctx, exec);
                } else {
                    this.$getFuncInst.execute(ctx, exec);
                    Object object = exec.getValues().getRefValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type vjson.pl.inst.Instruction");
                    }
                    Instruction func = (Instruction)object;
                    ActionContext newCtx = new ActionContext(this.$total, ctx.getContext(this.$depth));
                    func.execute(newCtx, exec);
                }
            }
        };
    }
}

