/*
 * Decompiled with CFR 0.152.
 */
package vjson.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.Stringifier;
import vjson.cs.LineCol;
import vjson.parser.TrustedFlag;
import vjson.pl.ScriptifyContext;
import vjson.simple.AbstractSimpleInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003B#\b\u0016\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B+\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\nB#\b\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB+\b\u0014\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0002\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eB#\b\u0014\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0002\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\u0015\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lvjson/simple/SimpleArray;", "Lvjson/simple/AbstractSimpleInstance;", "", "Lvjson/JSON$Array;", "list", "", "Lvjson/JSON$Instance;", "([Lvjson/JSON$Instance;)V", "lineCol", "Lvjson/cs/LineCol;", "(Lvjson/cs/LineCol;[Lvjson/JSON$Instance;)V", "(Ljava/util/List;Lvjson/cs/LineCol;)V", "flag", "Lvjson/parser/TrustedFlag;", "(Ljava/util/List;Lvjson/parser/TrustedFlag;Lvjson/cs/LineCol;)V", "Lvjson/util/TrustedFlag;", "(Ljava/util/List;Lvjson/util/TrustedFlag;)V", "_toJavaObject", "", "_toString", "", "equals", "", "other", "get", "idx", "", "hashCode", "length", "scriptify", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ctx", "Lvjson/pl/ScriptifyContext;", "stringify", "sfr", "Lvjson/Stringifier;", "toJavaObject", "vjson"})
public class SimpleArray
extends AbstractSimpleInstance<List<?>>
implements JSON.Array {
    @NotNull
    private final List<JSON.Instance<?>> list;
    @NotNull
    private final LineCol lineCol;

    public SimpleArray(JSON.Instance<?> ... list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(list, list.length)), null, 2, null);
    }

    public SimpleArray(@NotNull LineCol lineCol, JSON.Instance<?> ... list) {
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(list, list.length)), lineCol);
    }

    @JvmOverloads
    public SimpleArray(@NotNull List<? extends JSON.Instance<?>> list, @NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        for (JSON.Instance<?> inst : list) {
            boolean bl = false;
            boolean bl2 = false;
            if (inst != null) continue;
            boolean bl3 = false;
            String string = "element should not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.list = new ArrayList(list);
        this.lineCol = lineCol;
    }

    public /* synthetic */ SimpleArray(List list, LineCol lineCol, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lineCol = LineCol.Companion.getEMPTY();
        }
        this(list, lineCol);
    }

    protected SimpleArray(@NotNull List<? extends JSON.Instance<?>> list, @Nullable TrustedFlag flag, @NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        if (flag == null) {
            throw new UnsupportedOperationException();
        }
        this.list = list;
        this.lineCol = lineCol;
    }

    protected SimpleArray(@NotNull List<? extends JSON.Instance<?>> list, @Nullable vjson.util.TrustedFlag flag) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (flag == null) {
            throw new UnsupportedOperationException();
        }
        this.list = list;
        this.lineCol = LineCol.Companion.getEMPTY();
    }

    @Override
    @NotNull
    public List<Object> toJavaObject() {
        return new ArrayList((Collection)super.toJavaObject());
    }

    @Override
    @NotNull
    protected List<Object> _toJavaObject() {
        List javaObject = new ArrayList();
        for (JSON.Instance<?> inst : this.list) {
            javaObject.add(inst.toJavaObject());
        }
        return javaObject;
    }

    @Override
    public void stringify(@NotNull StringBuilder builder, @NotNull Stringifier sfr) {
        int n;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sfr, (String)"sfr");
        sfr.beforeArrayBegin(builder, this);
        builder.append("[");
        sfr.afterArrayBegin(builder, this);
        Collection collection = this.list;
        int n2 = 0;
        if (!collection.isEmpty()) {
            JSON.Instance<?> inst = this.list.get(0);
            sfr.beforeArrayValue(builder, this, inst);
            inst.stringify(builder, sfr);
            sfr.afterArrayValue(builder, this, inst);
        }
        if ((n = 1) < (n2 = this.list.size())) {
            do {
                int i = n++;
                sfr.beforeArrayComma(builder, this);
                builder.append(",");
                sfr.afterArrayComma(builder, this);
                JSON.Instance<?> inst = this.list.get(i);
                sfr.beforeArrayValue(builder, this, inst);
                inst.stringify(builder, sfr);
                sfr.afterArrayValue(builder, this, inst);
            } while (n < n2);
        }
        sfr.beforeArrayEnd(builder, this);
        builder.append("]");
        sfr.afterArrayEnd(builder, this);
    }

    @Override
    public void scriptify(@NotNull StringBuilder builder, @NotNull ScriptifyContext ctx) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.list.size() <= 5) {
            builder.append("[");
            boolean isFirst = true;
            for (JSON.Instance<?> e : this.list) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(", ");
                }
                e.scriptify(builder, ctx);
            }
            builder.append("]");
        } else {
            builder.append("[\n");
            ctx.increaseIndent();
            for (JSON.Instance<?> e : this.list) {
                ctx.appendIndent(builder);
                e.scriptify(builder, ctx);
                builder.append("\n");
            }
            ctx.decreaseIndent();
            ctx.appendIndent(builder);
            builder.append("]");
        }
    }

    @Override
    @NotNull
    protected String _toString() {
        int n;
        StringBuilder sb = new StringBuilder();
        sb.append("Array[");
        Collection collection = this.list;
        int n2 = 0;
        if (!collection.isEmpty()) {
            sb.append(this.list.get(0));
        }
        if ((n = 1) < (n2 = this.list.size())) {
            do {
                int i = n++;
                sb.append(", ").append(this.list.get(i));
            } while (n < n2);
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public int length() {
        return this.list.size();
    }

    @Override
    @NotNull
    public JSON.Instance<?> get(int idx) throws IndexOutOfBoundsException {
        return this.list.get(idx);
    }

    @Override
    @NotNull
    public LineCol lineCol() {
        return this.lineCol;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSON.Array)) {
            return false;
        }
        if (((JSON.Array)other).length() != this.length()) {
            return false;
        }
        int n = 0;
        int len = this.length();
        if (n < len) {
            do {
                int i;
                if (Intrinsics.areEqual(((JSON.Array)other).get(i = n++), this.get(i))) continue;
                return false;
            } while (n < len);
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @JvmOverloads
    public SimpleArray(@NotNull List<? extends JSON.Instance<?>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this(list, null, 2, null);
    }
}

