/*
 * Decompiled with CFR 0.152.
 */
package vjson.simple;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.Stringifier;
import vjson.cs.LineCol;
import vjson.pl.ScriptifyContext;
import vjson.simple.AbstractSimpleInstance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lvjson/simple/SimpleExp;", "Lvjson/simple/AbstractSimpleInstance;", "", "Lvjson/JSON$Exp;", "base", "exponent", "", "lineCol", "Lvjson/cs/LineCol;", "(DILvjson/cs/LineCol;)V", "value", "_toJavaObject", "()Ljava/lang/Double;", "_toString", "", "doubleValue", "equals", "", "other", "", "hashCode", "scriptify", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ctx", "Lvjson/pl/ScriptifyContext;", "stringify", "sfr", "Lvjson/Stringifier;", "vjson"})
public final class SimpleExp
extends AbstractSimpleInstance<Double>
implements JSON.Exp {
    private final double base;
    private final int exponent;
    @NotNull
    private final LineCol lineCol;
    private final double value;

    @JvmOverloads
    public SimpleExp(double base, int exponent, @NotNull LineCol lineCol) {
        Intrinsics.checkNotNullParameter((Object)lineCol, (String)"lineCol");
        this.base = base;
        this.exponent = exponent;
        this.lineCol = lineCol;
        double d = 10.0;
        double d2 = this.exponent;
        boolean bl = false;
        this.value = this.base * Math.pow(d, d2);
    }

    public /* synthetic */ SimpleExp(double d, int n, LineCol lineCol, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            lineCol = LineCol.Companion.getEMPTY();
        }
        this(d, n, lineCol);
    }

    @Override
    @NotNull
    public Double _toJavaObject() {
        return this.value;
    }

    @Override
    public void stringify(@NotNull StringBuilder builder, @NotNull Stringifier sfr) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sfr, (String)"sfr");
        builder.append(this.base).append("e").append(this.exponent);
    }

    @Override
    public void scriptify(@NotNull StringBuilder builder, @NotNull ScriptifyContext ctx) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        builder.append(this.stringify());
    }

    @Override
    @NotNull
    public LineCol lineCol() {
        return this.lineCol;
    }

    @Override
    @NotNull
    protected String _toString() {
        return "Exp(" + this.base + 'e' + this.exponent + '=' + this.value + ')';
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public double base() {
        return this.base;
    }

    @Override
    public int exponent() {
        return this.exponent;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSON.Double)) {
            return false;
        }
        return Double.compare(((JSON.Double)other).doubleValue(), this.doubleValue()) == 0;
    }

    public int hashCode() {
        int result = Double.hashCode(this.base);
        result = 31 * result + this.exponent;
        result = 31 * result + Double.hashCode(this.value);
        return result;
    }

    @JvmOverloads
    public SimpleExp(double base, int exponent) {
        this(base, exponent, null, 4, null);
    }
}

