/*
 * Decompiled with CFR 0.152.
 */
package vjson.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.simple.SimpleArray;
import vjson.simple.SimpleBool;
import vjson.simple.SimpleDouble;
import vjson.simple.SimpleExp;
import vjson.simple.SimpleInteger;
import vjson.simple.SimpleLong;
import vjson.simple.SimpleNull;
import vjson.simple.SimpleString;
import vjson.util.ObjectBuilder;
import vjson.util.TrustedFlag;
import vjson.util.functional.BiConsumer_;
import vjson.util.functional.Consumer_;
import vjson.util.functional.Supplier_;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001f\u0010\u0013\u001a\u00020\u00002\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017J\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018J\u0012\u0010\u0019\u001a\u00020\u00002\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0005J \u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\b2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u001eJ \u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\b2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u001fJ\u001f\u0010 \u001a\u00020\u00002\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017J\u0014\u0010 \u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020!0\u0018J\u0006\u0010\"\u001a\u00020#J9\u0010$\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\u001d\u0010(\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u00160)\u00a2\u0006\u0002\b\u0017J.\u0010$\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H%0*R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lvjson/util/ArrayBuilder;", "", "()V", "list", "", "Lvjson/JSON$Instance;", "add", "bool", "", "doubleV", "", "num", "exponent", "", "integer", "longV", "", "string", "", "addArray", "func", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "Lvjson/util/functional/Consumer_;", "addInst", "inst", "addNullableInst", "isNull", "instSupplier", "Lkotlin/Function0;", "Lvjson/util/functional/Supplier_;", "addObject", "Lvjson/util/ObjectBuilder;", "build", "Lvjson/JSON$Array;", "iterable", "T", "ite", "", "operator", "Lkotlin/Function2;", "Lvjson/util/functional/BiConsumer_;", "vjson"})
public final class ArrayBuilder {
    @NotNull
    private final List<JSON.Instance<?>> list = new ArrayList();

    @NotNull
    public final ArrayBuilder addInst(@NotNull JSON.Instance<?> inst) {
        Intrinsics.checkNotNullParameter(inst, (String)"inst");
        this.list.add(inst);
        return this;
    }

    @NotNull
    public final ArrayBuilder addNullableInst(boolean isNull, @NotNull Function0<? extends JSON.Instance<?>> instSupplier) {
        Intrinsics.checkNotNullParameter(instSupplier, (String)"instSupplier");
        if (isNull) {
            return this.add(null);
        }
        return this.addInst((JSON.Instance)instSupplier.invoke());
    }

    @NotNull
    public final ArrayBuilder addNullableInst(boolean isNull, @NotNull Supplier_<JSON.Instance<?>> instSupplier) {
        Intrinsics.checkNotNullParameter(instSupplier, (String)"instSupplier");
        return this.addNullableInst(isNull, (Function0)instSupplier);
    }

    @NotNull
    public final ArrayBuilder add(boolean bool) {
        return this.addInst(new SimpleBool(bool, null, 2, null));
    }

    @NotNull
    public final ArrayBuilder add(int integer) {
        return this.addInst(new SimpleInteger(integer, null, 2, null));
    }

    @NotNull
    public final ArrayBuilder add(long longV) {
        return this.addInst(new SimpleLong(longV, null, 2, null));
    }

    @NotNull
    public final ArrayBuilder add(double doubleV) {
        return this.addInst(new SimpleDouble(doubleV, null, 2, null));
    }

    @NotNull
    public final ArrayBuilder add(double num, int exponent) {
        return this.addInst(new SimpleExp(num, exponent, null, 4, null));
    }

    @NotNull
    public final ArrayBuilder add(@Nullable String string) {
        if (string == null) {
            return this.addInst(new SimpleNull(null, 1, null));
        }
        return this.addInst(new SimpleString(string, null, 2, null));
    }

    @NotNull
    public final ArrayBuilder addObject(@NotNull Function1<? super ObjectBuilder, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        ObjectBuilder builder = new ObjectBuilder();
        func.invoke((Object)builder);
        return this.addInst(builder.build());
    }

    @NotNull
    public final ArrayBuilder addObject(@NotNull Consumer_<ObjectBuilder> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.addObject((Function1<? super ObjectBuilder, Unit>)func);
    }

    @NotNull
    public final ArrayBuilder addArray(@NotNull Function1<? super ArrayBuilder, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        ArrayBuilder builder = new ArrayBuilder();
        func.invoke((Object)builder);
        return this.addInst(builder.build());
    }

    @NotNull
    public final ArrayBuilder addArray(@NotNull Consumer_<ArrayBuilder> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.addArray((Function1<? super ArrayBuilder, Unit>)func);
    }

    @NotNull
    public final <T> ArrayBuilder iterable(@NotNull Iterable<? extends T> ite, @NotNull Function2<? super ArrayBuilder, ? super T, Unit> operator) {
        Intrinsics.checkNotNullParameter(ite, (String)"ite");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        for (T e : ite) {
            operator.invoke((Object)this, e);
        }
        return this;
    }

    @NotNull
    public final <T> ArrayBuilder iterable(@NotNull Iterable<? extends T> ite, @NotNull BiConsumer_<ArrayBuilder, T> operator) {
        Intrinsics.checkNotNullParameter(ite, (String)"ite");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        return this.iterable(ite, (Function2)operator);
    }

    @NotNull
    public final JSON.Array build() {
        List<JSON.Instance<?>> list = this.list;
        TrustedFlag trustedFlag = TrustedFlag.FLAG;
        return new SimpleArray(list, trustedFlag){};
    }
}

