/*
 * Decompiled with CFR 0.152.
 */
package vjson.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.JSON;
import vjson.simple.SimpleBool;
import vjson.simple.SimpleDouble;
import vjson.simple.SimpleExp;
import vjson.simple.SimpleInteger;
import vjson.simple.SimpleLong;
import vjson.simple.SimpleNull;
import vjson.simple.SimpleObject;
import vjson.simple.SimpleObjectEntry;
import vjson.simple.SimpleString;
import vjson.util.ArrayBuilder;
import vjson.util.TrustedFlag;
import vjson.util.functional.Consumer_;
import vjson.util.functional.Supplier_;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B \b\u0016\u0012\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0019J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012J'\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\b\u0006J\u001c\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0!J\u001a\u0010\"\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000eJ(\u0010$\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00142\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0'J(\u0010$\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00142\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0(J'\u0010)\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\b\u0006J\u001c\u0010)\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000!J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0012J\u0012\u0010*\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,R\u001e\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lvjson/util/ObjectBuilder;", "", "()V", "f", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "o", "Lvjson/JSON$Object;", "(Lvjson/JSON$Object;)V", "map", "", "Lvjson/simple/SimpleObjectEntry;", "Lvjson/JSON$Instance;", "build", "put", "key", "", "bool", "", "doubleV", "", "num", "exponent", "", "integer", "longV", "", "string", "putArray", "func", "Lvjson/util/ArrayBuilder;", "Lvjson/util/functional/Consumer_;", "putInst", "inst", "putNullableInst", "isNull", "instSupplier", "Lkotlin/Function0;", "Lvjson/util/functional/Supplier_;", "putObject", "type", "aClass", "Lkotlin/reflect/KClass;", "vjson"})
public final class ObjectBuilder {
    @NotNull
    private final List<SimpleObjectEntry<JSON.Instance<?>>> map;

    public ObjectBuilder() {
        this.map = new ArrayList();
    }

    public ObjectBuilder(@NotNull Function1<? super ObjectBuilder, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.map = new ArrayList();
        f.invoke((Object)this);
    }

    public ObjectBuilder(@NotNull JSON.Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.map = new ArrayList();
        for (JSON.ObjectEntry entry : o.entryList()) {
            this.putInst(entry.getKey(), entry.getValue());
        }
    }

    @NotNull
    public final ObjectBuilder putInst(@NotNull String key, @NotNull JSON.Instance<?> inst) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(inst, (String)"inst");
        if (Intrinsics.areEqual((Object)key, (Object)"@type")) {
            this.map.add(0, new SimpleObjectEntry(key, inst, null, 4, null));
        } else {
            this.map.add(new SimpleObjectEntry(key, inst, null, 4, null));
        }
        return this;
    }

    @NotNull
    public final ObjectBuilder putNullableInst(@NotNull String key, boolean isNull, @NotNull Function0<? extends JSON.Instance<?>> instSupplier) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(instSupplier, (String)"instSupplier");
        if (isNull) {
            return this.put(key, null);
        }
        return this.putInst(key, (JSON.Instance)instSupplier.invoke());
    }

    @NotNull
    public final ObjectBuilder putNullableInst(@NotNull String key, boolean isNull, @NotNull Supplier_<JSON.Instance<?>> instSupplier) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(instSupplier, (String)"instSupplier");
        return this.putNullableInst(key, isNull, (Function0)instSupplier);
    }

    @NotNull
    public final ObjectBuilder put(@NotNull String key, boolean bool) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.putInst(key, new SimpleBool(bool, null, 2, null));
    }

    @NotNull
    public final ObjectBuilder put(@NotNull String key, int integer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.putInst(key, new SimpleInteger(integer, null, 2, null));
    }

    @NotNull
    public final ObjectBuilder put(@NotNull String key, long longV) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.putInst(key, new SimpleLong(longV, null, 2, null));
    }

    @NotNull
    public final ObjectBuilder put(@NotNull String key, double doubleV) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.putInst(key, new SimpleDouble(doubleV, null, 2, null));
    }

    @NotNull
    public final ObjectBuilder put(@NotNull String key, double num, int exponent) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.putInst(key, new SimpleExp(num, exponent, null, 4, null));
    }

    @NotNull
    public final ObjectBuilder put(@NotNull String key, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (string == null) {
            return this.putInst(key, new SimpleNull(null, 1, null));
        }
        return this.putInst(key, new SimpleString(string, null, 2, null));
    }

    @NotNull
    public final ObjectBuilder putObject(@NotNull String key, @NotNull Function1<? super ObjectBuilder, Unit> func) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        ObjectBuilder builder = new ObjectBuilder();
        func.invoke((Object)builder);
        return this.putInst(key, builder.build());
    }

    @NotNull
    public final ObjectBuilder putObject(@NotNull String key, @NotNull Consumer_<ObjectBuilder> func) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.putObject(key, (Function1<? super ObjectBuilder, Unit>)func);
    }

    @NotNull
    public final ObjectBuilder putArray(@NotNull String key, @NotNull Function1<? super ArrayBuilder, Unit> func) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        ArrayBuilder builder = new ArrayBuilder();
        func.invoke((Object)builder);
        return this.putInst(key, builder.build());
    }

    @NotNull
    public final ObjectBuilder putArray(@NotNull String key, @NotNull Consumer_<ArrayBuilder> func) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.putArray(key, (Function1<? super ArrayBuilder, Unit>)func);
    }

    @NotNull
    public final ObjectBuilder type(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.putInst("@type", new SimpleString(type, null, 2, null));
    }

    @NotNull
    public final ObjectBuilder type(@NotNull KClass<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        String string = aClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return this.type(string);
    }

    @NotNull
    public final JSON.Object build() {
        List<SimpleObjectEntry<JSON.Instance<?>>> list = this.map;
        TrustedFlag trustedFlag = TrustedFlag.FLAG;
        return new SimpleObject(list, trustedFlag){};
    }
}

