/*
 * Decompiled with CFR 0.152.
 */
package vjson.util.collection;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.util.CastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0010\u001a\u00020\nJ\u000b\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u000b\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0007J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lvjson/util/collection/VList;", "E", "", "()V", "head", "Lvjson/util/collection/VList$Node;", "size", "", "tail", "add", "", "e", "(Ljava/lang/Object;)V", "index", "(ILjava/lang/Object;)V", "addFirst", "clear", "first", "()Ljava/lang/Object;", "get", "(I)Ljava/lang/Object;", "isEmpty", "", "last", "removeFirst", "n", "removeLast", "toString", "", "Node", "vjson"})
public final class VList<E> {
    @Nullable
    private Node<E> head;
    @Nullable
    private Node<E> tail;
    private int size;

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index, E e) {
        void startInclusive$iv;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index = " + index + " < 0");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("index = " + index + " > size = " + this.size);
        }
        if (index == 0) {
            this.addFirst(e);
            return;
        }
        if (index == this.size()) {
            this.add(e);
            return;
        }
        Node<E> n = null;
        Node<E> node = this.head;
        Intrinsics.checkNotNull(node);
        n = node;
        Object object = CastUtils.INSTANCE;
        boolean bl = false;
        int endExclusive$iv = index - 1;
        boolean $i$f$forIndex = false;
        void var8_8 = startInclusive$iv;
        if (var8_8 < endExclusive$iv) {
            do {
                void i$iv;
                void it = i$iv = var8_8++;
                boolean bl2 = false;
                Intrinsics.checkNotNull(n.getNext());
            } while (var8_8 < endExclusive$iv);
        }
        new Node<E>(n, e);
        object = this;
        ++((VList)object).size;
        int cfr_ignored_0 = ((VList)object).size;
    }

    public final void add(E e) {
        Node<E> n = new Node<E>(this.tail, e);
        if (this.tail == null) {
            this.head = n;
        }
        this.tail = n;
        VList vList = this;
        ++vList.size;
        int cfr_ignored_0 = vList.size;
    }

    public final void addFirst(E e) {
        Node<E> n = new Node<E>(null, e);
        Node<E> head = this.head;
        if (head == null) {
            this.tail = n;
        } else {
            n.setNext(head);
            head.setPrev(n);
        }
        this.head = n;
        VList vList = this;
        ++vList.size;
        int cfr_ignored_0 = vList.size;
    }

    public final E first() {
        Node<E> node = this.head;
        if (node == null) {
            throw new NoSuchElementException();
        }
        Node<E> head = node;
        return head.getElement();
    }

    public final E last() {
        Node<E> node = this.tail;
        if (node == null) {
            throw new NoSuchElementException();
        }
        Node<E> tail = node;
        return tail.getElement();
    }

    public final E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index = " + index + " < 0");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index = " + index + " >= size = " + this.size);
        }
        Node<E> node = this.head;
        Intrinsics.checkNotNull(node);
        Node<E> n = node;
        int n2 = 0;
        if (n2 < index) {
            do {
                int i = n2++;
                Intrinsics.checkNotNull(n.getNext());
            } while (n2 < index);
        }
        return n.getElement();
    }

    public final E removeLast() {
        Node<E> node = this.tail;
        if (node == null) {
            throw new NoSuchElementException();
        }
        Node<E> removed = node;
        Node prev = removed.getPrev();
        this.tail = prev;
        if (prev == null) {
            this.head = null;
        } else {
            prev.setNext(null);
        }
        VList vList = this;
        --vList.size;
        return removed.getElement();
    }

    public final E removeFirst() {
        Node<E> node = this.head;
        if (node == null) {
            throw new NoSuchElementException();
        }
        Node<E> removed = node;
        Node next = removed.getNext();
        this.head = next;
        if (next == null) {
            this.tail = null;
        } else {
            next.setPrev(null);
        }
        VList vList = this;
        --vList.size;
        return removed.getElement();
    }

    public final void removeFirst(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("remove = " + n + " > size = " + this.size);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"remove = ", (Object)n));
        }
        int n2 = 0;
        if (n2 < n) {
            do {
                int i = n2++;
                this.removeFirst();
            } while (n2 < n);
        }
    }

    public final void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        Node<E> node = this.head;
        if (node != null) {
            sb.append(node.getElement());
            for (node = node.getNext(); node != null; node = node.getNext()) {
                sb.append(", ").append(node.getElement());
            }
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0010\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Lvjson/util/collection/VList$Node;", "E", "", "prev", "element", "(Lvjson/util/collection/VList$Node;Ljava/lang/Object;)V", "getElement", "()Ljava/lang/Object;", "Ljava/lang/Object;", "next", "getNext", "()Lvjson/util/collection/VList$Node;", "setNext", "(Lvjson/util/collection/VList$Node;)V", "getPrev$annotations", "()V", "getPrev", "setPrev", "vjson"})
    private static final class Node<E> {
        private final E element;
        @Nullable
        private Node<E> prev;
        @Nullable
        private Node<E> next;

        public Node(@Nullable Node<E> prev, E element) {
            this.element = element;
            this.prev = prev;
            if (prev != null) {
                Node<E> next = prev.next;
                if (next != null) {
                    this.next = next;
                    next.prev = this;
                }
                prev.next = this;
            }
        }

        public final E getElement() {
            return this.element;
        }

        @Nullable
        public final Node<E> getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Node<E> node) {
            this.prev = node;
        }

        public static /* synthetic */ void getPrev$annotations() {
        }

        @Nullable
        public final Node<E> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Node<E> node) {
            this.next = node;
        }
    }
}

