/*
 * Decompiled with CFR 0.152.
 */
package vpreprocessor;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vjson.CharStream;
import vjson.ex.ParserException;
import vpreprocessor.Preprocessor;
import vpreprocessor.PreprocessorContext;
import vpreprocessor.PreprocessorOptions;
import vpreprocessor.ProcessParams;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lvpreprocessor/FilePreprocessor;", "", "()V", "extensionMap", "", "", "Lvpreprocessor/PreprocessorOptions;", "process", "", "relativePath", "dir", "Ljava/io/File;", "params", "Lvpreprocessor/ProcessParams;", "rootDir", "processFile", "file", "read", "vjson"})
public final class FilePreprocessor {
    @NotNull
    public static final FilePreprocessor INSTANCE = new FilePreprocessor();
    @NotNull
    private static final Map<String, PreprocessorOptions> extensionMap = new HashMap();

    private FilePreprocessor() {
    }

    @JvmStatic
    public static final void process(@NotNull String rootDir, @NotNull ProcessParams params) throws IOException, ParserException {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        File rootDirFile = new File(rootDir);
        if (!rootDirFile.isDirectory()) {
            throw new IOException("$rootDir is not a directory");
        }
        INSTANCE.process("", rootDirFile, params);
    }

    private final void process(String relativePath, File dir, ProcessParams params) throws IOException, ParserException {
        File[] ls;
        File[] fileArray = dir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File f : ls = fileArray) {
            String nextPath = relativePath + '/' + f.getName();
            if (!f.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
            this.process(nextPath, f, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processFile(String relativePath, File file, ProcessParams params) throws IOException, ParserException {
        PreprocessorOptions opts = null;
        Object object = extensionMap;
        boolean bl = false;
        Iterator<Map.Entry<String, PreprocessorOptions>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String ext = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            PreprocessorOptions o = (PreprocessorOptions)object3.getValue();
            object3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"file.name");
            if (!StringsKt.endsWith$default((String)object3, (String)Intrinsics.stringPlus((String)".", (Object)ext), (boolean)false, (int)2, null)) continue;
            opts = o;
            break;
        }
        if (opts == null) {
            return;
        }
        if (!((Boolean)params.getPathFilter().invoke((Object)relativePath)).booleanValue()) {
            return;
        }
        params.getCurrentFile().invoke((Object)relativePath);
        String content = this.read(file);
        PreprocessorContext ctx = new PreprocessorContext(opts);
        params.getContextInitializer().invoke((Object)ctx);
        Preprocessor preprocessor = new Preprocessor(ctx);
        StringBuilder builder = new StringBuilder();
        preprocessor.process(CharStream.Companion.from(content), builder);
        Object object4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"builder.toString()");
        String result = object4;
        object4 = new FileOutputStream(file);
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            FileOutputStream output = (FileOutputStream)object4;
            boolean bl6 = false;
            String string = result;
            Charset charset = Charsets.UTF_8;
            boolean bl7 = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            output.write(byArray);
            output.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String read(File file) throws IOException {
        Closeable closeable = new FileReader(file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            int sz;
            FileReader reader = (FileReader)closeable;
            boolean bl3 = false;
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder();
            while ((sz = reader.read(cbuf)) >= 0) {
                sb.append(cbuf, 0, sz);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Map<String, PreprocessorOptions> map = extensionMap;
        String string = "kt";
        PreprocessorOptions preprocessorOptions = PreprocessorOptions.KT;
        boolean bl = false;
        map.put(string, preprocessorOptions);
        map = extensionMap;
        string = "java";
        preprocessorOptions = PreprocessorOptions.JAVA;
        bl = false;
        map.put(string, preprocessorOptions);
    }
}

