/*
 * Decompiled with CFR 0.152.
 */
package vpreprocessor;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vjson.CharStream;
import vjson.ex.ParserException;
import vjson.parser.ParserUtils;
import vpreprocessor.PreprocessorOptions;
import vpreprocessor.token.EOFToken;
import vpreprocessor.token.Macro;
import vpreprocessor.token.Plain;
import vpreprocessor.token.Token;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001:\u00042345B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\"\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010'\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020$H\u0002J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020,J\b\u0010.\u001a\u00020\u0012H\u0002J \u0010/\u001a\u00060\u000fj\u0002`\u0010*\u00060\u000fj\u0002`\u00102\n\u00100\u001a\u00060\u000fj\u0002`\u0010H\u0002J\u0010\u00101\u001a\u00020,*\u00060\u000fj\u0002`\u0010H\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lvpreprocessor/Tokenizer;", "", "opts", "Lvpreprocessor/PreprocessorOptions;", "(Lvpreprocessor/PreprocessorOptions;)V", "<set-?>", "", "commentStackDepth", "getCommentStackDepth", "()I", "Lvpreprocessor/Tokenizer$MacroState;", "macroState", "getMacroState", "()Lvpreprocessor/Tokenizer$MacroState;", "pendingTexts", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "stringIsSingleQuote", "", "Lvpreprocessor/Tokenizer$TextState;", "textState", "getTextState", "()Lvpreprocessor/Tokenizer$TextState;", "texts", "beginMacro", "", "checkAndResumeMacro", "commentEnds", "Lvpreprocessor/Tokenizer$TokenType;", "multiLineComment", "c", "", "res", "Lvpreprocessor/Tokenizer$FeedExtraResult;", "commentEndsForMacro", "feed", "Lvpreprocessor/token/Token;", "cs", "Lvjson/CharStream;", "feedMacro", "generateToken", "type", "generateTokenForEOF", "getPendingTexts", "", "getTexts", "noMacro", "merge", "builder", "toStringAndClear", "FeedExtraResult", "MacroState", "TextState", "TokenType", "vjson"})
public final class Tokenizer {
    @NotNull
    private final PreprocessorOptions opts;
    @NotNull
    private final StringBuilder texts;
    @NotNull
    private final StringBuilder pendingTexts;
    @NotNull
    private TextState textState;
    private int commentStackDepth;
    private boolean stringIsSingleQuote;
    @NotNull
    private MacroState macroState;

    public Tokenizer(@NotNull PreprocessorOptions opts) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.opts = opts;
        this.texts = new StringBuilder();
        this.pendingTexts = new StringBuilder();
        this.textState = TextState.INIT;
        this.macroState = MacroState.INIT;
    }

    @NotNull
    public final String getTexts() {
        String string = this.texts.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"texts.toString()");
        return string;
    }

    @NotNull
    public final String getPendingTexts() {
        String string = this.pendingTexts.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pendingTexts.toString()");
        return string;
    }

    @NotNull
    public final TextState getTextState() {
        return this.textState;
    }

    public final int getCommentStackDepth() {
        return this.commentStackDepth;
    }

    private final TokenType feed(CharStream cs, char c, FeedExtraResult res) {
        TextState textState = this.textState;
        int n = WhenMappings.$EnumSwitchMapping$0[textState.ordinal()];
        switch (n) {
            case 1: {
                char c2 = c;
                if (c2 == '/') {
                    if (cs.hasNext(2)) {
                        char c3;
                        char nx = cs.peekNext(2);
                        if (nx == '/' || nx == '*') {
                            cs.moveNextAndGet();
                        }
                        if ((c3 = nx) == '/') {
                            this.pendingTexts.append("//");
                            this.textState = TextState.SINGLE_LINE_COMMENT;
                            this.checkAndResumeMacro();
                        } else if (c3 == '*') {
                            this.pendingTexts.append("/*");
                            this.textState = TextState.MULTI_LINE_COMMENT;
                            Tokenizer tokenizer = this;
                            ++tokenizer.commentStackDepth;
                            int cfr_ignored_0 = tokenizer.commentStackDepth;
                            this.checkAndResumeMacro();
                        } else {
                            this.texts.append(c);
                        }
                    } else {
                        this.texts.append(c);
                    }
                    return null;
                }
                if (c2 == '\"') {
                    if (cs.hasNext(2)) {
                        char nx = cs.peekNext(2);
                        if (nx == '\"') {
                            if (cs.hasNext(3)) {
                                char nx22 = cs.peekNext(3);
                                if (nx22 == '\"') {
                                    cs.moveNextAndGet();
                                    cs.moveNextAndGet();
                                    this.textState = TextState.MULTI_LINE_STRING;
                                    this.texts.append("\"\"\"");
                                } else {
                                    cs.moveNextAndGet();
                                    this.texts.append("\"\"");
                                }
                            } else {
                                cs.moveNextAndGet();
                                this.texts.append("\"\"");
                            }
                        } else {
                            this.stringIsSingleQuote = false;
                            this.textState = TextState.SINGLE_LINE_STRING;
                            this.texts.append(c);
                        }
                    } else {
                        this.stringIsSingleQuote = false;
                        this.textState = TextState.SINGLE_LINE_STRING;
                        this.texts.append(c);
                    }
                    return null;
                }
                if (c2 == '\'') {
                    this.stringIsSingleQuote = true;
                    this.textState = TextState.SINGLE_LINE_STRING;
                    this.texts.append(c);
                    return null;
                }
                this.texts.append(c);
                return null;
            }
            case 2: {
                char c4 = c;
                if (c4 == '\r' ? true : c4 == '\n') {
                    return this.commentEnds(false, c, res);
                }
                return this.feedMacro(cs, c, res);
            }
            case 3: {
                char nx;
                char c5 = c;
                if (c5 == '*') {
                    char nx2;
                    if (cs.hasNext(2) && (nx2 = cs.peekNext(2)) == '/') {
                        cs.moveNextAndGet();
                        if (this.commentStackDepth <= 1) {
                            this.commentStackDepth = 0;
                            return this.commentEnds(true, c, res);
                        }
                        Tokenizer nx22 = this;
                        nx22.commentStackDepth += -1;
                        int cfr_ignored_1 = nx22.commentStackDepth;
                        this.pendingTexts.append("*/");
                        return null;
                    }
                    return this.feedMacro(cs, c, res);
                }
                if (this.noMacro() && c == '/' && this.opts.getNestedComment() && cs.hasNext(2) && (nx = cs.peekNext(2)) == '*') {
                    Tokenizer nx22 = this;
                    ++nx22.commentStackDepth;
                    int cfr_ignored_2 = nx22.commentStackDepth;
                    cs.moveNextAndGet();
                    this.pendingTexts.append("/*");
                    this.macroState = MacroState.IGNORE;
                    return null;
                }
                return this.feedMacro(cs, c, res);
            }
            case 4: {
                char ending = this.stringIsSingleQuote ? (char)'\'' : '\"';
                char nx = c;
                if (nx == '\\') {
                    if (cs.hasNext(2)) {
                        char nx3 = cs.peekNext(2);
                        if (nx3 == ending) {
                            cs.moveNextAndGet();
                            this.texts.append("\\").append(ending);
                            return null;
                        }
                        this.texts.append(c).append(nx3);
                        cs.moveNextAndGet();
                        return null;
                    }
                    this.texts.append(c);
                    return null;
                }
                if (nx == ending) {
                    this.texts.append(c);
                    this.textState = TextState.INIT;
                    return null;
                }
                this.texts.append(c);
                return null;
            }
            case 5: {
                char c6 = c;
                if (c6 == '\"') {
                    char nx2;
                    char nx;
                    if (cs.hasNext(2) && (nx = cs.peekNext(2)) == '\"' && cs.hasNext(3) && (nx2 = cs.peekNext(3)) == '\"') {
                        cs.moveNextAndGet();
                        cs.moveNextAndGet();
                        this.texts.append("\"\"\"");
                        this.textState = TextState.INIT;
                        return null;
                    }
                    this.texts.append(c);
                    return null;
                }
                this.texts.append(c);
                return null;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final TokenType commentEnds(boolean multiLineComment, char c, FeedExtraResult res) {
        this.textState = TextState.INIT;
        if (this.noMacro()) {
            this.merge(this.texts, this.pendingTexts);
            if (multiLineComment) {
                this.texts.append("*/");
            } else {
                this.texts.append(c);
            }
        } else if (!multiLineComment) {
            res.setMoveCursor(false);
        }
        return this.commentEndsForMacro();
    }

    @NotNull
    public final MacroState getMacroState() {
        return this.macroState;
    }

    private final boolean noMacro() {
        return this.macroState == MacroState.INIT || this.macroState == MacroState.IGNORE;
    }

    private final TokenType commentEndsForMacro() {
        boolean noMacro = this.noMacro();
        if (this.macroState != MacroState.TEXT) {
            this.macroState = MacroState.INIT;
        }
        if (noMacro || this.macroState == MacroState.TEXT) {
            return null;
        }
        return TokenType.MACRO;
    }

    private final void checkAndResumeMacro() {
        if (this.macroState == MacroState.TEXT) {
            this.beginMacro();
            this.macroState = MacroState.TEXT;
        }
    }

    private final void beginMacro() {
        StringsKt.clear((StringBuilder)this.pendingTexts);
        this.macroState = MacroState.READING;
        if (this.commentStackDepth == 1) {
            Tokenizer tokenizer = this;
            tokenizer.commentStackDepth += -1;
            int cfr_ignored_0 = tokenizer.commentStackDepth;
        }
    }

    private final TokenType feedMacro(CharStream cs, char c, FeedExtraResult res) {
        MacroState macroState = this.macroState;
        int n = WhenMappings.$EnumSwitchMapping$1[macroState.ordinal()];
        switch (n) {
            case 1: {
                if (ParserUtils.isWhiteSpace(c)) {
                    this.pendingTexts.append(c);
                    return null;
                }
                if (c == '#') {
                    this.beginMacro();
                    return TokenType.PLAIN;
                }
                this.macroState = MacroState.IGNORE;
                this.pendingTexts.append(c);
                return null;
            }
            case 2: {
                if (ParserUtils.isWhiteSpace(c)) {
                    return null;
                }
                if (ParserUtils.isInitialVarName(c)) {
                    this.texts.append(c);
                    this.macroState = MacroState.READING_VAR;
                    return null;
                }
                if (c == '{') {
                    char nx;
                    if (cs.hasNext(2) && (nx = cs.peekNext(2)) == '{') {
                        cs.moveNextAndGet();
                        this.macroState = MacroState.TEXT;
                        this.texts.append("{{");
                        return TokenType.MACRO;
                    }
                    this.texts.append(c);
                    return TokenType.MACRO;
                }
                if (c == '}') {
                    this.texts.append(c);
                    return TokenType.MACRO;
                }
                throw new ParserException(Intrinsics.stringPlus((String)"unexpected character ", (Object)Character.valueOf(c)));
            }
            case 3: {
                if (ParserUtils.isVarName(c)) {
                    this.texts.append(c);
                    return null;
                }
                this.macroState = MacroState.READING;
                res.setMoveCursor(false);
                return TokenType.MACRO;
            }
            case 4: {
                char nx;
                if (c == '}' && cs.hasNext(2) && (nx = cs.peekNext(2)) == '}') {
                    this.macroState = MacroState.TEXT_END;
                    return TokenType.PLAIN;
                }
                this.texts.append(c);
                return null;
            }
            case 5: {
                this.macroState = MacroState.READING;
                this.texts.append("}}");
                return TokenType.MACRO;
            }
            case 6: {
                this.pendingTexts.append(c);
                return null;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final Token feed(@NotNull CharStream cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        FeedExtraResult res = new FeedExtraResult(true);
        while (cs.hasNext()) {
            char c = cs.peekNext();
            res.setMoveCursor(true);
            TokenType retType = this.feed(cs, c, res);
            if (res.getMoveCursor()) {
                cs.moveNextAndGet();
            }
            if (retType == null) continue;
            CharSequence charSequence = this.texts;
            boolean bl = false;
            if (!(charSequence.length() > 0)) continue;
            return this.generateToken(retType);
        }
        return this.generateTokenForEOF();
    }

    private final Token generateToken(TokenType type) {
        Token token;
        TokenType tokenType = type;
        int n = WhenMappings.$EnumSwitchMapping$2[tokenType.ordinal()];
        switch (n) {
            case 1: {
                token = new Plain(this.toStringAndClear(this.texts));
                break;
            }
            case 2: {
                token = new Macro(this.toStringAndClear(this.texts));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return token;
    }

    private final Token generateTokenForEOF() {
        this.merge(this.texts, this.pendingTexts);
        CharSequence charSequence = this.texts;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return new EOFToken();
        }
        if (this.noMacro() || this.macroState == MacroState.TEXT) {
            return this.generateToken(TokenType.PLAIN);
        }
        return this.generateToken(TokenType.MACRO);
    }

    private final StringBuilder merge(StringBuilder $this$merge, StringBuilder builder) {
        $this$merge.append((CharSequence)builder);
        StringsKt.clear((StringBuilder)builder);
        return $this$merge;
    }

    private final String toStringAndClear(StringBuilder $this$toStringAndClear) {
        String string = $this$toStringAndClear.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
        String str = string;
        StringsKt.clear((StringBuilder)$this$toStringAndClear);
        return str;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lvpreprocessor/Tokenizer$TextState;", "", "(Ljava/lang/String;I)V", "INIT", "SINGLE_LINE_COMMENT", "MULTI_LINE_COMMENT", "SINGLE_LINE_STRING", "MULTI_LINE_STRING", "vjson"})
    public static final class TextState
    extends Enum<TextState> {
        public static final /* enum */ TextState INIT = new TextState();
        public static final /* enum */ TextState SINGLE_LINE_COMMENT = new TextState();
        public static final /* enum */ TextState MULTI_LINE_COMMENT = new TextState();
        public static final /* enum */ TextState SINGLE_LINE_STRING = new TextState();
        public static final /* enum */ TextState MULTI_LINE_STRING = new TextState();
        private static final /* synthetic */ TextState[] $VALUES;

        public static TextState[] values() {
            return (TextState[])$VALUES.clone();
        }

        public static TextState valueOf(String value) {
            return Enum.valueOf(TextState.class, value);
        }

        static {
            $VALUES = textStateArray = new TextState[]{TextState.INIT, TextState.SINGLE_LINE_COMMENT, TextState.MULTI_LINE_COMMENT, TextState.SINGLE_LINE_STRING, TextState.MULTI_LINE_STRING};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lvpreprocessor/Tokenizer$MacroState;", "", "(Ljava/lang/String;I)V", "INIT", "READING", "READING_VAR", "TEXT", "TEXT_END", "IGNORE", "vjson"})
    public static final class MacroState
    extends Enum<MacroState> {
        public static final /* enum */ MacroState INIT = new MacroState();
        public static final /* enum */ MacroState READING = new MacroState();
        public static final /* enum */ MacroState READING_VAR = new MacroState();
        public static final /* enum */ MacroState TEXT = new MacroState();
        public static final /* enum */ MacroState TEXT_END = new MacroState();
        public static final /* enum */ MacroState IGNORE = new MacroState();
        private static final /* synthetic */ MacroState[] $VALUES;

        public static MacroState[] values() {
            return (MacroState[])$VALUES.clone();
        }

        public static MacroState valueOf(String value) {
            return Enum.valueOf(MacroState.class, value);
        }

        static {
            $VALUES = macroStateArray = new MacroState[]{MacroState.INIT, MacroState.READING, MacroState.READING_VAR, MacroState.TEXT, MacroState.TEXT_END, MacroState.IGNORE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lvpreprocessor/Tokenizer$TokenType;", "", "(Ljava/lang/String;I)V", "MACRO", "PLAIN", "vjson"})
    private static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType MACRO = new TokenType();
        public static final /* enum */ TokenType PLAIN = new TokenType();
        private static final /* synthetic */ TokenType[] $VALUES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        public static TokenType valueOf(String value) {
            return Enum.valueOf(TokenType.class, value);
        }

        static {
            $VALUES = tokenTypeArray = new TokenType[]{TokenType.MACRO, TokenType.PLAIN};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lvpreprocessor/Tokenizer$FeedExtraResult;", "", "moveCursor", "", "(Z)V", "getMoveCursor", "()Z", "setMoveCursor", "vjson"})
    private static final class FeedExtraResult {
        private boolean moveCursor;

        public FeedExtraResult(boolean moveCursor) {
            this.moveCursor = moveCursor;
        }

        public final boolean getMoveCursor() {
            return this.moveCursor;
        }

        public final void setMoveCursor(boolean bl) {
            this.moveCursor = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[TextState.values().length];
            nArray[TextState.INIT.ordinal()] = 1;
            nArray[TextState.SINGLE_LINE_COMMENT.ordinal()] = 2;
            nArray[TextState.MULTI_LINE_COMMENT.ordinal()] = 3;
            nArray[TextState.SINGLE_LINE_STRING.ordinal()] = 4;
            nArray[TextState.MULTI_LINE_STRING.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MacroState.values().length];
            nArray[MacroState.INIT.ordinal()] = 1;
            nArray[MacroState.READING.ordinal()] = 2;
            nArray[MacroState.READING_VAR.ordinal()] = 3;
            nArray[MacroState.TEXT.ordinal()] = 4;
            nArray[MacroState.TEXT_END.ordinal()] = 5;
            nArray[MacroState.IGNORE.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TokenType.values().length];
            nArray[TokenType.PLAIN.ordinal()] = 1;
            nArray[TokenType.MACRO.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

