/*
 * Decompiled with CFR 0.152.
 */
package vpreprocessor.ast;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vjson.ex.ParserException;
import vjson.util.CastUtils;
import vpreprocessor.PreprocessorContext;
import vpreprocessor.ast.AbstractAST;
import vpreprocessor.ast.Exp;
import vpreprocessor.ast.IfDef;
import vpreprocessor.ast.IfNotDef;
import vpreprocessor.ast.Statement;
import vpreprocessor.ast.StatementSeq;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0014\u0010\u0018\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0014\u0010\u001d\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\t\u0010\u001e\u001a\u00020\u001aH\u0082\bJ\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006!"}, d2={"Lvpreprocessor/ast/If;", "Lvpreprocessor/ast/AbstractAST;", "Lvpreprocessor/ast/Statement;", "context", "Lvpreprocessor/PreprocessorContext;", "condition", "Lvpreprocessor/ast/Exp;", "code", "Lvpreprocessor/ast/StatementSeq;", "elseCode", "(Lvpreprocessor/PreprocessorContext;Lvpreprocessor/ast/Exp;Lvpreprocessor/ast/StatementSeq;Lvpreprocessor/ast/StatementSeq;)V", "getCode", "()Lvpreprocessor/ast/StatementSeq;", "getCondition", "()Lvpreprocessor/ast/Exp;", "getContext", "()Lvpreprocessor/PreprocessorContext;", "getElseCode", "buildSyntaxString", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "buildSyntaxStringForElseBranch", "buildSyntaxStringForElseCode", "equals", "", "other", "", "exec", "execCondition", "hashCode", "", "vjson"})
public final class If
extends AbstractAST
implements Statement {
    @NotNull
    private final PreprocessorContext context;
    @NotNull
    private final Exp condition;
    @NotNull
    private final StatementSeq code;
    @Nullable
    private final StatementSeq elseCode;

    @JvmOverloads
    public If(@NotNull PreprocessorContext context, @NotNull Exp condition, @NotNull StatementSeq code, @Nullable StatementSeq elseCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.context = context;
        this.condition = condition;
        this.code = code;
        this.elseCode = elseCode;
    }

    public /* synthetic */ If(PreprocessorContext preprocessorContext, Exp exp, StatementSeq statementSeq, StatementSeq statementSeq2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            statementSeq2 = null;
        }
        this(preprocessorContext, exp, statementSeq, statementSeq2);
    }

    @Override
    @NotNull
    public PreprocessorContext getContext() {
        return this.context;
    }

    @NotNull
    public final Exp getCondition() {
        return this.condition;
    }

    @NotNull
    public final StatementSeq getCode() {
        return this.code;
    }

    @Nullable
    public final StatementSeq getElseCode() {
        return this.elseCode;
    }

    @Override
    public void exec(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        If this_$iv = this;
        boolean $i$f$execCondition = false;
        Object value$iv = this_$iv.getCondition().exec();
        CastUtils castUtils = CastUtils.INSTANCE;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
        boolean $i$f$check = false;
        if (!type$iv$iv.isInstance(value$iv)) {
            throw new ParserException("failed casting result of " + this_$iv.getCondition() + " (" + value$iv + ") to Boolean");
        }
        CastUtils this_$iv$iv = CastUtils.INSTANCE;
        boolean $i$f$cast = false;
        boolean value = (Boolean)value$iv;
        if (value) {
            this.code.exec(builder);
        } else {
            StatementSeq statementSeq = this.elseCode;
            if (statementSeq != null) {
                statementSeq.exec(builder);
            }
        }
    }

    private final boolean execCondition() {
        boolean $i$f$execCondition = false;
        Object value = this.getCondition().exec();
        CastUtils castUtils = CastUtils.INSTANCE;
        KClass type$iv = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
        boolean $i$f$check = false;
        if (!type$iv.isInstance(value)) {
            throw new ParserException("failed casting result of " + this.getCondition() + " (" + value + ") to Boolean");
        }
        CastUtils this_$iv = CastUtils.INSTANCE;
        boolean $i$f$cast = false;
        return (Boolean)value;
    }

    @Override
    public void buildSyntaxString(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!(this.condition instanceof IfDef) && !(this.condition instanceof IfNotDef)) {
            builder.append("if ");
        }
        this.condition.buildSyntaxString(builder);
        builder.append(" ");
        this.code.buildSyntaxString(builder);
        this.buildSyntaxStringForElseCode(builder);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSyntaxStringForElseCode(StringBuilder builder) {
        if (this.elseCode != null) {
            builder.append(" ");
            if (this.elseCode.getSeq().size() == 1 && this.elseCode.getSeq().get(0) instanceof If) {
                void var3_3;
                CastUtils castUtils = CastUtils.INSTANCE;
                Statement t$iv = this.elseCode.getSeq().get(0);
                boolean $i$f$cast = false;
                ((If)var3_3).buildSyntaxStringForElseBranch(builder);
            } else {
                builder.append("else ");
                this.elseCode.buildSyntaxString(builder);
            }
        }
    }

    private final void buildSyntaxStringForElseBranch(StringBuilder builder) {
        builder.append("elif ");
        this.condition.buildSyntaxString(builder);
        builder.append(" ");
        this.code.buildSyntaxString(builder);
        this.buildSyntaxStringForElseCode(builder);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        If cfr_ignored_0 = (If)other;
        if (!Intrinsics.areEqual((Object)this.condition, (Object)((If)other).condition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.code, (Object)((If)other).code)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.elseCode, (Object)((If)other).elseCode);
    }

    public int hashCode() {
        int n;
        int result = this.condition.hashCode();
        result = 31 * result + this.code.hashCode();
        StatementSeq statementSeq = this.elseCode;
        result = 31 * result + (statementSeq == null ? 0 : (n = statementSeq.hashCode()));
        return result;
    }

    @JvmOverloads
    public If(@NotNull PreprocessorContext context, @NotNull Exp condition, @NotNull StatementSeq code) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(context, condition, code, null, 8, null);
    }
}

