/*
 * Decompiled with CFR 0.152.
 */
package vpreprocessor.ast;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vpreprocessor.PreprocessorContext;
import vpreprocessor.ast.AbstractAST;
import vpreprocessor.ast.Exp;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lvpreprocessor/ast/Invocation;", "Lvpreprocessor/ast/AbstractAST;", "Lvpreprocessor/ast/Exp;", "context", "Lvpreprocessor/PreprocessorContext;", "function", "", "arguments", "", "(Lvpreprocessor/PreprocessorContext;Ljava/lang/String;Ljava/util/List;)V", "getArguments", "()Ljava/util/List;", "getContext", "()Lvpreprocessor/PreprocessorContext;", "getFunction", "()Ljava/lang/String;", "buildSyntaxString", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equals", "", "other", "", "exec", "hashCode", "", "vjson"})
public final class Invocation
extends AbstractAST
implements Exp {
    @NotNull
    private final PreprocessorContext context;
    @NotNull
    private final String function;
    @NotNull
    private final List<Exp> arguments;

    public Invocation(@NotNull PreprocessorContext context, @NotNull String function, @NotNull List<? extends Exp> arguments) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.context = context;
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    @NotNull
    public PreprocessorContext getContext() {
        return this.context;
    }

    @NotNull
    public final String getFunction() {
        return this.function;
    }

    @NotNull
    public final List<Exp> getArguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public Object exec() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void buildSyntaxString(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.append(this.function).append("(");
        boolean isFirst = true;
        for (Exp arg : this.arguments) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            arg.buildSyntaxString(builder);
        }
        builder.append(")");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        Invocation cfr_ignored_0 = (Invocation)other;
        if (!Intrinsics.areEqual((Object)this.function, (Object)((Invocation)other).function)) {
            return false;
        }
        return Intrinsics.areEqual(this.arguments, ((Invocation)other).arguments);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + ((Object)this.arguments).hashCode();
        return result;
    }
}

