/*
 * Decompiled with CFR 0.152.
 */
package vpreprocessor.ast;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vpreprocessor.PreprocessorContext;
import vpreprocessor.ast.AbstractAST;
import vpreprocessor.ast.Statement;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0014\u0010\u0015\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lvpreprocessor/ast/StatementSeq;", "Lvpreprocessor/ast/AbstractAST;", "Lvpreprocessor/ast/Statement;", "context", "Lvpreprocessor/PreprocessorContext;", "seq", "", "(Lvpreprocessor/PreprocessorContext;Ljava/util/List;)V", "getContext", "()Lvpreprocessor/PreprocessorContext;", "getSeq", "()Ljava/util/List;", "buildSyntaxString", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equals", "", "other", "", "exec", "hashCode", "", "vjson"})
public final class StatementSeq
extends AbstractAST
implements Statement {
    @NotNull
    private final PreprocessorContext context;
    @NotNull
    private final List<Statement> seq;

    public StatementSeq(@NotNull PreprocessorContext context, @NotNull List<? extends Statement> seq) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(seq, (String)"seq");
        this.context = context;
        this.seq = seq;
    }

    @Override
    @NotNull
    public PreprocessorContext getContext() {
        return this.context;
    }

    @NotNull
    public final List<Statement> getSeq() {
        return this.seq;
    }

    @Override
    public void exec(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        for (Statement stmt : this.seq) {
            stmt.exec(builder);
        }
    }

    @Override
    public void buildSyntaxString(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.append("{");
        for (Statement exp : this.seq) {
            builder.append(" ");
            exp.buildSyntaxString(builder);
        }
        Collection collection = this.seq;
        boolean bl = false;
        if (!collection.isEmpty()) {
            builder.append(" ");
        }
        builder.append("}");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        StatementSeq cfr_ignored_0 = (StatementSeq)other;
        return Intrinsics.areEqual(this.seq, ((StatementSeq)other).seq);
    }

    public int hashCode() {
        return ((Object)this.seq).hashCode();
    }
}

