/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class BuildCommand {
    private String name;
    private String triggers;
    private Map arguments;

    public BuildCommand() {
    }

    public BuildCommand(String name) {
        this(name, null);
    }

    public BuildCommand(String name, Map arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public BuildCommand(String name, String argName, String argValue) {
        this.name = name;
        this.arguments = new Properties();
        this.arguments.put(argName, argValue);
    }

    public BuildCommand(String name, String triggers, Map arguments) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        this.name = name;
        this.triggers = triggers;
        this.arguments = arguments == null ? new HashMap() : new HashMap(arguments);
    }

    public BuildCommand(Xpp3Dom node) {
        Xpp3Dom nameNode = node.getChild("name");
        if (nameNode == null) {
            throw new IllegalArgumentException("No name node.");
        }
        this.name = nameNode.getValue();
        Xpp3Dom triggersNode = node.getChild("triggers");
        if (triggersNode != null) {
            this.triggers = triggersNode.getValue();
        }
        Xpp3Dom argumentsNode = node.getChild("arguments");
        this.arguments = new HashMap();
        if (argumentsNode != null) {
            for (int i = 0; i < argumentsNode.getChildCount(); ++i) {
                Xpp3Dom entry = argumentsNode.getChild(i);
                if (!entry.getName().equals("dictionary")) continue;
                Xpp3Dom key = entry.getChild("key");
                Xpp3Dom value = entry.getChild("value");
                if (key == null || value == null) continue;
                this.arguments.put(key.getValue(), value.getValue());
            }
        }
    }

    public void print(XMLWriter writer) {
        writer.startElement("buildCommand");
        writer.startElement("name");
        writer.writeText(this.name);
        writer.endElement();
        if (!StringUtils.isEmpty((String)this.triggers)) {
            writer.startElement("triggers");
            writer.writeText(this.triggers);
            writer.endElement();
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            writer.startElement("arguments");
            writer.startElement("dictionary");
            for (Object o : this.arguments.keySet()) {
                String key = (String)o;
                writer.startElement("key");
                writer.writeText(key);
                writer.endElement();
                writer.startElement("value");
                writer.writeText((String)this.arguments.get(key));
                writer.endElement();
            }
            writer.endElement();
            writer.endElement();
        }
        writer.endElement();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildCommand) {
            BuildCommand b = (BuildCommand)obj;
            return this.name.equals(b.name) && (this.triggers == null ? b.triggers == null : this.triggers.equals(b.triggers)) && (this.arguments == null || this.arguments.isEmpty() ? b.arguments == null || b.arguments.isEmpty() : this.arguments.equals(b.arguments));
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + (this.triggers == null ? 0 : 13 * this.triggers.hashCode()) + (this.arguments == null ? 0 : 17 * this.arguments.hashCode());
    }
}

