/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.StringUtils;

public class EclipseSourceDir
implements Comparable {
    private static final String PATTERN_SEPARATOR = "|";
    private String path;
    private String output;
    private List include;
    private List exclude;
    private boolean isResource;
    private boolean test;
    private boolean filtering;

    public EclipseSourceDir(String path, String output, boolean isResource, boolean test, List include, List exclude, boolean filtering) {
        this.setPath(path);
        this.output = output;
        this.isResource = isResource;
        this.test = test;
        this.setInclude(include);
        this.setExclude(exclude);
        this.filtering = filtering;
    }

    public List getExclude() {
        return this.exclude;
    }

    public void setExclude(List exclude) {
        this.exclude = new ArrayList();
        if (exclude != null) {
            this.exclude.addAll(exclude);
        }
    }

    public List getInclude() {
        return this.include;
    }

    public void setInclude(List include) {
        this.include = new ArrayList();
        if (include != null) {
            this.include.addAll(include);
        }
    }

    public String getExcludeAsString() {
        return StringUtils.join(this.exclude.iterator(), (String)PATTERN_SEPARATOR);
    }

    public String getIncludeAsString() {
        return StringUtils.join(this.include.iterator(), (String)PATTERN_SEPARATOR);
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = IdeUtils.fixSeparator(path);
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public boolean isResource() {
        return this.isResource;
    }

    public boolean isFiltering() {
        return this.filtering;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof EclipseSourceDir && this.path.equals(((EclipseSourceDir)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public int compareTo(Object obj) {
        return this.path.compareTo(((EclipseSourceDir)obj).path);
    }

    public String toString() {
        return (this.isResource ? "resource " : "source ") + this.path + ": output=" + this.output + ", include=[" + this.getIncludeAsString() + "], exclude=[" + this.getExcludeAsString() + "], test=" + this.test + ", filtering=" + this.filtering;
    }

    public boolean merge(EclipseSourceDir mergeWith) throws MojoExecutionException {
        if (this.isResource != mergeWith.isResource) {
            if (this.isResource) {
                this.output = mergeWith.output;
            }
            this.isResource = false;
            this.setInclude(null);
            this.setExclude(null);
        } else {
            LinkedHashSet includesAsSet = new LinkedHashSet();
            if (!this.include.isEmpty() && !mergeWith.include.isEmpty()) {
                includesAsSet.addAll(this.include);
                includesAsSet.addAll(mergeWith.include);
            }
            this.include = new ArrayList(includesAsSet);
            LinkedHashSet excludesAsSet = new LinkedHashSet();
            excludesAsSet.addAll(this.exclude);
            excludesAsSet.addAll(mergeWith.exclude);
            this.exclude = new ArrayList(excludesAsSet);
        }
        if (!StringUtils.equals((String)this.output, (String)mergeWith.output)) {
            return false;
        }
        if (this.test != mergeWith.test) {
            return false;
        }
        return this.filtering == mergeWith.filtering;
    }
}

