/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.osgiplugin.EclipseOsgiPlugin;
import org.apache.maven.plugin.eclipse.osgiplugin.ExplodedPlugin;
import org.apache.maven.plugin.eclipse.osgiplugin.PackagedPlugin;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.utils.WriterFactory;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="to-maven", requiresProject=false)
public class EclipseToMavenMojo
extends AbstractMojo
implements Contextualizable {
    private static final Pattern DEPLOYTO_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    private static final Pattern VERSION_PATTERN = Pattern.compile("(([0-9]+\\.)+[0-9]+)");
    private static final Pattern SOURCE_PATTERN = Pattern.compile(".+:.+\\.source:.+");
    private static final String ANY_VERSION = "[0,)";
    private PlexusContainer container;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    protected ArtifactInstaller installer;
    @Component
    private ArtifactDeployer deployer;
    @Parameter(property="eclipseDir")
    private File eclipseDir;
    @Component
    protected InputHandler inputHandler;
    @Parameter(property="stripQualifier", defaultValue="false")
    private boolean stripQualifier;
    @Parameter(property="deployTo")
    private String deployTo;
    @Parameter(property="groupIdTokens", defaultValue="-1")
    private int groupIdTokens;
    @Parameter(property="bundleNameAsArtifactId", defaultValue="false")
    private boolean useBundleNameAsArtifactId;
    @Parameter(property="attachSourcePlugins", defaultValue="false")
    private boolean attachSourcePlugins;
    @Parameter(property="resolveVersionRanges", defaultValue="false")
    private boolean resolveVersionRanges;
    @Parameter(property="resolveRecommendedVersions", defaultValue="false")
    private boolean resolveRecommendedVersions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.eclipseDir == null) {
            String eclipseDirString;
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.eclipseDirectoryPrompt"));
            try {
                eclipseDirString = this.inputHandler.readLine();
            }
            catch (IOException e) {
                throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.errorreadingfromstandardinput"));
            }
            this.eclipseDir = new File(eclipseDirString);
        }
        if (!this.eclipseDir.isDirectory()) {
            throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.directoydoesnotexist", this.eclipseDir.getAbsolutePath()));
        }
        File pluginDir = new File(this.eclipseDir, "plugins");
        if (!pluginDir.isDirectory()) {
            throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.plugindirectorydoesnotexist", pluginDir.getAbsolutePath()));
        }
        File[] files = pluginDir.listFiles();
        ArtifactRepository remoteRepo = this.resolveRemoteRepo();
        if (remoteRepo != null) {
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.remoterepositorydeployto", this.deployTo));
        }
        HashMap<String, EclipseOsgiPlugin> plugins = new HashMap<String, EclipseOsgiPlugin>();
        HashMap<String, Model> models = new HashMap<String, Model>();
        this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.searchingplugins", pluginDir.getAbsolutePath()));
        for (File file : files) {
            this.getLog().debug((CharSequence)Messages.getString("EclipseToMavenMojo.processingfile", file.getAbsolutePath()));
            this.processFile(file, plugins, models);
        }
        this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.pluginsfound", new Object[]{pluginDir.getAbsolutePath(), plugins.size()}));
        if (this.attachSourcePlugins) {
            HashSet<String> sourceKeys = new HashSet<String>();
            for (String key : plugins.keySet()) {
                if (!SOURCE_PATTERN.matcher(key).matches()) continue;
                sourceKeys.add(key);
            }
            models.keySet().removeAll(sourceKeys);
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.attachedsourceplugins", sourceKeys.size()));
        }
        this.resolveVersions(models);
        this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.deploymainartifacts", models.size()));
        int i = 1;
        try {
            for (String key : models.keySet()) {
                this.getLog().debug((CharSequence)Messages.getString("EclipseToMavenMojo.processingplugin", new Object[]{i++, models.keySet().size()}));
                Model model = (Model)models.get(key);
                this.writeArtifact(model, plugins, remoteRepo);
            }
        }
        finally {
            this.getLog().info((CharSequence)Messages.getString("EclipseToMavenMojo.deployedmainartifacts", i));
        }
    }

    protected void processFile(File file, Map<String, EclipseOsgiPlugin> plugins, Map<String, Model> models) throws MojoExecutionException, MojoFailureException {
        EclipseOsgiPlugin plugin = this.getEclipsePlugin(file);
        if (plugin == null) {
            this.getLog().warn((CharSequence)Messages.getString("EclipseToMavenMojo.skippingfile", file.getAbsolutePath()));
            return;
        }
        Model model = this.createModel(plugin);
        if (model == null) {
            return;
        }
        this.processPlugin(plugin, model, plugins, models);
    }

    protected void processPlugin(EclipseOsgiPlugin plugin, Model model, Map<String, EclipseOsgiPlugin> plugins, Map<String, Model> models) throws MojoExecutionException, MojoFailureException {
        plugins.put(this.getKey(model), plugin);
        models.put(this.getKey(model), model);
    }

    protected String getKey(Model model) {
        return model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    protected String getSourceKey(Model model) {
        return model.getGroupId() + ":" + model.getArtifactId() + ".source:" + model.getVersion();
    }

    private String getModuleKey(Model model) {
        return model.getGroupId() + ":" + model.getArtifactId();
    }

    private String getModuleKey(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId();
    }

    protected void resolveVersions(Map<String, Model> models) throws MojoFailureException {
        HashMap allVersions = new HashMap();
        for (Model model : models.values()) {
            String key = this.getModuleKey(model);
            TreeSet versions = (TreeSet)allVersions.get(key);
            if (versions == null) {
                versions = new TreeSet(Collections.reverseOrder());
                allVersions.put(key, versions);
            }
            versions.add(new DefaultArtifactVersion(model.getVersion()));
        }
        for (Model model : models.values()) {
            block9: for (Dependency dep : model.getDependencies()) {
                try {
                    Set versions;
                    String key;
                    String versionRange = dep.getVersion();
                    if (ANY_VERSION.equals(versionRange)) {
                        key = this.getModuleKey(dep);
                        versions = (Set)allVersions.get(key);
                        if (versions == null) continue;
                        dep.setVersion(((ArtifactVersion)versions.iterator().next()).toString());
                        continue;
                    }
                    if ("[(".indexOf(versionRange.charAt(0)) == 0) {
                        if (!this.resolveVersionRanges || (versions = (Set)allVersions.get(key = this.getModuleKey(dep))) == null) continue;
                        this.selectVersion(dep, versionRange, versions);
                        continue;
                    }
                    if (!this.resolveRecommendedVersions) continue;
                    key = this.getModuleKey(dep);
                    versions = (Set)allVersions.get(key);
                    DefaultArtifactVersion version = new DefaultArtifactVersion(versionRange);
                    if (versions == null || versions.contains(version)) continue;
                    String lowerBound = String.format("[%d.%d.%d,", version.getMajorVersion(), version.getMinorVersion(), version.getIncrementalVersion());
                    for (int i = 3; i > 0; --i) {
                        String upperBound = null;
                        switch (i) {
                            case 3: {
                                upperBound = String.format("%d.%d.%d)", version.getMajorVersion(), version.getMinorVersion(), version.getIncrementalVersion() + 1);
                                break;
                            }
                            case 2: {
                                upperBound = String.format("%d.%d)", version.getMajorVersion(), version.getMinorVersion() + 1);
                                break;
                            }
                            case 1: {
                                upperBound = String.format("%d)", version.getMajorVersion() + 1);
                                break;
                            }
                        }
                        if (this.selectVersion(dep, lowerBound + upperBound, versions)) continue block9;
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoFailureException(Messages.getString("EclipseToMavenMojo.invalidversionrange", new Object[]{dep, this.getKey(model)}));
                }
            }
        }
    }

    private boolean selectVersion(Dependency dependency, String versionRange, Set<ArtifactVersion> versions) throws InvalidVersionSpecificationException {
        VersionRange range = VersionRange.createFromVersionSpec((String)versionRange);
        for (ArtifactVersion version : versions) {
            if (!range.containsVersion(version)) continue;
            dependency.setVersion(version.toString());
            return true;
        }
        return false;
    }

    private EclipseOsgiPlugin getEclipsePlugin(File file) throws MojoExecutionException {
        if (file.isDirectory()) {
            return new ExplodedPlugin(file);
        }
        if (file.getName().endsWith(".jar")) {
            try {
                return new PackagedPlugin(file);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.unabletoaccessjar", file.getAbsolutePath()), (Exception)e);
            }
        }
        return null;
    }

    private Model createModel(EclipseOsgiPlugin plugin) throws MojoExecutionException {
        String requireBundle;
        String name;
        String version;
        String bundleName;
        try {
            if (!plugin.hasManifest()) {
                this.getLog().warn((CharSequence)Messages.getString("EclipseToMavenMojo.plugindoesnothavemanifest", plugin));
                return null;
            }
            Analyzer analyzer = new Analyzer();
            Map bundleSymbolicNameHeader = analyzer.parseHeader(plugin.getManifestAttribute("Bundle-SymbolicName"));
            bundleName = (String)bundleSymbolicNameHeader.keySet().iterator().next();
            version = plugin.getManifestAttribute("Bundle-Version");
            if (bundleName == null || version == null) {
                this.getLog().error((CharSequence)Messages.getString("EclipseToMavenMojo.unabletoreadbundlefrommanifest"));
                return null;
            }
            version = this.osgiVersionToMavenVersion(version);
            name = plugin.getManifestAttribute("Bundle-Name");
            requireBundle = plugin.getManifestAttribute("Require-Bundle");
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorprocessingplugin", plugin), (Exception)e);
        }
        Dependency[] deps = this.parseDependencies(requireBundle);
        String groupId = this.createGroupId(bundleName);
        String artifactId = this.createArtifactId(bundleName);
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setName(name);
        model.setVersion(version);
        model.setProperties(plugin.getPomProperties());
        if (groupId.startsWith("org.eclipse")) {
            License license = new License();
            license.setName("Eclipse Public License - v 1.0");
            license.setUrl("http://www.eclipse.org/org/documents/epl-v10.html");
            model.addLicense(license);
        }
        if (deps.length > 0) {
            for (Dependency dep : deps) {
                model.getDependencies().add(dep);
            }
        }
        return model;
    }

    private void writeArtifact(Model model, Map<String, EclipseOsgiPlugin> plugins, ArtifactRepository remoteRepo) throws MojoExecutionException {
        Writer fw = null;
        File pomFile = null;
        Artifact pomArtifact = this.artifactFactory.createArtifact(model.getGroupId(), model.getArtifactId(), model.getVersion(), null, "pom");
        Artifact artifact = this.artifactFactory.createArtifact(model.getGroupId(), model.getArtifactId(), model.getVersion(), null, "jar");
        Artifact sourcesArtifact = !this.attachSourcePlugins ? null : this.artifactFactory.createArtifactWithClassifier(model.getGroupId(), model.getArtifactId(), model.getVersion(), "jar", "sources");
        try {
            pomFile = File.createTempFile("pom-", ".xml");
            fw = WriterFactory.newWriter((File)pomFile, (String)"UTF-8");
            model.setModelEncoding("UTF-8");
            pomFile.deleteOnExit();
            new MavenXpp3Writer().write(fw, model);
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(pomArtifact, pomFile);
            pomArtifact.addMetadata((ArtifactMetadata)metadata);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorwritingtemporarypom", e.getMessage()), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        EclipseOsgiPlugin plugin = plugins.get(this.getKey(model));
        EclipseOsgiPlugin sourcePlugin = this.attachSourcePlugins ? plugins.get(this.getSourceKey(model)) : null;
        File jarFile = null;
        File jarFileSource = null;
        try {
            jarFile = plugin.getJarFile();
            File file = jarFileSource = sourcePlugin != null ? sourcePlugin.getJarFile() : null;
            if (remoteRepo != null) {
                this.deployer.deploy(pomFile, pomArtifact, remoteRepo, this.localRepository);
                this.deployer.deploy(jarFile, artifact, remoteRepo, this.localRepository);
                if (sourcePlugin != null) {
                    this.deployer.deploy(jarFileSource, sourcesArtifact, remoteRepo, this.localRepository);
                }
            } else {
                this.installer.install(pomFile, pomArtifact, this.localRepository);
                this.installer.install(jarFile, artifact, this.localRepository);
                if (sourcePlugin != null) {
                    this.installer.install(jarFileSource, sourcesArtifact, this.localRepository);
                }
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errordeployartifacttorepository"), (Exception)((Object)e));
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorinstallartifacttorepository"), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.errorgettingjarfileforplugin", jarFile != null ? sourcePlugin : plugin), (Exception)e);
        }
        finally {
            pomFile.delete();
        }
    }

    protected String osgiVersionToMavenVersion(String version) {
        return this.osgiVersionToMavenVersion(version, null, this.stripQualifier);
    }

    protected String osgiVersionToMavenVersion(String version, String forcedQualifier, boolean stripQualifier) {
        if (stripQualifier && StringUtils.countMatches((String)version, (String)".") > 2) {
            version = StringUtils.substring((String)version, (int)0, (int)version.lastIndexOf(46));
        } else if (StringUtils.countMatches((String)version, (String)".") > 2) {
            int lastDot = version.lastIndexOf(46);
            version = StringUtils.isNotEmpty((String)forcedQualifier) ? StringUtils.substring((String)version, (int)0, (int)lastDot) + "-" + forcedQualifier : StringUtils.substring((String)version, (int)0, (int)lastDot) + "-" + StringUtils.substring((String)version, (int)(lastDot + 1), (int)version.length());
        }
        return new DefaultArtifactVersion(version).toString();
    }

    private ArtifactRepository resolveRemoteRepo() throws MojoFailureException, MojoExecutionException {
        if (this.deployTo != null) {
            ArtifactRepositoryLayout repoLayout;
            Matcher matcher = DEPLOYTO_PATTERN.matcher(this.deployTo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)this.deployTo, Messages.getString("EclipseToMavenMojo.invalidsyntaxforrepository"), Messages.getString("EclipseToMavenMojo.invalidremoterepositorysyntax"));
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            try {
                repoLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, layout);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException(Messages.getString("EclipseToMavenMojo.cannotfindrepositorylayout", layout), (Exception)((Object)e));
            }
            return this.artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, repoLayout, true);
        }
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected String createGroupId(String bundleName) {
        int i = 0;
        int t = this.groupIdTokens;
        if (t < 0) {
            i = bundleName.lastIndexOf(46);
        } else if (t > 0) {
            do {
                i = bundleName.indexOf(46, i + 1);
            } while (--t > 0 && i > 0);
        }
        if (i > 0) {
            return bundleName.substring(0, i);
        }
        return bundleName;
    }

    protected String createArtifactId(String bundleName) {
        String groupId;
        if (!this.useBundleNameAsArtifactId && bundleName.startsWith((groupId = this.createGroupId(bundleName)) + '.')) {
            return bundleName.substring(groupId.length() + 1);
        }
        return bundleName;
    }

    protected Dependency[] parseDependencies(String requireBundle) {
        if (requireBundle == null) {
            return new Dependency[0];
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Analyzer analyzer = new Analyzer();
        Map requireBundleHeader = analyzer.parseHeader(requireBundle);
        for (Map.Entry entry : requireBundleHeader.entrySet()) {
            String bundleName = (String)entry.getKey();
            Map attributes = (Map)entry.getValue();
            String version = (String)attributes.get("Bundle-Version".toLowerCase());
            boolean optional = "optional".equals(attributes.get("resolution:"));
            if (version == null) {
                this.getLog().debug((CharSequence)Messages.getString("EclipseToMavenMojo.missingversionforbundle", bundleName));
                version = ANY_VERSION;
            }
            version = this.fixBuildNumberSeparator(version);
            Dependency dep = new Dependency();
            dep.setGroupId(this.createGroupId(bundleName));
            dep.setArtifactId(this.createArtifactId(bundleName));
            dep.setVersion(version);
            dep.setOptional(optional);
            dependencies.add(dep);
        }
        return dependencies.toArray(new Dependency[dependencies.size()]);
    }

    protected String fixBuildNumberSeparator(String versionRange) {
        if (versionRange == null) {
            return null;
        }
        StringBuffer newVersionRange = new StringBuffer();
        Matcher matcher = VERSION_PATTERN.matcher(versionRange);
        while (matcher.find()) {
            String group = matcher.group();
            if (StringUtils.countMatches((String)group, (String)".") > 2) {
                int lastDot = group.lastIndexOf(46);
                group = StringUtils.substring((String)group, (int)0, (int)lastDot) + "-" + StringUtils.substring((String)group, (int)(lastDot + 1), (int)group.length());
            }
            matcher.appendReplacement(newVersionRange, group);
        }
        matcher.appendTail(newVersionRange);
        return newVersionRange.toString();
    }
}

