/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.BuildCommand;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.eclipse.writers.myeclipse.MyEclipseHibernateWriter;
import org.apache.maven.plugin.eclipse.writers.myeclipse.MyEclipseMetadataWriter;
import org.apache.maven.plugin.eclipse.writers.myeclipse.MyEclipseSpringBeansWriter;
import org.apache.maven.plugin.eclipse.writers.myeclipse.MyEclipseStrutsDataWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeUtils;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="myeclipse")
@Execute(phase=LifecyclePhase.GENERATE_RESOURCES)
public class MyEclipsePlugin
extends EclipsePlugin {
    private static final String MYECLIPSE_EAR_NATURE = "com.genuitec.eclipse.j2eedt.core.earnature";
    private static final String MYECLIPSE_WEB_NATURE = "com.genuitec.eclipse.j2eedt.core.webnature";
    private static final String MYECLISPE_SPRING_NATURE = "com.genuitec.eclipse.springframework.springnature";
    private static final String MYECLIPSE_STRUTS_NATURE = "com.genuitec.eclipse.cross.easystruts.eclipse.easystrutsnature";
    private static final String MYECLIPSE_HIBERNATE_NATURE = "com.genuitec.eclipse.hibernate.hibernatenature";
    private static final String MYECLIPSE_DEPLOYMENT_DESCRIPTOR_VALIDATOR_BUILDER = "com.genuitec.eclipse.j2eedt.core.DeploymentDescriptorValidator";
    private static final String MYECLIPSE_WEB_CLASSPATH_BUILDER = "com.genuitec.eclipse.j2eedt.core.WebClasspathBuilder";
    private static final String MYECLIPSE_J2EE_PROJECT_VALIDATOR_BUILDER = "com.genuitec.eclipse.j2eedt.core.J2EEProjectValidator";
    private static final String MYECLIPSE_SPRING_BUILDER = "com.genuitec.eclipse.springframework.springbuilder";
    private static final String MYECLIPSE_HIBERNATE_BUILDER = "com.genuitec.eclipse.hibernate.HibernateBuilder";
    private static final String MYECLIPSE_J2EE_14_CLASSPATH_CONTAINER = "com.genuitec.eclipse.j2eedt.core.J2EE14_CONTAINER";
    private static final String MYECLIPSE_J2EE_13_CLASSPATH_CONTAINER = "com.genuitec.eclipse.j2eedt.core.J2EE13_CONTAINER";
    @Parameter
    private Map spring;
    @Parameter
    private Map hibernate;
    @Parameter
    private Map struts;

    @Override
    protected void writeConfigurationExtras(EclipseWriterConfig config) throws MojoExecutionException {
        super.writeConfigurationExtras(config);
        if (this.isJavaProject() && "war".equals(this.project.getPackaging())) {
            EclipseSourceDir[] sourceDirs;
            String warSourceDirectory = IdeUtils.getPluginSetting(config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", "/src/main/webapp");
            for (EclipseSourceDir sourceDir : sourceDirs = config.getSourceDirs()) {
                if (sourceDir.isTest()) continue;
                sourceDir.setOutput(warSourceDirectory + "/WEB-INF/classes");
            }
        }
        new MyEclipseMetadataWriter().init(this.getLog(), config).write();
        if (this.getStruts() != null) {
            new MyEclipseStrutsDataWriter(this.getStruts()).init(this.getLog(), config).write();
        }
        if (this.getSpring() != null) {
            new MyEclipseSpringBeansWriter(this.getSpring()).init(this.getLog(), config).write();
        }
        if (this.getHibernate() != null) {
            new MyEclipseHibernateWriter(this.getHibernate()).init(this.getLog(), config).write();
        }
    }

    @Override
    protected void fillDefaultBuilders(String packaging) {
        ArrayList<String> commands = new ArrayList<String>();
        super.fillDefaultBuilders(packaging);
        if ("ear".equals(packaging)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"EAR packaging does not need specific builders");
            }
        } else if ("war".equals(packaging)) {
            commands.add(MYECLIPSE_DEPLOYMENT_DESCRIPTOR_VALIDATOR_BUILDER);
            commands.add(MYECLIPSE_J2EE_PROJECT_VALIDATOR_BUILDER);
            commands.add(MYECLIPSE_WEB_CLASSPATH_BUILDER);
            if (!this.getBuildcommands().contains(new BuildCommand("org.eclipse.wst.validation.validationbuilder"))) {
                commands.add("org.eclipse.wst.validation.validationbuilder");
            }
        } else if ("ejb".equals(packaging)) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"EJB packaging is not implemented yet");
            }
        } else if (this.isJavaProject() && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"JAR packaging does not need specific builders");
        }
        if (this.getSpring() != null) {
            commands.add(MYECLIPSE_SPRING_BUILDER);
        }
        if (this.getHibernate() != null) {
            commands.add(MYECLIPSE_HIBERNATE_BUILDER);
        }
        this.convertBuildCommandList(commands);
        this.getBuildcommands().addAll(commands);
    }

    @Override
    protected void fillDefaultNatures(String packaging) {
        ArrayList<String> natures = new ArrayList<String>();
        super.fillDefaultNatures(packaging);
        if ("ear".equals(packaging)) {
            natures.add(MYECLIPSE_EAR_NATURE);
        } else if ("war".equals(packaging)) {
            natures.add(MYECLIPSE_WEB_NATURE);
        } else if ("ejb".equals(packaging)) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"EJB packaging is not implemented yet");
            }
        } else if (this.isJavaProject() && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"JAR projects does not need specific natures");
        }
        if (this.getSpring() != null) {
            natures.add(MYECLISPE_SPRING_NATURE);
        }
        if (this.getStruts() != null) {
            natures.add(MYECLIPSE_STRUTS_NATURE);
        }
        if (this.getHibernate() != null) {
            natures.add(MYECLIPSE_HIBERNATE_NATURE);
        }
        this.getProjectnatures().addAll(natures);
    }

    @Override
    protected void fillDefaultClasspathContainers(String packaging) {
        super.fillDefaultClasspathContainers(packaging);
        if ("war".equals(packaging)) {
            String j2eeVersion = this.jeeversion != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.jeeversion).getJeeVersion() : JeeUtils.getJeeDescriptorFromServletVersion(JeeUtils.resolveServletVersion(this.project)).getJeeVersion();
            if ("1.3".equals(j2eeVersion)) {
                this.getClasspathContainers().add(MYECLIPSE_J2EE_13_CLASSPATH_CONTAINER);
            } else if ("1.4".equals(j2eeVersion)) {
                this.getClasspathContainers().add(MYECLIPSE_J2EE_14_CLASSPATH_CONTAINER);
            }
        }
    }

    public Map getSpring() {
        return this.spring;
    }

    public void setSpring(Map spring) {
        this.spring = spring;
    }

    public Map getHibernate() {
        return this.hibernate;
    }

    public void setHibernate(Map hibernate) {
        this.hibernate = hibernate;
    }

    public Map getStruts() {
        return this.struts;
    }

    public void setStruts(Map struts) {
        this.struts = struts;
    }
}

