/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.osgiplugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.plugin.eclipse.osgiplugin.EclipseOsgiPlugin;

public abstract class AbstractEclipseOsgiPlugin
implements EclipseOsgiPlugin {
    private File file;
    private Properties pluginProperties;

    public AbstractEclipseOsgiPlugin(File file) {
        this.setFile(file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getFile().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getPluginProperties() throws IOException {
        if (this.pluginProperties == null) {
            JarFile file = this.getJar();
            InputStream pluginPropertiesStream = null;
            try {
                this.pluginProperties = new Properties();
                ZipEntry jarEntry = file.getEntry("plugin.properties");
                if (jarEntry != null) {
                    pluginPropertiesStream = file.getInputStream(jarEntry);
                    this.pluginProperties.load(pluginPropertiesStream);
                }
            }
            finally {
                if (pluginPropertiesStream != null) {
                    try {
                        pluginPropertiesStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.pluginProperties;
    }

    @Override
    public Properties getPomProperties() {
        return new Properties();
    }

    @Override
    public String getManifestAttribute(String key) throws IOException {
        String valueFromProperties;
        String value = this.getManifest().getMainAttributes().getValue(key);
        if (value == null) {
            return null;
        }
        if (value.startsWith("%") && (valueFromProperties = this.getPluginProperties().getProperty(value.substring(1))) != null) {
            value = valueFromProperties;
        }
        return value;
    }
}

